/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.EmptyPathSegmentException;
import com.acmerobotics.roadrunner.path.LineSegment;
import com.acmerobotics.roadrunner.path.ParametricCurve;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.path.PathContinuityViolationException;
import com.acmerobotics.roadrunner.path.PathSegment;
import com.acmerobotics.roadrunner.path.QuinticSpline;
import com.acmerobotics.roadrunner.path.heading.ConstantInterpolator;
import com.acmerobotics.roadrunner.path.heading.HeadingInterpolator;
import com.acmerobotics.roadrunner.path.heading.LinearInterpolator;
import com.acmerobotics.roadrunner.path.heading.SplineInterpolator;
import com.acmerobotics.roadrunner.path.heading.TangentInterpolator;
import com.acmerobotics.roadrunner.util.Angle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\rB/\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020!H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u00020\u0005H\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020\u0005H\u0002J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0016\u00107\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u00020\u0005J\u0016\u00108\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u00020\u0005J\u0016\u00109\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0005J\u0016\u0010:\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0005J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/acmerobotics/roadrunner/path/PathBuilder;", "", "startPose", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "startTangent", "", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;D)V", "reversed", "", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;Z)V", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "s", "(Lcom/acmerobotics/roadrunner/path/Path;D)V", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;Ljava/lang/Double;Lcom/acmerobotics/roadrunner/path/Path;Ljava/lang/Double;)V", "currentPose", "currentTangent", "Ljava/lang/Double;", "getPath$core", "()Lcom/acmerobotics/roadrunner/path/Path;", "getS$core", "()Ljava/lang/Double;", "segments", "", "Lcom/acmerobotics/roadrunner/path/PathSegment;", "addSegment", "segment", "back", "distance", "build", "forward", "lineTo", "endPosition", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "lineToConstantHeading", "lineToLinearHeading", "endPose", "lineToSplineHeading", "makeConstantInterpolator", "Lcom/acmerobotics/roadrunner/path/heading/ConstantInterpolator;", "makeLine", "Lcom/acmerobotics/roadrunner/path/LineSegment;", "end", "makeLinearInterpolator", "Lcom/acmerobotics/roadrunner/path/heading/LinearInterpolator;", "endHeading", "makeSpline", "Lcom/acmerobotics/roadrunner/path/QuinticSpline;", "endTangent", "makeSplineInterpolator", "Lcom/acmerobotics/roadrunner/path/heading/SplineInterpolator;", "makeTangentInterpolator", "Lcom/acmerobotics/roadrunner/path/heading/TangentInterpolator;", "curve", "Lcom/acmerobotics/roadrunner/path/ParametricCurve;", "splineTo", "splineToConstantHeading", "splineToLinearHeading", "splineToSplineHeading", "strafeLeft", "strafeRight", "strafeTo", "core"})
public final class PathBuilder {
    private Pose2d currentPose;
    private Double currentTangent;
    private List<PathSegment> segments;
    @Nullable
    private final Path path;
    @Nullable
    private final Double s;

    private final LineSegment makeLine(Vector2d end) {
        Pose2d pose2d;
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            pose2d = Path.get$default(path, d, 0.0, 2, null);
        } else {
            Pose2d pose2d2 = this.currentPose;
            pose2d = pose2d2;
            Intrinsics.checkNotNull((Object)pose2d2);
        }
        Pose2d start = pose2d;
        if (start.vec().epsilonEquals(end)) {
            throw (Throwable)new EmptyPathSegmentException();
        }
        return new LineSegment(start.vec(), end);
    }

    /*
     * WARNING - void declaration
     */
    private final QuinticSpline makeSpline(Vector2d endPosition, double endTangent) {
        void startWaypoint;
        Pair pair;
        Pose2d pose2d;
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            pose2d = Path.get$default(path, d, 0.0, 2, null);
        } else {
            Pose2d pose2d2 = this.currentPose;
            pose2d = pose2d2;
            Intrinsics.checkNotNull((Object)pose2d2);
        }
        Pose2d startPose = pose2d;
        if (startPose.vec().epsilonEquals(endPosition)) {
            throw (Throwable)new EmptyPathSegmentException();
        }
        double derivMag = startPose.vec().distTo(endPosition);
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            Vector2d startDeriv = Path.internalDeriv$core$default(path, d, 0.0, 2, null).vec();
            Vector2d startSecondDeriv = Path.internalSecondDeriv$core$default(this.path, this.s, 0.0, 2, null).vec();
            pair = TuplesKt.to((Object)new QuinticSpline.Knot(startPose.vec(), startDeriv, startSecondDeriv), (Object)new QuinticSpline.Knot(endPosition, Vector2d.Companion.polar(derivMag, endTangent), null, 4, null));
        } else {
            Vector2d vector2d = startPose.vec();
            Double d = this.currentTangent;
            Intrinsics.checkNotNull((Object)d);
            pair = TuplesKt.to((Object)new QuinticSpline.Knot(vector2d, Vector2d.Companion.polar(derivMag, d), null, 4, null), (Object)new QuinticSpline.Knot(endPosition, Vector2d.Companion.polar(derivMag, endTangent), null, 4, null));
        }
        Pair pair2 = pair;
        QuinticSpline.Knot knot = (QuinticSpline.Knot)pair2.component1();
        QuinticSpline.Knot endWaypoint = (QuinticSpline.Knot)pair2.component2();
        return new QuinticSpline((QuinticSpline.Knot)startWaypoint, endWaypoint, 0.0, 0.0, 0, 28, null);
    }

    private final TangentInterpolator makeTangentInterpolator(ParametricCurve curve) {
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            HeadingInterpolator prevInterpolator = ((PathSegment)path.segment(d).getFirst()).getInterpolator();
            if (!(prevInterpolator instanceof TangentInterpolator)) {
                throw (Throwable)new PathContinuityViolationException();
            }
            return new TangentInterpolator(((TangentInterpolator)prevInterpolator).getOffset$core());
        }
        double startHeading = curve.tangentAngle(0.0, 0.0);
        Pose2d pose2d = this.currentPose;
        Intrinsics.checkNotNull((Object)pose2d);
        TangentInterpolator interpolator = new TangentInterpolator(pose2d.getHeading() - startHeading);
        interpolator.init(curve);
        return interpolator;
    }

    private final ConstantInterpolator makeConstantInterpolator() {
        Pose2d pose2d = this.currentPose;
        if (pose2d == null) {
            throw (Throwable)new PathContinuityViolationException();
        }
        double currentHeading = pose2d.getHeading();
        return new ConstantInterpolator(currentHeading);
    }

    private final LinearInterpolator makeLinearInterpolator(double endHeading) {
        Pose2d pose2d = this.currentPose;
        if (pose2d == null) {
            throw (Throwable)new PathContinuityViolationException();
        }
        double startHeading = pose2d.getHeading();
        return new LinearInterpolator(startHeading, Angle.normDelta(endHeading - startHeading));
    }

    private final SplineInterpolator makeSplineInterpolator(double endHeading) {
        SplineInterpolator splineInterpolator;
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            splineInterpolator = new SplineInterpolator(Path.get$default(path, d, 0.0, 2, null).getHeading(), endHeading, Path.deriv$default(this.path, this.s, 0.0, 2, null).getHeading(), Path.secondDeriv$default(this.path, this.s, 0.0, 2, null).getHeading(), null, null);
        } else {
            Pose2d pose2d = this.currentPose;
            Double d = pose2d != null ? Double.valueOf(pose2d.getHeading()) : null;
            Intrinsics.checkNotNull((Object)d);
            splineInterpolator = new SplineInterpolator(d, endHeading, null, null, null, null, 60, null);
        }
        return splineInterpolator;
    }

    private final PathBuilder addSegment(PathSegment segment) {
        Collection collection = this.segments;
        boolean bl = false;
        if (!collection.isEmpty()) {
            PathSegment lastSegment = (PathSegment)CollectionsKt.last(this.segments);
            if (!(lastSegment.end().epsilonEqualsHeading(segment.start()) && lastSegment.endDeriv().epsilonEquals(segment.startDeriv()) && lastSegment.endSecondDeriv().vec().epsilonEquals(segment.startSecondDeriv().vec()))) {
                throw (Throwable)new PathContinuityViolationException();
            }
        } else if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            if (!(Path.get$default(path, d, 0.0, 2, null).epsilonEqualsHeading(segment.start()) && Path.deriv$default(this.path, this.s, 0.0, 2, null).epsilonEquals(segment.startDeriv()) && Path.secondDeriv$default(this.path, this.s, 0.0, 2, null).vec().epsilonEquals(segment.startSecondDeriv().vec()))) {
                throw (Throwable)new PathContinuityViolationException();
            }
        }
        this.currentPose = segment.end();
        this.currentTangent = segment.endTangentAngle();
        this.segments.add(segment);
        return this;
    }

    @NotNull
    public final PathBuilder lineTo(@NotNull Vector2d endPosition) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        LineSegment line = this.makeLine(endPosition);
        TangentInterpolator interpolator = this.makeTangentInterpolator(line);
        this.addSegment(new PathSegment(line, interpolator));
        return this;
    }

    @NotNull
    public final PathBuilder lineToConstantHeading(@NotNull Vector2d endPosition) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment(new PathSegment(this.makeLine(endPosition), this.makeConstantInterpolator()));
    }

    @NotNull
    public final PathBuilder strafeTo(@NotNull Vector2d endPosition) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.lineToConstantHeading(endPosition);
    }

    @NotNull
    public final PathBuilder lineToLinearHeading(@NotNull Pose2d endPose) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment(new PathSegment(this.makeLine(endPose.vec()), this.makeLinearInterpolator(endPose.getHeading())));
    }

    @NotNull
    public final PathBuilder lineToSplineHeading(@NotNull Pose2d endPose) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment(new PathSegment(this.makeLine(endPose.vec()), this.makeSplineInterpolator(endPose.getHeading())));
    }

    @NotNull
    public final PathBuilder forward(double distance) {
        Pose2d pose2d;
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            pose2d = Path.get$default(path, d, 0.0, 2, null);
        } else {
            Pose2d pose2d2 = this.currentPose;
            pose2d = pose2d2;
            Intrinsics.checkNotNull((Object)pose2d2);
        }
        Pose2d start = pose2d;
        return this.lineTo(start.vec().plus(Vector2d.Companion.polar(distance, start.getHeading())));
    }

    @NotNull
    public final PathBuilder back(double distance) {
        this.forward(-distance);
        return this;
    }

    @NotNull
    public final PathBuilder strafeLeft(double distance) {
        Pose2d pose2d;
        if (this.currentPose == null) {
            Path path = this.path;
            Intrinsics.checkNotNull((Object)path);
            Double d = this.s;
            Intrinsics.checkNotNull((Object)d);
            pose2d = Path.get$default(path, d, 0.0, 2, null);
        } else {
            Pose2d pose2d2 = this.currentPose;
            pose2d = pose2d2;
            Intrinsics.checkNotNull((Object)pose2d2);
        }
        Pose2d start = pose2d;
        return this.strafeTo(start.vec().plus(Vector2d.Companion.polar(distance, start.getHeading() + 1.5707963267948966)));
    }

    @NotNull
    public final PathBuilder strafeRight(double distance) {
        return this.strafeLeft(-distance);
    }

    @NotNull
    public final PathBuilder splineTo(@NotNull Vector2d endPosition, double endTangent) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        QuinticSpline spline = this.makeSpline(endPosition, endTangent);
        TangentInterpolator interpolator = this.makeTangentInterpolator(spline);
        return this.addSegment(new PathSegment(spline, interpolator));
    }

    @NotNull
    public final PathBuilder splineToConstantHeading(@NotNull Vector2d endPosition, double endTangent) {
        Intrinsics.checkNotNullParameter((Object)endPosition, (String)"endPosition");
        return this.addSegment(new PathSegment(this.makeSpline(endPosition, endTangent), this.makeConstantInterpolator()));
    }

    @NotNull
    public final PathBuilder splineToLinearHeading(@NotNull Pose2d endPose, double endTangent) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment(new PathSegment(this.makeSpline(endPose.vec(), endTangent), this.makeLinearInterpolator(endPose.getHeading())));
    }

    @NotNull
    public final PathBuilder splineToSplineHeading(@NotNull Pose2d endPose, double endTangent) {
        Intrinsics.checkNotNullParameter((Object)endPose, (String)"endPose");
        return this.addSegment(new PathSegment(this.makeSpline(endPose.vec(), endTangent), this.makeSplineInterpolator(endPose.getHeading())));
    }

    @NotNull
    public final Path build() {
        return new Path(this.segments);
    }

    @Nullable
    public final Path getPath$core() {
        return this.path;
    }

    @Nullable
    public final Double getS$core() {
        return this.s;
    }

    private PathBuilder(Pose2d startPose, Double startTangent, Path path, Double s) {
        this.path = path;
        this.s = s;
        this.currentPose = startPose;
        this.currentTangent = startTangent;
        boolean bl = false;
        this.segments = new ArrayList();
    }

    @JvmOverloads
    public PathBuilder(@NotNull Pose2d startPose, double startTangent) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        this(startPose, (Double)startTangent, null, null);
    }

    public /* synthetic */ PathBuilder(Pose2d pose2d, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = pose2d.getHeading();
        }
        this(pose2d, d);
    }

    @JvmOverloads
    public PathBuilder(@NotNull Pose2d startPose) {
        this(startPose, 0.0, 2, null);
    }

    public PathBuilder(@NotNull Pose2d startPose, boolean reversed) {
        Intrinsics.checkNotNullParameter((Object)startPose, (String)"startPose");
        this(startPose, Angle.norm(startPose.getHeading() + (reversed ? Math.PI : 0.0)));
    }

    public PathBuilder(@NotNull Path path, double s) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this(null, null, path, s);
    }
}

