/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.PathSegment;
import com.acmerobotics.roadrunner.util.DoubleProgression;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\rJ\u001b\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0087\u0002J\u001f\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0018J\u001f\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\rJ\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001d\u001a\u00020\rJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001fJ\u001a\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0007J\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0!2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\"\u001a\u00020\u000bJ\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006%"}, d2={"Lcom/acmerobotics/roadrunner/path/Path;", "", "segment", "Lcom/acmerobotics/roadrunner/path/PathSegment;", "(Lcom/acmerobotics/roadrunner/path/PathSegment;)V", "segments", "", "(Ljava/util/List;)V", "getSegments", "()Ljava/util/List;", "deriv", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "s", "", "t", "end", "endDeriv", "endSecondDeriv", "fastProject", "queryPoint", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "projectGuess", "get", "internalDeriv", "internalDeriv$core", "internalSecondDeriv", "internalSecondDeriv$core", "length", "project", "ds", "reparam", "reparam$core", "secondDeriv", "Lkotlin/Pair;", "start", "startDeriv", "startSecondDeriv", "core"})
public final class Path {
    @NotNull
    private final List<PathSegment> segments;

    /*
     * WARNING - void declaration
     */
    public final double length() {
        void var3_3;
        Iterable $this$sumByDouble$iv = this.segments;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            PathSegment pathSegment = (PathSegment)element$iv;
            double d = sum$iv;
            boolean bl = false;
            double d2 = it.length();
            sum$iv = d + d2;
        }
        return (double)var3_3;
    }

    @NotNull
    public final Pair<PathSegment, Double> segment(double s) {
        if (s <= 0.0) {
            return TuplesKt.to((Object)CollectionsKt.first(this.segments), (Object)0.0);
        }
        double remainingDisplacement = s;
        for (PathSegment segment : this.segments) {
            if (remainingDisplacement <= segment.length()) {
                return TuplesKt.to((Object)segment, (Object)remainingDisplacement);
            }
            remainingDisplacement -= segment.length();
        }
        return TuplesKt.to((Object)CollectionsKt.last(this.segments), (Object)((PathSegment)CollectionsKt.last(this.segments)).length());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Pose2d get(double s, double t) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.get(remainingDisplacement, t);
    }

    public static /* synthetic */ Pose2d get$default(Path path, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = path.reparam$core(d);
        }
        return path.get(d, d2);
    }

    @JvmOverloads
    @NotNull
    public final Pose2d get(double s) {
        return Path.get$default(this, s, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Pose2d deriv(double s, double t) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.deriv(remainingDisplacement, t);
    }

    public static /* synthetic */ Pose2d deriv$default(Path path, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = path.reparam$core(d);
        }
        return path.deriv(d, d2);
    }

    @JvmOverloads
    @NotNull
    public final Pose2d deriv(double s) {
        return Path.deriv$default(this, s, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Pose2d secondDeriv(double s, double t) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.secondDeriv(remainingDisplacement, t);
    }

    public static /* synthetic */ Pose2d secondDeriv$default(Path path, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = path.reparam$core(d);
        }
        return path.secondDeriv(d, d2);
    }

    @JvmOverloads
    @NotNull
    public final Pose2d secondDeriv(double s) {
        return Path.secondDeriv$default(this, s, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Pose2d internalDeriv$core(double s, double t) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.internalDeriv$core(remainingDisplacement, t);
    }

    public static /* synthetic */ Pose2d internalDeriv$core$default(Path path, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = path.reparam$core(d);
        }
        return path.internalDeriv$core(d, d2);
    }

    @JvmOverloads
    @NotNull
    public final Pose2d internalDeriv$core(double s) {
        return Path.internalDeriv$core$default(this, s, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Pose2d internalSecondDeriv$core(double s, double t) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.internalSecondDeriv$core(remainingDisplacement, t);
    }

    public static /* synthetic */ Pose2d internalSecondDeriv$core$default(Path path, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = path.reparam$core(d);
        }
        return path.internalSecondDeriv$core(d, d2);
    }

    @JvmOverloads
    @NotNull
    public final Pose2d internalSecondDeriv$core(double s) {
        return Path.internalSecondDeriv$core$default(this, s, 0.0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final double reparam$core(double s) {
        void segment;
        Pair<PathSegment, Double> pair = this.segment(s);
        PathSegment pathSegment = (PathSegment)pair.component1();
        double remainingDisplacement = ((Number)pair.component2()).doubleValue();
        return segment.reparam(remainingDisplacement);
    }

    public final double fastProject(@NotNull Vector2d queryPoint, double projectGuess) {
        Intrinsics.checkNotNullParameter((Object)queryPoint, (String)"queryPoint");
        double s = projectGuess;
        int n = 200;
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int it = n2;
            boolean bl2 = false;
            double t = this.reparam$core(s);
            Vector2d pathPoint = this.get(s, t).vec();
            Vector2d deriv = this.deriv(s, t).vec();
            double ds = queryPoint.minus(pathPoint).dot(deriv);
            if (!MathUtilKt.epsilonEquals(ds, 0.0) && !((s += ds) <= 0.0) && s >= this.length()) continue;
        }
        double d = 0.0;
        double d2 = s;
        double d3 = this.length();
        boolean bl3 = false;
        d2 = Math.min(d2, d3);
        boolean bl4 = false;
        return Math.max(d, d2);
    }

    public static /* synthetic */ double fastProject$default(Path path, Vector2d vector2d, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = path.length() / 2.0;
        }
        return path.fastProject(vector2d, d);
    }

    /*
     * WARNING - void declaration
     */
    public final double project(@NotNull Vector2d queryPoint, double ds) {
        Object v0;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)queryPoint, (String)"queryPoint");
        int samples = MathKt.roundToInt((double)(this.length() / ds));
        DoubleProgression guesses = DoubleProgression.Companion.fromClosedInterval(0.0, this.length(), samples);
        Iterable $this$map$iv = guesses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d2 = this.fastProject(queryPoint, (double)it);
            collection.add(d2);
        }
        List results = (List)destination$iv$iv;
        Iterable $this$minByOrNull$iv = results;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                double it = ((Number)minElem$iv).doubleValue();
                boolean bl = false;
                double minValue$iv = Path.get$default(this, it, 0.0, 2, null).vec().distTo(queryPoint);
                do {
                    Object e$iv = iterator$iv.next();
                    double it2 = ((Number)e$iv).doubleValue();
                    $i$a$-minByOrNull-Path$project$1 = false;
                    double v$iv = Path.get$default(this, it2, 0.0, 2, null).vec().distTo(queryPoint);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Double d = v0;
        return d != null ? d : 0.0;
    }

    public static /* synthetic */ double project$default(Path path, Vector2d vector2d, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.25;
        }
        return path.project(vector2d, d);
    }

    @NotNull
    public final Pose2d start() {
        return Path.get$default(this, 0.0, 0.0, 2, null);
    }

    @NotNull
    public final Pose2d startDeriv() {
        return Path.deriv$default(this, 0.0, 0.0, 2, null);
    }

    @NotNull
    public final Pose2d startSecondDeriv() {
        return Path.secondDeriv$default(this, 0.0, 0.0, 2, null);
    }

    @NotNull
    public final Pose2d end() {
        return Path.get$default(this, this.length(), 0.0, 2, null);
    }

    @NotNull
    public final Pose2d endDeriv() {
        return Path.deriv$default(this, this.length(), 0.0, 2, null);
    }

    @NotNull
    public final Pose2d endSecondDeriv() {
        return Path.secondDeriv$default(this, this.length(), 0.0, 2, null);
    }

    @NotNull
    public final List<PathSegment> getSegments() {
        return this.segments;
    }

    public Path(@NotNull List<PathSegment> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
    }

    public Path(@NotNull PathSegment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        this(CollectionsKt.listOf((Object)segment));
    }
}

