/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.path;

import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.path.ParametricCurve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0010J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/acmerobotics/roadrunner/path/LineSegment;", "Lcom/acmerobotics/roadrunner/path/ParametricCurve;", "start", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "end", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;Lcom/acmerobotics/roadrunner/geometry/Vector2d;)V", "diff", "internalDeriv", "t", "", "internalDeriv$core", "internalGet", "internalGet$core", "internalSecondDeriv", "internalSecondDeriv$core", "internalThirdDeriv", "internalThirdDeriv$core", "length", "paramDeriv", "paramDeriv$core", "paramSecondDeriv", "paramSecondDeriv$core", "paramThirdDeriv", "paramThirdDeriv$core", "reparam", "s", "reparam$core", "toString", "", "core"})
public final class LineSegment
extends ParametricCurve {
    private final Vector2d diff;
    private final Vector2d start;

    @Override
    public double length() {
        return this.diff.norm();
    }

    @Override
    @NotNull
    public Vector2d internalGet$core(double t) {
        return this.start.plus(this.diff.times(t));
    }

    @Override
    @NotNull
    public Vector2d internalDeriv$core(double t) {
        return this.diff;
    }

    @Override
    @NotNull
    public Vector2d internalSecondDeriv$core(double t) {
        return new Vector2d(0.0, 0.0);
    }

    @Override
    @NotNull
    public Vector2d internalThirdDeriv$core(double t) {
        return new Vector2d(0.0, 0.0);
    }

    @Override
    public double reparam$core(double s) {
        return s / this.length();
    }

    @Override
    public double paramDeriv$core(double t) {
        return 1.0 / this.length();
    }

    @Override
    public double paramSecondDeriv$core(double t) {
        return 0.0;
    }

    @Override
    public double paramThirdDeriv$core(double t) {
        return 0.0;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.start.getX() + '+' + this.diff.getX() + "*t," + this.start.getY() + '+' + this.diff.getY() + "*t)";
    }

    public LineSegment(@NotNull Vector2d start, @NotNull Vector2d end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.diff = end.minus(this.start);
    }
}

