/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.localization;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.localization.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0003H&J\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/acmerobotics/roadrunner/localization/ThreeTrackingWheelLocalizer;", "Lcom/acmerobotics/roadrunner/localization/Localizer;", "wheelPoses", "", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "(Ljava/util/List;)V", "_poseEstimate", "forwardSolver", "Lorg/apache/commons/math3/linear/DecompositionSolver;", "lastWheelPositions", "", "value", "poseEstimate", "getPoseEstimate", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setPoseEstimate", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "poseVelocity", "getPoseVelocity", "setPoseVelocity", "calculatePoseDelta", "wheelDeltas", "getWheelPositions", "getWheelVelocities", "update", "", "core"})
public abstract class ThreeTrackingWheelLocalizer
implements Localizer {
    private Pose2d _poseEstimate;
    @Nullable
    private Pose2d poseVelocity;
    private List<Double> lastWheelPositions;
    private final DecompositionSolver forwardSolver;

    @Override
    @NotNull
    public Pose2d getPoseEstimate() {
        return this._poseEstimate;
    }

    @Override
    public void setPoseEstimate(@NotNull Pose2d value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.lastWheelPositions = CollectionsKt.emptyList();
        this._poseEstimate = value;
    }

    @Override
    @Nullable
    public Pose2d getPoseVelocity() {
        return this.poseVelocity;
    }

    public void setPoseVelocity(@Nullable Pose2d pose2d) {
        this.poseVelocity = pose2d;
    }

    private final Pose2d calculatePoseDelta(List<Double> wheelDeltas) {
        RealMatrix rawPoseDelta = this.forwardSolver.solve(MatrixUtils.createRealMatrix((double[][])new double[][]{CollectionsKt.toDoubleArray((Collection)wheelDeltas)}).transpose());
        return new Pose2d(rawPoseDelta.getEntry(0, 0), rawPoseDelta.getEntry(1, 0), rawPoseDelta.getEntry(2, 0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        List<Double> wheelVelocities;
        List<Double> wheelPositions = this.getWheelPositions();
        Collection collection = this.lastWheelPositions;
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.zip((Iterable)wheelPositions, (Iterable)this.lastWheelPositions);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                Double d = ((Number)it.getFirst()).doubleValue() - ((Number)it.getSecond()).doubleValue();
                collection2.add(d);
            }
            List wheelDeltas = (List)destination$iv$iv;
            Pose2d robotPoseDelta = this.calculatePoseDelta(wheelDeltas);
            this._poseEstimate = Kinematics.relativeOdometryUpdate(this._poseEstimate, robotPoseDelta);
        }
        if ((wheelVelocities = this.getWheelVelocities()) != null) {
            this.setPoseVelocity(this.calculatePoseDelta(wheelVelocities));
        }
        this.lastWheelPositions = wheelPositions;
    }

    @NotNull
    public abstract List<Double> getWheelPositions();

    @Nullable
    public List<Double> getWheelVelocities() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ThreeTrackingWheelLocalizer(@NotNull List<Pose2d> wheelPoses) {
        Intrinsics.checkNotNullParameter(wheelPoses, (String)"wheelPoses");
        this._poseEstimate = new Pose2d(0.0, 0.0, 0.0, 7, null);
        this.lastWheelPositions = CollectionsKt.emptyList();
        boolean bl = wheelPoses.size() == 3;
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "3 wheel positions must be provided";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Array2DRowRealMatrix inverseMatrix = new Array2DRowRealMatrix(3, 3);
        n = 0;
        n2 = 2;
        while (n <= n2) {
            void i;
            Vector2d orientationVector = wheelPoses.get((int)i).headingVec();
            Vector2d positionVector = wheelPoses.get((int)i).vec();
            inverseMatrix.setEntry((int)i, 0, orientationVector.getX());
            inverseMatrix.setEntry((int)i, 1, orientationVector.getY());
            inverseMatrix.setEntry((int)i, 2, positionVector.getX() * orientationVector.getY() - positionVector.getY() * orientationVector.getX());
            ++i;
        }
        DecompositionSolver decompositionSolver = new LUDecomposition((RealMatrix)inverseMatrix).getSolver();
        Intrinsics.checkNotNullExpressionValue((Object)decompositionSolver, (String)"LUDecomposition(inverseMatrix).solver");
        this.forwardSolver = decompositionSolver;
        n = this.forwardSolver.isNonSingular() ? 1 : 0;
        n2 = 0;
        boolean bl3 = false;
        if (n == 0) {
            boolean bl4 = false;
            String string = "The specified configuration cannot support full localization";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

