/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.kinematics;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u001e\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\r"}, d2={"Lcom/acmerobotics/roadrunner/kinematics/TankKinematics;", "", "()V", "robotToWheelAccelerations", "", "", "robotAccel", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "trackWidth", "robotToWheelVelocities", "robotVel", "wheelToRobotVelocities", "wheelVelocities", "core"})
public final class TankKinematics {
    public static final TankKinematics INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth) {
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        boolean bl = MathUtilKt.epsilonEquals(robotVel.getY(), 0.0);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Lateral (robot y) velocity must be zero for tank drives";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return CollectionsKt.listOf((Object[])new Double[]{robotVel.getX() - trackWidth / (double)2 * robotVel.getHeading(), robotVel.getX() + trackWidth / (double)2 * robotVel.getHeading()});
    }

    @JvmStatic
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotAccel, double trackWidth) {
        Intrinsics.checkNotNullParameter((Object)robotAccel, (String)"robotAccel");
        return TankKinematics.robotToWheelVelocities(robotAccel, trackWidth);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, double trackWidth) {
        void left;
        List<Double> list;
        Intrinsics.checkNotNullParameter(wheelVelocities, (String)"wheelVelocities");
        List<Double> list2 = list = wheelVelocities;
        boolean bl = false;
        double d = ((Number)list2.get(0)).doubleValue();
        list2 = list;
        bl = false;
        double right = ((Number)list2.get(1)).doubleValue();
        return new Pose2d((double)((left + right) / 2.0), 0.0, (double)((-left + right) / trackWidth));
    }

    private TankKinematics() {
    }

    static {
        TankKinematics tankKinematics;
        INSTANCE = tankKinematics = new TankKinematics();
    }
}

