/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.kinematics;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007J6\u0010\u0011\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u0014"}, d2={"Lcom/acmerobotics/roadrunner/kinematics/SwerveKinematics;", "", "()V", "robotToModuleAccelerationVectors", "", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "robotAccel", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "trackWidth", "", "wheelBase", "robotToModuleAngularVelocities", "robotVel", "robotToModuleOrientations", "robotToModuleVelocityVectors", "robotToWheelAccelerations", "robotToWheelVelocities", "wheelToRobotVelocities", "wheelVelocities", "moduleOrientations", "core"})
public final class SwerveKinematics {
    public static final SwerveKinematics INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Vector2d> robotToModuleVelocityVectors(@NotNull Pose2d robotVel, double trackWidth, double wheelBase) {
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        double x = wheelBase / (double)2;
        double y = trackWidth / (double)2;
        double vx = robotVel.getX();
        double vy = robotVel.getY();
        double omega = robotVel.getHeading();
        return CollectionsKt.listOf((Object[])new Vector2d[]{new Vector2d(vx - omega * y, vy + omega * x), new Vector2d(vx - omega * y, vy - omega * x), new Vector2d(vx + omega * y, vy - omega * x), new Vector2d(vx + omega * y, vy + omega * x)});
    }

    public static /* synthetic */ List robotToModuleVelocityVectors$default(Pose2d pose2d, double d, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToModuleVelocityVectors(pose2d, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Vector2d> robotToModuleVelocityVectors(@NotNull Pose2d robotVel, double trackWidth) {
        return SwerveKinematics.robotToModuleVelocityVectors$default(robotVel, trackWidth, 0.0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth, double wheelBase) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        Iterable $this$map$iv = SwerveKinematics.robotToModuleVelocityVectors(robotVel, trackWidth, wheelBase);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = p1.norm();
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List robotToWheelVelocities$default(Pose2d pose2d, double d, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToWheelVelocities(pose2d, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth) {
        return SwerveKinematics.robotToWheelVelocities$default(robotVel, trackWidth, 0.0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToModuleOrientations(@NotNull Pose2d robotVel, double trackWidth, double wheelBase) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        Iterable $this$map$iv = SwerveKinematics.robotToModuleVelocityVectors(robotVel, trackWidth, wheelBase);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Vector2d vector2d = (Vector2d)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = p1.angle();
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List robotToModuleOrientations$default(Pose2d pose2d, double d, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToModuleOrientations(pose2d, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToModuleOrientations(@NotNull Pose2d robotVel, double trackWidth) {
        return SwerveKinematics.robotToModuleOrientations$default(robotVel, trackWidth, 0.0, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Vector2d> robotToModuleAccelerationVectors(@NotNull Pose2d robotAccel, double trackWidth, double wheelBase) {
        Intrinsics.checkNotNullParameter((Object)robotAccel, (String)"robotAccel");
        double x = wheelBase / (double)2;
        double y = trackWidth / (double)2;
        double ax = robotAccel.getX();
        double ay = robotAccel.getY();
        double alpha = robotAccel.getHeading();
        return CollectionsKt.listOf((Object[])new Vector2d[]{new Vector2d(ax - alpha * y, ay + alpha * x), new Vector2d(ax - alpha * y, ay - alpha * x), new Vector2d(ax + alpha * y, ay - alpha * x), new Vector2d(ax + alpha * y, ay + alpha * x)});
    }

    public static /* synthetic */ List robotToModuleAccelerationVectors$default(Pose2d pose2d, double d, double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToModuleAccelerationVectors(pose2d, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Vector2d> robotToModuleAccelerationVectors(@NotNull Pose2d robotAccel, double trackWidth) {
        return SwerveKinematics.robotToModuleAccelerationVectors$default(robotAccel, trackWidth, 0.0, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotVel, @NotNull Pose2d robotAccel, double trackWidth, double wheelBase) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        Intrinsics.checkNotNullParameter((Object)robotAccel, (String)"robotAccel");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)SwerveKinematics.robotToModuleVelocityVectors(robotVel, trackWidth, wheelBase), (Iterable)SwerveKinematics.robotToModuleAccelerationVectors(robotAccel, trackWidth, wheelBase));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void vel;
            void $dstr$vel$accel;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2d vector2d = (Vector2d)$dstr$vel$accel.component1();
            Vector2d accel = (Vector2d)$dstr$vel$accel.component2();
            Double d = (vel.getX() * accel.getX() + vel.getY() * accel.getY()) / vel.norm();
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List robotToWheelAccelerations$default(Pose2d pose2d, Pose2d pose2d2, double d, double d2, int n, Object object) {
        if ((n & 8) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToWheelAccelerations(pose2d, pose2d2, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotVel, @NotNull Pose2d robotAccel, double trackWidth) {
        return SwerveKinematics.robotToWheelAccelerations$default(robotVel, robotAccel, trackWidth, 0.0, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToModuleAngularVelocities(@NotNull Pose2d robotVel, @NotNull Pose2d robotAccel, double trackWidth, double wheelBase) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        Intrinsics.checkNotNullParameter((Object)robotAccel, (String)"robotAccel");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)SwerveKinematics.robotToModuleVelocityVectors(robotVel, trackWidth, wheelBase), (Iterable)SwerveKinematics.robotToModuleAccelerationVectors(robotAccel, trackWidth, wheelBase));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void vel;
            void $dstr$vel$accel;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Vector2d vector2d = (Vector2d)$dstr$vel$accel.component1();
            Vector2d accel = (Vector2d)$dstr$vel$accel.component2();
            Double d = (vel.getX() * accel.getY() - vel.getY() * accel.getX()) / (vel.getX() * vel.getX() + vel.getY() * vel.getY());
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List robotToModuleAngularVelocities$default(Pose2d pose2d, Pose2d pose2d2, double d, double d2, int n, Object object) {
        if ((n & 8) != 0) {
            d2 = d;
        }
        return SwerveKinematics.robotToModuleAngularVelocities(pose2d, pose2d2, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToModuleAngularVelocities(@NotNull Pose2d robotVel, @NotNull Pose2d robotAccel, double trackWidth) {
        return SwerveKinematics.robotToModuleAngularVelocities$default(robotVel, robotAccel, trackWidth, 0.0, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, @NotNull List<Double> moduleOrientations, double trackWidth, double wheelBase) {
        void rearLeft;
        void frontLeft;
        void rearRight;
        double d;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(wheelVelocities, (String)"wheelVelocities");
        Intrinsics.checkNotNullParameter(moduleOrientations, (String)"moduleOrientations");
        double x = wheelBase / (double)2;
        double y = trackWidth / (double)2;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)wheelVelocities, (Iterable)moduleOrientations);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void vel;
            void $dstr$vel$orientation;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double d2 = ((Number)$dstr$vel$orientation.component1()).doubleValue();
            double orientation = ((Number)$dstr$vel$orientation.component2()).doubleValue();
            boolean bl2 = false;
            bl2 = false;
            Vector2d vector2d = new Vector2d((double)(vel * Math.cos(orientation)), (double)(vel * Math.sin(orientation)));
            collection.add(vector2d);
        }
        List vectors = (List)destination$iv$iv;
        Iterable $this$sumByDouble$iv = vectors;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        for (Object element$iv : $this$sumByDouble$iv) {
            void it;
            Vector2d bl = (Vector2d)element$iv;
            double d3 = sum$iv;
            boolean bl3 = false;
            d = it.getX();
            sum$iv = d3 + d;
        }
        double vx = sum$iv / (double)4;
        Object $this$sumByDouble$iv2 = vectors;
        boolean $i$f$sumByDouble22 = false;
        double sum$iv22 = 0.0;
        Object it = $this$sumByDouble$iv2.iterator();
        while (it.hasNext()) {
            void it2;
            Object element$iv = it.next();
            Vector2d vector2d = (Vector2d)element$iv;
            double d4 = sum$iv22;
            boolean bl = false;
            d = it2.getY();
            sum$iv22 = d4 + d;
        }
        double vy = sum$iv22 / (double)4;
        Object object = it = vectors;
        boolean bl = false;
        $this$sumByDouble$iv2 = (Vector2d)object.get(0);
        object = it;
        bl = false;
        Vector2d $i$f$sumByDouble22 = (Vector2d)object.get(1);
        object = it;
        bl = false;
        Vector2d sum$iv22 = (Vector2d)object.get(2);
        object = it;
        bl = false;
        Vector2d frontRight = (Vector2d)object.get(3);
        double omega = (y * (rearRight.getX() + frontRight.getX() - frontLeft.getX() - rearLeft.getX()) + x * (frontLeft.getY() + frontRight.getY() - rearLeft.getY() - rearRight.getY())) / ((double)4 * (x * x + y * y));
        return new Pose2d(vx, vy, omega);
    }

    public static /* synthetic */ Pose2d wheelToRobotVelocities$default(List list, List list2, double d, double d2, int n, Object object) {
        if ((n & 8) != 0) {
            d2 = d;
        }
        return SwerveKinematics.wheelToRobotVelocities(list, list2, d, d2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, @NotNull List<Double> moduleOrientations, double trackWidth) {
        return SwerveKinematics.wheelToRobotVelocities$default(wheelVelocities, moduleOrientations, trackWidth, 0.0, 8, null);
    }

    private SwerveKinematics() {
    }

    static {
        SwerveKinematics swerveKinematics;
        INSTANCE = swerveKinematics = new SwerveKinematics();
    }
}

