/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.kinematics;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u0007J2\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u0007J2\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u0007\u00a8\u0006\u000f"}, d2={"Lcom/acmerobotics/roadrunner/kinematics/MecanumKinematics;", "", "()V", "robotToWheelAccelerations", "", "", "robotAccel", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "trackWidth", "wheelBase", "lateralMultiplier", "robotToWheelVelocities", "robotVel", "wheelToRobotVelocities", "wheelVelocities", "core"})
public final class MecanumKinematics {
    public static final MecanumKinematics INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth, double wheelBase, double lateralMultiplier) {
        Intrinsics.checkNotNullParameter((Object)robotVel, (String)"robotVel");
        double k = (trackWidth + wheelBase) / 2.0;
        return CollectionsKt.listOf((Object[])new Double[]{robotVel.getX() - lateralMultiplier * robotVel.getY() - k * robotVel.getHeading(), robotVel.getX() + lateralMultiplier * robotVel.getY() - k * robotVel.getHeading(), robotVel.getX() - lateralMultiplier * robotVel.getY() + k * robotVel.getHeading(), robotVel.getX() + lateralMultiplier * robotVel.getY() + k * robotVel.getHeading()});
    }

    public static /* synthetic */ List robotToWheelVelocities$default(Pose2d pose2d, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MecanumKinematics.robotToWheelVelocities(pose2d, d, d2, d3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth, double wheelBase) {
        return MecanumKinematics.robotToWheelVelocities$default(robotVel, trackWidth, wheelBase, 0.0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelVelocities(@NotNull Pose2d robotVel, double trackWidth) {
        return MecanumKinematics.robotToWheelVelocities$default(robotVel, trackWidth, 0.0, 0.0, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotAccel, double trackWidth, double wheelBase, double lateralMultiplier) {
        Intrinsics.checkNotNullParameter((Object)robotAccel, (String)"robotAccel");
        return MecanumKinematics.robotToWheelVelocities(robotAccel, trackWidth, wheelBase, lateralMultiplier);
    }

    public static /* synthetic */ List robotToWheelAccelerations$default(Pose2d pose2d, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MecanumKinematics.robotToWheelAccelerations(pose2d, d, d2, d3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotAccel, double trackWidth, double wheelBase) {
        return MecanumKinematics.robotToWheelAccelerations$default(robotAccel, trackWidth, wheelBase, 0.0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<Double> robotToWheelAccelerations(@NotNull Pose2d robotAccel, double trackWidth) {
        return MecanumKinematics.robotToWheelAccelerations$default(robotAccel, trackWidth, 0.0, 0.0, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, double trackWidth, double wheelBase, double lateralMultiplier) {
        void rearRight;
        void frontLeft;
        void rearLeft;
        List<Double> list;
        Intrinsics.checkNotNullParameter(wheelVelocities, (String)"wheelVelocities");
        double k = (trackWidth + wheelBase) / 2.0;
        List<Double> list2 = list = wheelVelocities;
        boolean bl = false;
        double d = ((Number)list2.get(0)).doubleValue();
        list2 = list;
        bl = false;
        double d2 = ((Number)list2.get(1)).doubleValue();
        list2 = list;
        bl = false;
        double d3 = ((Number)list2.get(2)).doubleValue();
        list2 = list;
        bl = false;
        double frontRight = ((Number)list2.get(3)).doubleValue();
        return new Pose2d(CollectionsKt.sumOfDouble((Iterable)wheelVelocities), (double)((rearLeft + frontRight - frontLeft - rearRight) / lateralMultiplier), (double)((rearRight + frontRight - frontLeft - rearLeft) / k)).times(0.25);
    }

    public static /* synthetic */ Pose2d wheelToRobotVelocities$default(List list, double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d2 = d;
        }
        if ((n & 8) != 0) {
            d3 = 1.0;
        }
        return MecanumKinematics.wheelToRobotVelocities(list, d, d2, d3);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, double trackWidth, double wheelBase) {
        return MecanumKinematics.wheelToRobotVelocities$default(wheelVelocities, trackWidth, wheelBase, 0.0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Pose2d wheelToRobotVelocities(@NotNull List<Double> wheelVelocities, double trackWidth) {
        return MecanumKinematics.wheelToRobotVelocities$default(wheelVelocities, trackWidth, 0.0, 0.0, 12, null);
    }

    private MecanumKinematics() {
    }

    static {
        MecanumKinematics mecanumKinematics;
        INSTANCE = mecanumKinematics = new MecanumKinematics();
    }
}

