/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.kinematics;

import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0007J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0007J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0007J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0007\u00a8\u0006\u0018"}, d2={"Lcom/acmerobotics/roadrunner/kinematics/Kinematics;", "", "()V", "calculateMotorFeedforward", "", "vel", "accel", "kV", "kA", "kStatic", "", "vels", "accels", "calculatePoseError", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "targetFieldPose", "currentFieldPose", "fieldToRobotAcceleration", "fieldPose", "fieldVel", "fieldAccel", "fieldToRobotVelocity", "relativeOdometryUpdate", "robotPoseDelta", "core"})
public final class Kinematics {
    public static final Kinematics INSTANCE;

    @JvmStatic
    @NotNull
    public static final Pose2d fieldToRobotVelocity(@NotNull Pose2d fieldPose, @NotNull Pose2d fieldVel) {
        Intrinsics.checkNotNullParameter((Object)fieldPose, (String)"fieldPose");
        Intrinsics.checkNotNullParameter((Object)fieldVel, (String)"fieldVel");
        return new Pose2d(fieldVel.vec().rotated(-fieldPose.getHeading()), fieldVel.getHeading());
    }

    @JvmStatic
    @NotNull
    public static final Pose2d fieldToRobotAcceleration(@NotNull Pose2d fieldPose, @NotNull Pose2d fieldVel, @NotNull Pose2d fieldAccel) {
        Intrinsics.checkNotNullParameter((Object)fieldPose, (String)"fieldPose");
        Intrinsics.checkNotNullParameter((Object)fieldVel, (String)"fieldVel");
        Intrinsics.checkNotNullParameter((Object)fieldAccel, (String)"fieldAccel");
        double d = fieldPose.getHeading();
        boolean bl = false;
        double d2 = -fieldVel.getX() * Math.sin(d);
        d = fieldPose.getHeading();
        bl = false;
        double d3 = d2 + fieldVel.getY() * Math.cos(d);
        d = fieldPose.getHeading();
        bl = false;
        double d4 = -fieldVel.getX() * Math.cos(d);
        d = fieldPose.getHeading();
        bl = false;
        return new Pose2d(fieldAccel.vec().rotated(-fieldPose.getHeading()), fieldAccel.getHeading()).plus(new Pose2d(d3, d4 - fieldVel.getY() * Math.sin(d), 0.0).times(fieldVel.getHeading()));
    }

    @JvmStatic
    @NotNull
    public static final Pose2d calculatePoseError(@NotNull Pose2d targetFieldPose, @NotNull Pose2d currentFieldPose) {
        Intrinsics.checkNotNullParameter((Object)targetFieldPose, (String)"targetFieldPose");
        Intrinsics.checkNotNullParameter((Object)currentFieldPose, (String)"currentFieldPose");
        return new Pose2d(targetFieldPose.minus(currentFieldPose).vec().rotated(-currentFieldPose.getHeading()), Angle.normDelta(targetFieldPose.getHeading() - currentFieldPose.getHeading()));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Double> calculateMotorFeedforward(@NotNull List<Double> vels, @NotNull List<Double> accels, double kV, double kA, double kStatic) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(vels, (String)"vels");
        Intrinsics.checkNotNullParameter(accels, (String)"accels");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)vels, (Iterable)accels);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void vel;
            void $dstr$vel$accel;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double d = ((Number)$dstr$vel$accel.component1()).doubleValue();
            double accel = ((Number)$dstr$vel$accel.component2()).doubleValue();
            Double d2 = Kinematics.calculateMotorFeedforward((double)vel, accel, kV, kA, kStatic);
            collection.add(d2);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    public static final double calculateMotorFeedforward(double vel, double accel, double kV, double kA, double kStatic) {
        double d;
        double basePower = vel * kV + accel * kA;
        if (MathUtilKt.epsilonEquals(basePower, 0.0)) {
            d = 0.0;
        } else {
            boolean bl = false;
            d = basePower + Math.signum(basePower) * kStatic;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pose2d relativeOdometryUpdate(@NotNull Pose2d fieldPose, @NotNull Pose2d robotPoseDelta) {
        void sineTerm;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)fieldPose, (String)"fieldPose");
        Intrinsics.checkNotNullParameter((Object)robotPoseDelta, (String)"robotPoseDelta");
        double dtheta = robotPoseDelta.getHeading();
        if (MathUtilKt.epsilonEquals(dtheta, 0.0)) {
            pair = TuplesKt.to((Object)(1.0 - dtheta * dtheta / 6.0), (Object)(dtheta / 2.0));
        } else {
            boolean bl = false;
            bl = false;
            pair = TuplesKt.to((Object)(Math.sin(dtheta) / dtheta), (Object)((1.0 - Math.cos(dtheta)) / dtheta));
        }
        Pair pair2 = pair;
        double d = ((Number)pair2.component1()).doubleValue();
        double cosTerm = ((Number)pair2.component2()).doubleValue();
        Vector2d fieldPositionDelta = new Vector2d((double)(sineTerm * robotPoseDelta.getX() - cosTerm * robotPoseDelta.getY()), cosTerm * robotPoseDelta.getX() + sineTerm * robotPoseDelta.getY());
        Pose2d fieldPoseDelta = new Pose2d(fieldPositionDelta.rotated(fieldPose.getHeading()), robotPoseDelta.getHeading());
        return new Pose2d(fieldPose.getX() + fieldPoseDelta.getX(), fieldPose.getY() + fieldPoseDelta.getY(), Angle.norm(fieldPose.getHeading() + fieldPoseDelta.getHeading()));
    }

    private Kinematics() {
    }

    static {
        Kinematics kinematics;
        INSTANCE = kinematics = new Kinematics();
    }
}

