/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0003J\u0011\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010\u0015\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u0003J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "", "x", "", "y", "(DD)V", "getX", "()D", "getY", "angle", "angleBetween", "other", "component1", "component2", "copy", "distTo", "div", "scalar", "dot", "epsilonEquals", "", "equals", "hashCode", "", "minus", "norm", "plus", "projectOnto", "rotated", "times", "toString", "", "unaryMinus", "Companion", "core"})
public final class Vector2d {
    private final double x;
    private final double y;
    public static final Companion Companion = new Companion(null);

    public final double norm() {
        double d = this.x * this.x + this.y * this.y;
        boolean bl = false;
        return Math.sqrt(d);
    }

    public final double angle() {
        double d = this.y;
        double d2 = this.x;
        boolean bl = false;
        return Angle.norm(Math.atan2(d, d2));
    }

    public final double angleBetween(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double d = this.dot(other) / (this.norm() * other.norm());
        boolean bl = false;
        return Math.acos(d);
    }

    @NotNull
    public final Vector2d plus(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector2d(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vector2d minus(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector2d(this.x - other.x, this.y - other.y);
    }

    @NotNull
    public final Vector2d times(double scalar) {
        return new Vector2d(scalar * this.x, scalar * this.y);
    }

    @NotNull
    public final Vector2d div(double scalar) {
        return new Vector2d(this.x / scalar, this.y / scalar);
    }

    @NotNull
    public final Vector2d unaryMinus() {
        return new Vector2d(-this.x, -this.y);
    }

    public final double dot(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y;
    }

    public final double distTo(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.minus(other).norm();
    }

    @NotNull
    public final Vector2d projectOnto(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.times(this.dot(other)).div(other.dot(other));
    }

    @NotNull
    public final Vector2d rotated(double angle) {
        boolean bl = false;
        bl = false;
        double newX = this.x * Math.cos(angle) - this.y * Math.sin(angle);
        boolean bl2 = false;
        bl2 = false;
        double newY = this.x * Math.sin(angle) + this.y * Math.cos(angle);
        return new Vector2d(newX, newY);
    }

    public final boolean epsilonEquals(@NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathUtilKt.epsilonEquals(this.x, other.x) && MathUtilKt.epsilonEquals(this.y, other.y);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "(%.3f, %.3f)";
        Object[] objectArray = new Object[]{this.x, this.y};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @JvmOverloads
    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public /* synthetic */ Vector2d(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        this(d, d2);
    }

    @JvmOverloads
    public Vector2d(double x) {
        this(x, 0.0, 2, null);
    }

    @JvmOverloads
    public Vector2d() {
        this(0.0, 0.0, 3, null);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vector2d copy(double x, double y) {
        return new Vector2d(x, y);
    }

    public static /* synthetic */ Vector2d copy$default(Vector2d vector2d, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2d.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2d.y;
        }
        return vector2d.copy(d, d2);
    }

    public int hashCode() {
        return Double.hashCode(this.x) * 31 + Double.hashCode(this.y);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector2d)) break block3;
                Vector2d vector2d = (Vector2d)object;
                if (Double.compare(this.x, vector2d.x) != 0 || Double.compare(this.y, vector2d.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Vector2d polar(double r, double theta) {
        return Companion.polar(r, theta);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Vector2d$Companion;", "", "()V", "polar", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "r", "", "theta", "core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Vector2d polar(double r, double theta) {
            boolean bl = false;
            bl = false;
            return new Vector2d(r * Math.cos(theta), r * Math.sin(theta));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

