/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.geometry;

import com.acmerobotics.roadrunner.geometry.Vector2d;
import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0007\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0006\u0010\u001b\u001a\u00020\u0003J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0005H\u0086\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\"\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "", "pos", "Lcom/acmerobotics/roadrunner/geometry/Vector2d;", "heading", "", "(Lcom/acmerobotics/roadrunner/geometry/Vector2d;D)V", "x", "y", "(DDD)V", "getHeading", "()D", "getX", "getY", "component1", "component2", "component3", "copy", "div", "scalar", "epsilonEquals", "", "other", "epsilonEqualsHeading", "equals", "hashCode", "", "headingVec", "minus", "plus", "times", "toString", "", "unaryMinus", "vec", "core"})
public final class Pose2d {
    private final double x;
    private final double y;
    private final double heading;

    @NotNull
    public final Vector2d vec() {
        return new Vector2d(this.x, this.y);
    }

    @NotNull
    public final Vector2d headingVec() {
        double d = this.heading;
        boolean bl = false;
        double d2 = Math.cos(d);
        d = this.heading;
        bl = false;
        return new Vector2d(d2, Math.sin(d));
    }

    @NotNull
    public final Pose2d plus(@NotNull Pose2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Pose2d(this.x + other.x, this.y + other.y, this.heading + other.heading);
    }

    @NotNull
    public final Pose2d minus(@NotNull Pose2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Pose2d(this.x - other.x, this.y - other.y, this.heading - other.heading);
    }

    @NotNull
    public final Pose2d times(double scalar) {
        return new Pose2d(scalar * this.x, scalar * this.y, scalar * this.heading);
    }

    @NotNull
    public final Pose2d div(double scalar) {
        return new Pose2d(this.x / scalar, this.y / scalar, this.heading / scalar);
    }

    @NotNull
    public final Pose2d unaryMinus() {
        return new Pose2d(-this.x, -this.y, -this.heading);
    }

    public final boolean epsilonEquals(@NotNull Pose2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathUtilKt.epsilonEquals(this.x, other.x) && MathUtilKt.epsilonEquals(this.y, other.y) && MathUtilKt.epsilonEquals(this.heading, other.heading);
    }

    public final boolean epsilonEqualsHeading(@NotNull Pose2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathUtilKt.epsilonEquals(this.x, other.x) && MathUtilKt.epsilonEquals(this.y, other.y) && MathUtilKt.epsilonEquals(Angle.normDelta(this.heading - other.heading), 0.0);
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "(%.3f, %.3f, %.3f\u00b0)";
        Object[] objectArray = new Object[]{this.x, this.y, Math.toDegrees(this.heading)};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getHeading() {
        return this.heading;
    }

    @JvmOverloads
    public Pose2d(double x, double y, double heading) {
        this.x = x;
        this.y = y;
        this.heading = heading;
    }

    public /* synthetic */ Pose2d(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        this(d, d2, d3);
    }

    @JvmOverloads
    public Pose2d(double x, double y) {
        this(x, y, 0.0, 4, null);
    }

    @JvmOverloads
    public Pose2d(double x) {
        this(x, 0.0, 0.0, 6, null);
    }

    @JvmOverloads
    public Pose2d() {
        this(0.0, 0.0, 0.0, 7, null);
    }

    public Pose2d(@NotNull Vector2d pos, double heading) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this(pos.getX(), pos.getY(), heading);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.heading;
    }

    @NotNull
    public final Pose2d copy(double x, double y, double heading) {
        return new Pose2d(x, y, heading);
    }

    public static /* synthetic */ Pose2d copy$default(Pose2d pose2d, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = pose2d.x;
        }
        if ((n & 2) != 0) {
            d2 = pose2d.y;
        }
        if ((n & 4) != 0) {
            d3 = pose2d.heading;
        }
        return pose2d.copy(d, d2, d3);
    }

    public int hashCode() {
        return (Double.hashCode(this.x) * 31 + Double.hashCode(this.y)) * 31 + Double.hashCode(this.heading);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Pose2d)) break block3;
                Pose2d pose2d = (Pose2d)object;
                if (Double.compare(this.x, pose2d.x) != 0 || Double.compare(this.y, pose2d.y) != 0 || Double.compare(this.heading, pose2d.heading) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

