/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.followers;

import com.acmerobotics.roadrunner.drive.DriveSignal;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.trajectory.TrajectoryMarker;
import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.NanoClock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\u0005J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\nH\u0002J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010\u0003H$J\u0006\u0010&\u001a\u00020\nJ\u001c\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0003H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003@dX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0018@DX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lcom/acmerobotics/roadrunner/followers/TrajectoryFollower;", "", "admissibleError", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "timeout", "", "clock", "Lcom/acmerobotics/roadrunner/util/NanoClock;", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;DLcom/acmerobotics/roadrunner/util/NanoClock;)V", "admissible", "", "getClock", "()Lcom/acmerobotics/roadrunner/util/NanoClock;", "executedFinalUpdate", "<set-?>", "lastError", "getLastError", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setLastError", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "remainingMarkers", "", "Lcom/acmerobotics/roadrunner/trajectory/TrajectoryMarker;", "startTimestamp", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "trajectory", "getTrajectory", "()Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "setTrajectory", "(Lcom/acmerobotics/roadrunner/trajectory/Trajectory;)V", "elapsedTime", "followTrajectory", "", "internalIsFollowing", "internalUpdate", "Lcom/acmerobotics/roadrunner/drive/DriveSignal;", "currentPose", "currentRobotVel", "isFollowing", "update", "core"})
public abstract class TrajectoryFollower {
    private double startTimestamp;
    private boolean admissible;
    private List<TrajectoryMarker> remainingMarkers;
    private boolean executedFinalUpdate;
    @NotNull
    protected Trajectory trajectory;
    private final Pose2d admissibleError;
    private final double timeout;
    @NotNull
    private final NanoClock clock;

    @NotNull
    public final Trajectory getTrajectory() {
        Trajectory trajectory = this.trajectory;
        if (trajectory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trajectory");
        }
        return trajectory;
    }

    protected final void setTrajectory(@NotNull Trajectory trajectory) {
        Intrinsics.checkNotNullParameter((Object)trajectory, (String)"<set-?>");
        this.trajectory = trajectory;
    }

    @NotNull
    public abstract Pose2d getLastError();

    protected abstract void setLastError(@NotNull Pose2d var1);

    public void followTrajectory(@NotNull Trajectory trajectory) {
        Intrinsics.checkNotNullParameter((Object)trajectory, (String)"trajectory");
        this.startTimestamp = this.clock.seconds();
        this.trajectory = trajectory;
        this.admissible = false;
        this.remainingMarkers.clear();
        this.remainingMarkers.addAll((Collection<TrajectoryMarker>)trajectory.getMarkers());
        List<TrajectoryMarker> $this$sortBy$iv = this.remainingMarkers;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl = false;
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TrajectoryMarker it = (TrajectoryMarker)a;
                    boolean bl2 = false;
                    Comparable comparable = Double.valueOf(it.getTime());
                    it = (TrajectoryMarker)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = it.getTime();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            });
        }
        this.executedFinalUpdate = false;
    }

    private final boolean internalIsFollowing() {
        double timeRemaining;
        Trajectory trajectory = this.trajectory;
        if (trajectory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trajectory");
        }
        return (timeRemaining = trajectory.duration() - this.elapsedTime()) > 0.0 || !this.admissible && timeRemaining > -this.timeout;
    }

    public final boolean isFollowing() {
        return !this.executedFinalUpdate || this.internalIsFollowing();
    }

    public final double elapsedTime() {
        return this.clock.seconds() - this.startTimestamp;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public final DriveSignal update(@NotNull Pose2d currentPose, @Nullable Pose2d currentRobotVel) {
        Intrinsics.checkNotNullParameter((Object)currentPose, (String)"currentPose");
        while (this.remainingMarkers.size() > 0 && this.elapsedTime() > this.remainingMarkers.get(0).getTime()) {
            this.remainingMarkers.remove(0).getCallback().onMarkerReached();
        }
        v0 = this.trajectory;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trajectory");
        }
        trajEndError = v0.end().minus(currentPose);
        var4_4 = trajEndError.getX();
        var6_6 = false;
        if (!(Math.abs(var4_4) < this.admissibleError.getX())) ** GOTO lbl-1000
        var4_4 = trajEndError.getY();
        var6_6 = false;
        if (!(Math.abs(var4_4) < this.admissibleError.getY())) ** GOTO lbl-1000
        var4_4 = Angle.normDelta(trajEndError.getHeading());
        var6_6 = false;
        if (Math.abs(var4_4) < this.admissibleError.getHeading()) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = this.admissible = false;
        }
        if (this.internalIsFollowing() || this.executedFinalUpdate) {
            v2 = this.internalUpdate(currentPose, currentRobotVel);
        } else {
            for (TrajectoryMarker marker : this.remainingMarkers) {
                marker.getCallback().onMarkerReached();
            }
            this.remainingMarkers.clear();
            this.executedFinalUpdate = true;
            v2 = new DriveSignal(null, null, 3, null);
        }
        return v2;
    }

    public static /* synthetic */ DriveSignal update$default(TrajectoryFollower trajectoryFollower, Pose2d pose2d, Pose2d pose2d2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            pose2d2 = null;
        }
        return trajectoryFollower.update(pose2d, pose2d2);
    }

    @JvmOverloads
    @NotNull
    public final DriveSignal update(@NotNull Pose2d currentPose) {
        return TrajectoryFollower.update$default(this, currentPose, null, 2, null);
    }

    @NotNull
    protected abstract DriveSignal internalUpdate(@NotNull Pose2d var1, @Nullable Pose2d var2);

    @NotNull
    protected final NanoClock getClock() {
        return this.clock;
    }

    @JvmOverloads
    public TrajectoryFollower(@NotNull Pose2d admissibleError, double timeout, @NotNull NanoClock clock) {
        Intrinsics.checkNotNullParameter((Object)admissibleError, (String)"admissibleError");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.admissibleError = admissibleError;
        this.timeout = timeout;
        this.clock = clock;
        boolean bl = false;
        this.remainingMarkers = new ArrayList();
    }

    public /* synthetic */ TrajectoryFollower(Pose2d pose2d, double d, NanoClock nanoClock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pose2d = new Pose2d(0.0, 0.0, 0.0, 7, null);
        }
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            nanoClock = NanoClock.Companion.system();
        }
        this(pose2d, d, nanoClock);
    }

    @JvmOverloads
    public TrajectoryFollower(@NotNull Pose2d admissibleError, double timeout) {
        this(admissibleError, timeout, null, 4, null);
    }

    @JvmOverloads
    public TrajectoryFollower(@NotNull Pose2d admissibleError) {
        this(admissibleError, 0.0, null, 6, null);
    }

    @JvmOverloads
    public TrajectoryFollower() {
        this(null, 0.0, null, 7, null);
    }
}

