/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.followers;

import com.acmerobotics.roadrunner.control.PIDCoefficients;
import com.acmerobotics.roadrunner.control.PIDFController;
import com.acmerobotics.roadrunner.drive.DriveSignal;
import com.acmerobotics.roadrunner.followers.TrajectoryFollower;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.trajectory.Trajectory;
import com.acmerobotics.roadrunner.util.NanoClock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/acmerobotics/roadrunner/followers/TankPIDVAFollower;", "Lcom/acmerobotics/roadrunner/followers/TrajectoryFollower;", "axialCoeffs", "Lcom/acmerobotics/roadrunner/control/PIDCoefficients;", "crossTrackCoeffs", "admissibleError", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "timeout", "", "clock", "Lcom/acmerobotics/roadrunner/util/NanoClock;", "(Lcom/acmerobotics/roadrunner/control/PIDCoefficients;Lcom/acmerobotics/roadrunner/control/PIDCoefficients;Lcom/acmerobotics/roadrunner/geometry/Pose2d;DLcom/acmerobotics/roadrunner/util/NanoClock;)V", "axialController", "Lcom/acmerobotics/roadrunner/control/PIDFController;", "crossTrackController", "<set-?>", "lastError", "getLastError", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setLastError", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "followTrajectory", "", "trajectory", "Lcom/acmerobotics/roadrunner/trajectory/Trajectory;", "internalUpdate", "Lcom/acmerobotics/roadrunner/drive/DriveSignal;", "currentPose", "currentRobotVel", "core"})
public final class TankPIDVAFollower
extends TrajectoryFollower {
    private final PIDFController axialController;
    private final PIDFController crossTrackController;
    @NotNull
    private Pose2d lastError;

    @Override
    @NotNull
    public Pose2d getLastError() {
        return this.lastError;
    }

    @Override
    protected void setLastError(@NotNull Pose2d pose2d) {
        Intrinsics.checkNotNullParameter((Object)pose2d, (String)"<set-?>");
        this.lastError = pose2d;
    }

    @Override
    public void followTrajectory(@NotNull Trajectory trajectory) {
        Intrinsics.checkNotNullParameter((Object)trajectory, (String)"trajectory");
        this.axialController.reset();
        this.crossTrackController.reset();
        super.followTrajectory(trajectory);
    }

    @Override
    @NotNull
    protected DriveSignal internalUpdate(@NotNull Pose2d currentPose, @Nullable Pose2d currentRobotVel) {
        Intrinsics.checkNotNullParameter((Object)currentPose, (String)"currentPose");
        double t = this.elapsedTime();
        Pose2d targetPose = this.getTrajectory().get(t);
        Pose2d targetVel = this.getTrajectory().velocity(t);
        Pose2d targetAccel = this.getTrajectory().acceleration(t);
        Pose2d targetRobotVel = Kinematics.fieldToRobotVelocity(targetPose, targetVel);
        Pose2d targetRobotAccel = Kinematics.fieldToRobotAcceleration(targetPose, targetVel, targetAccel);
        Pose2d poseError = Kinematics.calculatePoseError(targetPose, currentPose);
        this.axialController.setTargetPosition(poseError.getX());
        this.crossTrackController.setTargetPosition(poseError.getY());
        this.axialController.setTargetVelocity(targetRobotVel.getX());
        this.crossTrackController.setTargetVelocity(targetRobotVel.getY());
        Pose2d pose2d = currentRobotVel;
        double axialCorrection = this.axialController.update(0.0, pose2d != null ? Double.valueOf(pose2d.getX()) : null);
        double d = targetVel.vec().dot(currentPose.vec());
        boolean bl = false;
        Pose2d pose2d2 = currentRobotVel;
        double headingCorrection = Math.signum(d) * this.crossTrackController.update(0.0, pose2d2 != null ? Double.valueOf(pose2d2.getY()) : null);
        Pose2d correctedVelocity = targetRobotVel.plus(new Pose2d(axialCorrection, 0.0, headingCorrection));
        this.setLastError(poseError);
        return new DriveSignal(correctedVelocity, targetRobotAccel);
    }

    @JvmOverloads
    public TankPIDVAFollower(@NotNull PIDCoefficients axialCoeffs, @NotNull PIDCoefficients crossTrackCoeffs, @NotNull Pose2d admissibleError, double timeout, @NotNull NanoClock clock) {
        Intrinsics.checkNotNullParameter((Object)axialCoeffs, (String)"axialCoeffs");
        Intrinsics.checkNotNullParameter((Object)crossTrackCoeffs, (String)"crossTrackCoeffs");
        Intrinsics.checkNotNullParameter((Object)admissibleError, (String)"admissibleError");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(admissibleError, timeout, clock);
        this.axialController = new PIDFController(axialCoeffs, 0.0, 0.0, 0.0, null, null, 62, null);
        this.crossTrackController = new PIDFController(crossTrackCoeffs, 0.0, 0.0, 0.0, null, null, 62, null);
        this.lastError = new Pose2d(0.0, 0.0, 0.0, 7, null);
    }

    public /* synthetic */ TankPIDVAFollower(PIDCoefficients pIDCoefficients, PIDCoefficients pIDCoefficients2, Pose2d pose2d, double d, NanoClock nanoClock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pose2d = new Pose2d(0.0, 0.0, 0.0, 7, null);
        }
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            nanoClock = NanoClock.Companion.system();
        }
        this(pIDCoefficients, pIDCoefficients2, pose2d, d, nanoClock);
    }

    @JvmOverloads
    public TankPIDVAFollower(@NotNull PIDCoefficients axialCoeffs, @NotNull PIDCoefficients crossTrackCoeffs, @NotNull Pose2d admissibleError, double timeout) {
        this(axialCoeffs, crossTrackCoeffs, admissibleError, timeout, null, 16, null);
    }

    @JvmOverloads
    public TankPIDVAFollower(@NotNull PIDCoefficients axialCoeffs, @NotNull PIDCoefficients crossTrackCoeffs, @NotNull Pose2d admissibleError) {
        this(axialCoeffs, crossTrackCoeffs, admissibleError, 0.0, null, 24, null);
    }

    @JvmOverloads
    public TankPIDVAFollower(@NotNull PIDCoefficients axialCoeffs, @NotNull PIDCoefficients crossTrackCoeffs) {
        this(axialCoeffs, crossTrackCoeffs, null, 0.0, null, 28, null);
    }
}

