/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.followers;

import com.acmerobotics.roadrunner.drive.DriveSignal;
import com.acmerobotics.roadrunner.followers.TrajectoryFollower;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import com.acmerobotics.roadrunner.util.NanoClock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/acmerobotics/roadrunner/followers/RamseteFollower;", "Lcom/acmerobotics/roadrunner/followers/TrajectoryFollower;", "b", "", "zeta", "admissibleError", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "timeout", "clock", "Lcom/acmerobotics/roadrunner/util/NanoClock;", "(DDLcom/acmerobotics/roadrunner/geometry/Pose2d;DLcom/acmerobotics/roadrunner/util/NanoClock;)V", "<set-?>", "lastError", "getLastError", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setLastError", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "internalUpdate", "Lcom/acmerobotics/roadrunner/drive/DriveSignal;", "currentPose", "currentRobotVel", "sinc", "x", "core"})
public final class RamseteFollower
extends TrajectoryFollower {
    @NotNull
    private Pose2d lastError;
    private final double b;
    private final double zeta;

    @Override
    @NotNull
    public Pose2d getLastError() {
        return this.lastError;
    }

    @Override
    protected void setLastError(@NotNull Pose2d pose2d) {
        Intrinsics.checkNotNullParameter((Object)pose2d, (String)"<set-?>");
        this.lastError = pose2d;
    }

    private final double sinc(double x) {
        double d;
        if (MathUtilKt.epsilonEquals(x, 0.0)) {
            d = 1.0 - x * x / 6.0;
        } else {
            boolean bl = false;
            d = Math.sin(x) / x;
        }
        return d;
    }

    @Override
    @NotNull
    protected DriveSignal internalUpdate(@NotNull Pose2d currentPose, @Nullable Pose2d currentRobotVel) {
        double k1;
        Intrinsics.checkNotNullParameter((Object)currentPose, (String)"currentPose");
        double t = this.elapsedTime();
        Pose2d targetPose = this.getTrajectory().get(t);
        Pose2d targetVel = this.getTrajectory().velocity(t);
        Pose2d targetRobotVel = Kinematics.fieldToRobotVelocity(targetPose, targetVel);
        double targetV = targetRobotVel.getX();
        double targetOmega = targetRobotVel.getHeading();
        Pose2d error = targetPose.minus(currentPose);
        double d = targetOmega * targetOmega + this.b * targetV * targetV;
        boolean bl = false;
        double k3 = k1 = (double)2 * this.zeta * Math.sqrt(d);
        double k2 = this.b;
        double d2 = error.getHeading();
        boolean bl2 = false;
        double d3 = targetV * Math.cos(d2);
        d2 = currentPose.getHeading();
        bl2 = false;
        double d4 = Math.cos(d2) * error.getX();
        d2 = currentPose.getHeading();
        bl2 = false;
        double v = d3 + k1 * (d4 + Math.sin(d2) * error.getY());
        double d5 = currentPose.getHeading();
        boolean bl3 = false;
        double d6 = Math.cos(d5) * error.getY();
        d5 = currentPose.getHeading();
        bl3 = false;
        double omega = targetOmega + k2 * targetV * this.sinc(error.getHeading()) * (d6 - Math.sin(d5) * error.getX()) + k3 * error.getHeading();
        this.setLastError(error);
        return new DriveSignal(new Pose2d(v, 0.0, omega), null, 2, null);
    }

    @JvmOverloads
    public RamseteFollower(double b, double zeta, @NotNull Pose2d admissibleError, double timeout, @NotNull NanoClock clock) {
        Intrinsics.checkNotNullParameter((Object)admissibleError, (String)"admissibleError");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(admissibleError, timeout, clock);
        this.b = b;
        this.zeta = zeta;
        this.lastError = new Pose2d(0.0, 0.0, 0.0, 7, null);
    }

    public /* synthetic */ RamseteFollower(double d, double d2, Pose2d pose2d, double d3, NanoClock nanoClock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pose2d = new Pose2d(0.0, 0.0, 0.0, 7, null);
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            nanoClock = NanoClock.Companion.system();
        }
        this(d, d2, pose2d, d3, nanoClock);
    }

    @JvmOverloads
    public RamseteFollower(double b, double zeta, @NotNull Pose2d admissibleError, double timeout) {
        this(b, zeta, admissibleError, timeout, null, 16, null);
    }

    @JvmOverloads
    public RamseteFollower(double b, double zeta, @NotNull Pose2d admissibleError) {
        this(b, zeta, admissibleError, 0.0, null, 24, null);
    }

    @JvmOverloads
    public RamseteFollower(double b, double zeta) {
        this(b, zeta, null, 0.0, null, 28, null);
    }
}

