/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.followers;

import com.acmerobotics.roadrunner.drive.DriveSignal;
import com.acmerobotics.roadrunner.followers.PathFollower;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.path.Path;
import com.acmerobotics.roadrunner.util.Angle;
import com.acmerobotics.roadrunner.util.GuidingVectorField;
import com.acmerobotics.roadrunner.util.NanoClock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BO\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0014R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/acmerobotics/roadrunner/followers/GVFFollower;", "Lcom/acmerobotics/roadrunner/followers/PathFollower;", "maxVel", "", "maxAccel", "admissibleError", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "kN", "kOmega", "errorMapFunc", "Lkotlin/Function1;", "clock", "Lcom/acmerobotics/roadrunner/util/NanoClock;", "(DDLcom/acmerobotics/roadrunner/geometry/Pose2d;DDLkotlin/jvm/functions/Function1;Lcom/acmerobotics/roadrunner/util/NanoClock;)V", "gvf", "Lcom/acmerobotics/roadrunner/util/GuidingVectorField;", "<set-?>", "lastError", "getLastError", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setLastError", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "lastProjDisplacement", "lastUpdateTimestamp", "lastVel", "followPath", "", "path", "Lcom/acmerobotics/roadrunner/path/Path;", "internalUpdate", "Lcom/acmerobotics/roadrunner/drive/DriveSignal;", "currentPose", "core"})
public final class GVFFollower
extends PathFollower {
    private GuidingVectorField gvf;
    private double lastUpdateTimestamp;
    private double lastVel;
    private double lastProjDisplacement;
    @NotNull
    private Pose2d lastError;
    private final double maxVel;
    private final double maxAccel;
    private final double kN;
    private final double kOmega;
    private final Function1<Double, Double> errorMapFunc;

    @Override
    @NotNull
    public Pose2d getLastError() {
        return this.lastError;
    }

    @Override
    protected void setLastError(@NotNull Pose2d pose2d) {
        Intrinsics.checkNotNullParameter((Object)pose2d, (String)"<set-?>");
        this.lastError = pose2d;
    }

    @Override
    public void followPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.gvf = new GuidingVectorField(path, this.kN, this.errorMapFunc);
        this.lastUpdateTimestamp = this.getClock().seconds();
        this.lastVel = 0.0;
        this.lastProjDisplacement = 0.0;
        super.followPath(path);
    }

    @Override
    @NotNull
    protected DriveSignal internalUpdate(@NotNull Pose2d currentPose) {
        Intrinsics.checkNotNullParameter((Object)currentPose, (String)"currentPose");
        GuidingVectorField guidingVectorField = this.gvf;
        if (guidingVectorField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"gvf");
        }
        GuidingVectorField.GVFResult gvfResult = guidingVectorField.getExtended(currentPose.getX(), currentPose.getY(), this.lastProjDisplacement);
        double d = gvfResult.getVector().getY();
        double d2 = gvfResult.getVector().getX();
        boolean bl = false;
        double desiredHeading = Math.atan2(d, d2);
        double headingError = Angle.normDelta(desiredHeading - currentPose.getHeading());
        double desiredOmega = 0.0;
        double omega = desiredOmega + this.kOmega * headingError;
        double timestamp = this.getClock().seconds();
        double dt = timestamp - this.lastUpdateTimestamp;
        double remainingDistance = currentPose.vec().distTo(this.getPath().end().vec());
        double d3 = (double)2 * this.maxAccel * remainingDistance;
        boolean bl2 = false;
        double maxVelToStop = Math.sqrt(d3);
        double maxVelFromLast = this.lastVel + this.maxAccel * dt;
        double d4 = this.maxVel;
        boolean bl3 = false;
        boolean bl4 = false;
        double d5 = Math.min(maxVelToStop, d4);
        boolean bl5 = false;
        double velocity = Math.min(maxVelFromLast, d5);
        this.lastUpdateTimestamp = timestamp;
        this.lastVel = velocity;
        this.lastProjDisplacement = gvfResult.getDisplacement();
        Pose2d targetPose = Path.get$default(this.getPath(), gvfResult.getDisplacement(), 0.0, 2, null);
        this.setLastError(Kinematics.calculatePoseError(targetPose, currentPose));
        return new DriveSignal(new Pose2d(velocity, 0.0, omega), null, 2, null);
    }

    @JvmOverloads
    public GVFFollower(double maxVel, double maxAccel, @NotNull Pose2d admissibleError, double kN, double kOmega, @NotNull Function1<? super Double, Double> errorMapFunc, @NotNull NanoClock clock) {
        Intrinsics.checkNotNullParameter((Object)admissibleError, (String)"admissibleError");
        Intrinsics.checkNotNullParameter(errorMapFunc, (String)"errorMapFunc");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(admissibleError, clock);
        this.maxVel = maxVel;
        this.maxAccel = maxAccel;
        this.kN = kN;
        this.kOmega = kOmega;
        this.errorMapFunc = errorMapFunc;
        this.lastError = new Pose2d(0.0, 0.0, 0.0, 7, null);
    }

    public /* synthetic */ GVFFollower(double d, double d2, Pose2d pose2d, double d3, double d4, Function1 function1, NanoClock nanoClock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            nanoClock = NanoClock.Companion.system();
        }
        this(d, d2, pose2d, d3, d4, (Function1<? super Double, Double>)function1, nanoClock);
    }

    @JvmOverloads
    public GVFFollower(double maxVel, double maxAccel, @NotNull Pose2d admissibleError, double kN, double kOmega, @NotNull Function1<? super Double, Double> errorMapFunc) {
        this(maxVel, maxAccel, admissibleError, kN, kOmega, errorMapFunc, null, 64, null);
    }

    @JvmOverloads
    public GVFFollower(double maxVel, double maxAccel, @NotNull Pose2d admissibleError, double kN, double kOmega) {
        this(maxVel, maxAccel, admissibleError, kN, kOmega, null, null, 96, null);
    }
}

