/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.drive;

import com.acmerobotics.roadrunner.drive.Drive;
import com.acmerobotics.roadrunner.drive.DriveSignal;
import com.acmerobotics.roadrunner.geometry.Pose2d;
import com.acmerobotics.roadrunner.kinematics.Kinematics;
import com.acmerobotics.roadrunner.kinematics.MecanumKinematics;
import com.acmerobotics.roadrunner.localization.Localizer;
import com.acmerobotics.roadrunner.util.Angle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001\u001fB;\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H&J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H&R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/acmerobotics/roadrunner/drive/MecanumDrive;", "Lcom/acmerobotics/roadrunner/drive/Drive;", "kV", "", "kA", "kStatic", "trackWidth", "wheelBase", "lateralMultiplier", "(DDDDDD)V", "localizer", "Lcom/acmerobotics/roadrunner/localization/Localizer;", "getLocalizer", "()Lcom/acmerobotics/roadrunner/localization/Localizer;", "setLocalizer", "(Lcom/acmerobotics/roadrunner/localization/Localizer;)V", "getWheelPositions", "", "getWheelVelocities", "setDrivePower", "", "drivePower", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setDriveSignal", "driveSignal", "Lcom/acmerobotics/roadrunner/drive/DriveSignal;", "setMotorPowers", "frontLeft", "rearLeft", "rearRight", "frontRight", "MecanumLocalizer", "core"})
public abstract class MecanumDrive
extends Drive {
    @NotNull
    private Localizer localizer;
    private final double kV;
    private final double kA;
    private final double kStatic;
    private final double trackWidth;
    private final double wheelBase;
    private final double lateralMultiplier;

    @Override
    @NotNull
    public Localizer getLocalizer() {
        return this.localizer;
    }

    @Override
    public void setLocalizer(@NotNull Localizer localizer) {
        Intrinsics.checkNotNullParameter((Object)localizer, (String)"<set-?>");
        this.localizer = localizer;
    }

    @Override
    public void setDriveSignal(@NotNull DriveSignal driveSignal) {
        Intrinsics.checkNotNullParameter((Object)driveSignal, (String)"driveSignal");
        List<Double> velocities = MecanumKinematics.robotToWheelVelocities(driveSignal.getVel(), this.trackWidth, this.wheelBase, this.lateralMultiplier);
        List<Double> accelerations = MecanumKinematics.robotToWheelAccelerations(driveSignal.getAccel(), this.trackWidth, this.wheelBase, this.lateralMultiplier);
        List<Double> powers = Kinematics.calculateMotorFeedforward(velocities, accelerations, this.kV, this.kA, this.kStatic);
        this.setMotorPowers(((Number)powers.get(0)).doubleValue(), ((Number)powers.get(1)).doubleValue(), ((Number)powers.get(2)).doubleValue(), ((Number)powers.get(3)).doubleValue());
    }

    @Override
    public void setDrivePower(@NotNull Pose2d drivePower) {
        Intrinsics.checkNotNullParameter((Object)drivePower, (String)"drivePower");
        List<Double> powers = MecanumKinematics.robotToWheelVelocities(drivePower, 1.0, 1.0, this.lateralMultiplier);
        this.setMotorPowers(((Number)powers.get(0)).doubleValue(), ((Number)powers.get(1)).doubleValue(), ((Number)powers.get(2)).doubleValue(), ((Number)powers.get(3)).doubleValue());
    }

    public abstract void setMotorPowers(double var1, double var3, double var5, double var7);

    @NotNull
    public abstract List<Double> getWheelPositions();

    @Nullable
    public List<Double> getWheelVelocities() {
        return null;
    }

    @JvmOverloads
    public MecanumDrive(double kV, double kA, double kStatic, double trackWidth, double wheelBase, double lateralMultiplier) {
        this.kV = kV;
        this.kA = kA;
        this.kStatic = kStatic;
        this.trackWidth = trackWidth;
        this.wheelBase = wheelBase;
        this.lateralMultiplier = lateralMultiplier;
        this.localizer = new MecanumLocalizer(this, false, 2, null);
    }

    public /* synthetic */ MecanumDrive(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            d5 = d4;
        }
        if ((n & 0x20) != 0) {
            d6 = 1.0;
        }
        this(d, d2, d3, d4, d5, d6);
    }

    @JvmOverloads
    public MecanumDrive(double kV, double kA, double kStatic, double trackWidth, double wheelBase) {
        this(kV, kA, kStatic, trackWidth, wheelBase, 0.0, 32, null);
    }

    @JvmOverloads
    public MecanumDrive(double kV, double kA, double kStatic, double trackWidth) {
        this(kV, kA, kStatic, trackWidth, 0.0, 0.0, 48, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/acmerobotics/roadrunner/drive/MecanumDrive$MecanumLocalizer;", "Lcom/acmerobotics/roadrunner/localization/Localizer;", "drive", "Lcom/acmerobotics/roadrunner/drive/MecanumDrive;", "useExternalHeading", "", "(Lcom/acmerobotics/roadrunner/drive/MecanumDrive;Z)V", "_poseEstimate", "Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "lastExtHeading", "", "lastWheelPositions", "", "value", "poseEstimate", "getPoseEstimate", "()Lcom/acmerobotics/roadrunner/geometry/Pose2d;", "setPoseEstimate", "(Lcom/acmerobotics/roadrunner/geometry/Pose2d;)V", "<set-?>", "poseVelocity", "getPoseVelocity", "update", "", "core"})
    public static final class MecanumLocalizer
    implements Localizer {
        private Pose2d _poseEstimate;
        @Nullable
        private Pose2d poseVelocity;
        private List<Double> lastWheelPositions;
        private double lastExtHeading;
        private final MecanumDrive drive;
        private final boolean useExternalHeading;

        @Override
        @NotNull
        public Pose2d getPoseEstimate() {
            return this._poseEstimate;
        }

        @Override
        public void setPoseEstimate(@NotNull Pose2d value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.lastWheelPositions = CollectionsKt.emptyList();
            this.lastExtHeading = Double.NaN;
            if (this.useExternalHeading) {
                this.drive.setExternalHeading(value.getHeading());
            }
            this._poseEstimate = value;
        }

        @Override
        @Nullable
        public Pose2d getPoseVelocity() {
            return this.poseVelocity;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update() {
            List<Double> wheelPositions = this.drive.getWheelPositions();
            double extHeading = this.useExternalHeading ? this.drive.getExternalHeading() : Double.NaN;
            Collection collection = this.lastWheelPositions;
            boolean bl = false;
            if (!collection.isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.zip((Iterable)wheelPositions, (Iterable)this.lastWheelPositions);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Double d = ((Number)it.getFirst()).doubleValue() - ((Number)it.getSecond()).doubleValue();
                    collection2.add(d);
                }
                List wheelDeltas = (List)destination$iv$iv;
                Pose2d robotPoseDelta = MecanumKinematics.wheelToRobotVelocities(wheelDeltas, this.drive.trackWidth, this.drive.wheelBase, this.drive.lateralMultiplier);
                double finalHeadingDelta = this.useExternalHeading ? Angle.normDelta(extHeading - this.lastExtHeading) : robotPoseDelta.getHeading();
                this._poseEstimate = Kinematics.relativeOdometryUpdate(this._poseEstimate, new Pose2d(robotPoseDelta.vec(), finalHeadingDelta));
            }
            List<Double> wheelVelocities = this.drive.getWheelVelocities();
            Double extHeadingVel = this.drive.getExternalHeadingVelocity();
            if (wheelVelocities != null) {
                this.poseVelocity = MecanumKinematics.wheelToRobotVelocities(wheelVelocities, this.drive.trackWidth, this.drive.wheelBase, this.drive.lateralMultiplier);
                if (this.useExternalHeading && extHeadingVel != null) {
                    Pose2d pose2d = this.getPoseVelocity();
                    Intrinsics.checkNotNull((Object)pose2d);
                    this.poseVelocity = new Pose2d(pose2d.vec(), (double)extHeadingVel);
                }
            }
            this.lastWheelPositions = wheelPositions;
            this.lastExtHeading = extHeading;
        }

        @JvmOverloads
        public MecanumLocalizer(@NotNull MecanumDrive drive, boolean useExternalHeading) {
            Intrinsics.checkNotNullParameter((Object)drive, (String)"drive");
            this.drive = drive;
            this.useExternalHeading = useExternalHeading;
            this._poseEstimate = new Pose2d(0.0, 0.0, 0.0, 7, null);
            this.lastWheelPositions = CollectionsKt.emptyList();
            this.lastExtHeading = Double.NaN;
        }

        public /* synthetic */ MecanumLocalizer(MecanumDrive mecanumDrive, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(mecanumDrive, bl);
        }

        @JvmOverloads
        public MecanumLocalizer(@NotNull MecanumDrive drive) {
            this(drive, false, 2, null);
        }
    }
}

