/*
 * Decompiled with CFR 0.152.
 */
package com.acmerobotics.roadrunner.control;

import com.acmerobotics.roadrunner.control.PIDCoefficients;
import com.acmerobotics.roadrunner.util.MathUtilKt;
import com.acmerobotics.roadrunner.util.NanoClock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BU\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u001c\b\u0002\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005J\u0016\u0010+\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005J!\u0010,\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010.R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0013\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0013\"\u0004\b#\u0010\u001d\u00a8\u0006/"}, d2={"Lcom/acmerobotics/roadrunner/control/PIDFController;", "", "pid", "Lcom/acmerobotics/roadrunner/control/PIDCoefficients;", "kV", "", "kA", "kStatic", "kF", "Lkotlin/Function2;", "clock", "Lcom/acmerobotics/roadrunner/util/NanoClock;", "(Lcom/acmerobotics/roadrunner/control/PIDCoefficients;DDDLkotlin/jvm/functions/Function2;Lcom/acmerobotics/roadrunner/util/NanoClock;)V", "errorSum", "inputBounded", "", "<set-?>", "lastError", "getLastError", "()D", "lastUpdateTimestamp", "maxInput", "maxOutput", "minInput", "minOutput", "outputBounded", "targetAcceleration", "getTargetAcceleration", "setTargetAcceleration", "(D)V", "targetPosition", "getTargetPosition", "setTargetPosition", "targetVelocity", "getTargetVelocity", "setTargetVelocity", "getPositionError", "measuredPosition", "reset", "", "setInputBounds", "min", "max", "setOutputBounds", "update", "measuredVelocity", "(DLjava/lang/Double;)D", "core"})
public final class PIDFController {
    private double errorSum;
    private double lastUpdateTimestamp;
    private boolean inputBounded;
    private double minInput;
    private double maxInput;
    private boolean outputBounded;
    private double minOutput;
    private double maxOutput;
    private double targetPosition;
    private double targetVelocity;
    private double targetAcceleration;
    private double lastError;
    private final PIDCoefficients pid;
    private final double kV;
    private final double kA;
    private final double kStatic;
    private final Function2<Double, Double, Double> kF;
    private final NanoClock clock;

    public final double getTargetPosition() {
        return this.targetPosition;
    }

    public final void setTargetPosition(double d) {
        this.targetPosition = d;
    }

    public final double getTargetVelocity() {
        return this.targetVelocity;
    }

    public final void setTargetVelocity(double d) {
        this.targetVelocity = d;
    }

    public final double getTargetAcceleration() {
        return this.targetAcceleration;
    }

    public final void setTargetAcceleration(double d) {
        this.targetAcceleration = d;
    }

    public final double getLastError() {
        return this.lastError;
    }

    public final void setInputBounds(double min, double max) {
        if (min < max) {
            this.inputBounded = true;
            this.minInput = min;
            this.maxInput = max;
        }
    }

    public final void setOutputBounds(double min, double max) {
        if (min < max) {
            this.outputBounded = true;
            this.minOutput = min;
            this.maxOutput = max;
        }
    }

    private final double getPositionError(double measuredPosition) {
        double error = this.targetPosition - measuredPosition;
        if (this.inputBounded) {
            double inputRange = this.maxInput - this.minInput;
            while (true) {
                boolean bl = false;
                if (!(Math.abs(error) > inputRange / 2.0)) break;
                bl = false;
                error -= Math.signum(error) * inputRange;
            }
        }
        return error;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final double update(double measuredPosition, @Nullable Double measuredVelocity) {
        double d;
        double currentTimestamp = this.clock.seconds();
        double error = this.getPositionError(measuredPosition);
        double d2 = this.lastUpdateTimestamp;
        boolean bl = false;
        if (Double.isNaN(d2)) {
            this.lastError = error;
            this.lastUpdateTimestamp = currentTimestamp;
            d = 0.0;
        } else {
            double output;
            double d3;
            double d4;
            boolean bl2;
            double dt = currentTimestamp - this.lastUpdateTimestamp;
            this.errorSum += 0.5 * (error + this.lastError) * dt;
            double errorDeriv = (error - this.lastError) / dt;
            this.lastError = error;
            this.lastUpdateTimestamp = currentTimestamp;
            double d5 = this.pid.kP * error + this.pid.kI * this.errorSum;
            double d6 = this.pid.kD;
            Double d7 = measuredVelocity;
            if (d7 != null) {
                void it;
                Double d8 = d7;
                boolean bl3 = false;
                bl2 = false;
                double d9 = ((Number)d8).doubleValue();
                double d10 = d6;
                double d11 = d5;
                boolean bl4 = false;
                double d12 = this.targetVelocity - it;
                d5 = d11;
                d6 = d10;
                d4 = d12;
            } else {
                d4 = errorDeriv;
            }
            double baseOutput = d5 + d6 * d4 + this.kV * this.targetVelocity + this.kA * this.targetAcceleration + ((Number)this.kF.invoke((Object)measuredPosition, (Object)measuredVelocity)).doubleValue();
            if (MathUtilKt.epsilonEquals(baseOutput, 0.0)) {
                d3 = 0.0;
            } else {
                bl2 = false;
                d3 = output = baseOutput + Math.signum(baseOutput) * this.kStatic;
            }
            if (this.outputBounded) {
                double d13 = this.minOutput;
                double d14 = this.maxOutput;
                boolean bl5 = false;
                d14 = Math.min(output, d14);
                bl5 = false;
                d = Math.max(d13, d14);
            } else {
                d = output;
            }
        }
        return d;
    }

    public static /* synthetic */ double update$default(PIDFController pIDFController, double d, Double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = null;
        }
        return pIDFController.update(d, d2);
    }

    @JvmOverloads
    public final double update(double measuredPosition) {
        return PIDFController.update$default(this, measuredPosition, null, 2, null);
    }

    public final void reset() {
        this.errorSum = 0.0;
        this.lastError = 0.0;
        this.lastUpdateTimestamp = Double.NaN;
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid, double kV, double kA, double kStatic, @NotNull Function2<? super Double, ? super Double, Double> kF, @NotNull NanoClock clock) {
        Intrinsics.checkNotNullParameter((Object)pid, (String)"pid");
        Intrinsics.checkNotNullParameter(kF, (String)"kF");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.pid = pid;
        this.kV = kV;
        this.kA = kA;
        this.kStatic = kStatic;
        this.kF = kF;
        this.clock = clock;
        this.lastUpdateTimestamp = Double.NaN;
    }

    public /* synthetic */ PIDFController(PIDCoefficients pIDCoefficients, double d, double d2, double d3, Function2 function2, NanoClock nanoClock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            nanoClock = NanoClock.Companion.system();
        }
        this(pIDCoefficients, d, d2, d3, (Function2<? super Double, ? super Double, Double>)function2, nanoClock);
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid, double kV, double kA, double kStatic, @NotNull Function2<? super Double, ? super Double, Double> kF) {
        this(pid, kV, kA, kStatic, kF, null, 32, null);
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid, double kV, double kA, double kStatic) {
        this(pid, kV, kA, kStatic, null, null, 48, null);
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid, double kV, double kA) {
        this(pid, kV, kA, 0.0, null, null, 56, null);
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid, double kV) {
        this(pid, kV, 0.0, 0.0, null, null, 60, null);
    }

    @JvmOverloads
    public PIDFController(@NotNull PIDCoefficients pid) {
        this(pid, 0.0, 0.0, 0.0, null, null, 62, null);
    }
}

