package com.acecounter.android.acetm.common.util;

import androidx.annotation.NonNull;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public final class TypeUtil {
    @NonNull
    public static String doubleToString(final double value) {
        return String.format(Locale.getDefault(), "%.2f", value);
    }

    public static boolean isCollection(Object obj) {
        return obj.getClass().isArray() || obj instanceof Collection;
    }

    @NonNull
    public static List<?> convertObjectToList(Object obj) {
        List<?> list = new ArrayList<>();
        if (obj.getClass().isArray()) {
            list = Arrays.asList((Object[])obj);
        } else if (obj instanceof Collection) {
            list = new ArrayList<>((Collection<?>)obj);
        }
        return list;
    }

    @NonNull
    public static String encodeUTF8(@NonNull String value) throws UnsupportedEncodingException {
        return new String(value.getBytes(), ACECommonStaticConfig.CHARSET_UTF8);
    }
}
