package com.acecounter.android.acetm.common.util;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;

public final class ThreadUtil {
    /**
     * @return {@code true} if the current thread is the UI thread.
     */
    public static boolean isOnUiThread() {
        return Looper.getMainLooper().equals(Looper.myLooper());
    }

    /**
     * Throws an {@link IllegalStateException} if the current thread is not the UI thread.
     */
    public static void assertOnUiThread() {
        if (isOnUiThread()) {
            throw new IllegalStateException("Expected to run on UI thread!");
        }
    }

    /**
     * Throws an {@link IllegalStateException} if the current thread is the UI thread.
     */
    public static void assertNotOnUiThread() {
        if (!isOnUiThread()) {
            throw new IllegalStateException("Expected not to run on UI thread!");
        }
    }

    /**
     * Runs the specified action on the UI thread. If the current thread is the UI
     * thread, then the action is executed immediately. If the current thread is
     * not the UI thread, the action is posted to the event queue of the UI thread.
     *
     * @param action the action to run on the UI thread
     */
    public static void runOnUiThread(@NonNull Runnable action) {
        if (!isOnUiThread()) {
            Handler mainHandler = new Handler(Looper.getMainLooper());
            mainHandler.post(action);
        } else {
            action.run();
        }
    }
}
