package com.acecounter.android.acetm.common.policy;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;

import org.json.JSONException;
import org.json.JSONObject;

import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_APPLIST_ENABLE;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_CID;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_DEBUG;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_DEBUG_LOG_URL;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_DOMAIN;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_FORCE_STOP;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_POLICY_INTERVAL;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_PRIVATE;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_SDK_ENABLE;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_SOURCE_IP;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.POLICY.RESPONSE_TOAST_APPKEY;

public final class ACEPolicyParameters {
    private String cpAllow;
    private Integer cpApp;
    private String cpCid;
    private String cpDebug;
    private String cpDomain;
    private String cpPrivate;
    private String cpSourceIP;
    private Long timeInterval;
    private String toastAppKey;
    private String cpCrashDomain;

    private ACEPolicyParameters() {
        setCpAllow(null);
        setCpApp(0);
        setCpCid(null);
        setCpDebug(null);
        setCpDomain(null);
        setCpPrivate(null);
        setCpSourceIP(null);
        setTimeInterval(0L);
        setToastAppKey(null);
    }

    //region 싱글턴
    private static class Singleton {
        private static final ACEPolicyParameters INSTANCE = new ACEPolicyParameters();
    }

    @NonNull
    public static ACEPolicyParameters getInstance() {
        return ACEPolicyParameters.Singleton.INSTANCE;
    }
    //endregion 싱글턴

    //region setter/getter
    //region cpAllow
    @NonNull
    synchronized String getCpAllow() {
        return this.cpAllow;
    }

    synchronized void setCpAllow(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpAllow = "";
        }
        else {
            this.cpAllow = value;
        }
    }
    //endregion cpAllow

    //region cpApp
    synchronized int getCpApp() {
        return this.cpApp;
    }

    synchronized void setCpApp(int value) {
        if (value < 0) {
            this.cpApp = 0;
        }
        else {
            this.cpApp = value;
        }
    }
    //endregion cpApp

    //region cpCid
    @NonNull
    public synchronized String getCpCid() {
        return this.cpCid;
    }

    synchronized void setCpCid(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpCid = "";
        }
        else {
            this.cpCid = value;
        }
    }
    //endregion cpCid

    //region cpDebug
    @Nullable
    synchronized String getCpDebug() {
        return this.cpDebug;
    }

    synchronized void setCpDebug(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpDebug = "";
        }
        else {
            this.cpDebug = value;
        }
    }
    //endregion cpDebug

    //region cpDomain
    @NonNull
    public synchronized String getCpDomain() {
        return this.cpDomain;
    }

    synchronized void setCpDomain(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpDomain = "";
        }
        else {
            this.cpDomain = value;
        }
    }
    //endregion cpDomain

    //region cpPrivate
    @NonNull
    public synchronized String getCpPrivate() {
        return this.cpPrivate;
    }

    synchronized void setCpPrivate(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpPrivate = "";
        }
        else {
            this.cpPrivate = value;
        }
    }
    //endregion cpPrivate

    //region cpSourceIP
    @Nullable
    public synchronized String getCpSourceIP() {
        return this.cpSourceIP;
    }

    synchronized void setCpSourceIP(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpSourceIP = "";
        }
        else {
            this.cpSourceIP = value;
        }
    }
    //endregion cpSourceIP

    //region cpDebugSourceIP
    @NonNull
    public synchronized String getCpCrashDomain() {
        return this.cpCrashDomain;
    }

    synchronized void setCpCrashDomain(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpCrashDomain = "";
        }
        else {
            this.cpCrashDomain = value;
        }
    }
    //endregion cpDebugSourceIP

    //region TimeInterval
    @NonNull
    public synchronized Long getTimeInterval() {
        return this.timeInterval;
    }

    synchronized void setTimeInterval(@Nullable Long value) {
        if (value == null) {
            value = 0L;
        }
        this.timeInterval = value;
    }
    //endregion TimeInterval

    //region TOAST AppKey
    @NonNull
    public synchronized String getToastAppKey() {
        return this.toastAppKey;
    }

    synchronized void setToastAppKey(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.toastAppKey = "";
        }
        else {
            this.toastAppKey = value;
        }
    }
    //endregion TOAST AppKey
    //endregion setter/getter

    //region JSON, toString
    JSONObject getParamsToJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(RESPONSE_SDK_ENABLE, this.cpAllow);
        _json.put(RESPONSE_APPLIST_ENABLE, this.cpApp);
        _json.put(RESPONSE_CID, this.cpCid);
        _json.put(RESPONSE_DEBUG, this.cpDebug);
        _json.put(RESPONSE_DOMAIN, this.cpDomain);

        ACEControlTower _controlTower = ACECommonStaticConfig.getControlTower();
        if (_controlTower != null) {
            _json.put(RESPONSE_FORCE_STOP, _controlTower.getSDKForceStop());
        }

        _json.put(RESPONSE_TOAST_APPKEY, ACEPolicyParameters.getInstance().getToastAppKey());
        _json.put(RESPONSE_PRIVATE, this.cpPrivate);
        _json.put(RESPONSE_POLICY_INTERVAL, ACEPolicy.REPEAT_PULLING_INTERVAL_SECOND);
        _json.put(RESPONSE_SOURCE_IP, this.cpSourceIP);

        return _json;
    }

    @NonNull
    @Override
    public String toString() {
        try {
            return getParamsToJSONobject().toString(2);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return super.toString();
    }
    //endregion JSON, toString
}
