package com.acecounter.android.acetm.common.parameter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

public interface IACEParameterUtil {
    public String getCookies();
    public JSONObject getParamsToJSONobject() throws JSONException;
    public Boolean isFirstLog();
    public boolean isExceptKeyInstance(@NonNull String key);
    // 에카+: CID, 에카1: ...
    public void loadUniqueKeyForSDK();
    public void resetSessionAndParameterAfterSend();
    public void resetSessionAndParameterAfterSendWithParams(@Nullable Map<String, Object> params);
    // 초기화 이후 첫 로그 파라미터 생성전 처리해야할 코드 실행
    public void setFirstLogParameters();
    public void setLogSource(int value);
    public void setReferrer(@NonNull Map<String, String> map);
    @Nullable
    public String getInstallReferrer();
    public void setInstallReferrer(@Nullable String value);

    public abstract int getSession();
    public abstract void setKeepSession();
    public abstract void setNewSession();

    // 일반화된 메서드가 아닌 특화된 setter 를 이용하는 경우
    public void setterForString(@NonNull String key, @Nullable String value);
    // 일반화된 메서드가 아닌 특화된 getter 를 이용하는 경우
    @Nullable
    public String getterForString(@NonNull String key);
}
