package com.acecounter.android.acetm.common.parameter;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.util.EncryptSharedPreferences;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;

public abstract class ACEParameters {
    private final String TAG = ACEParameters.class.getSimpleName();

    protected Context _context;
    private SharedPreferences _sharedPreferences;

    protected String gsck;

    protected Boolean isNeedSetNewSession;

    protected Integer logsource;

    protected String patch;

    @NonNull
    protected synchronized SharedPreferences getSharedPreferencesInstance() throws NullPointerException {
        if (_sharedPreferences == null) {
            throw new NullPointerException("SharedPreferences object is null.");
        }
        return _sharedPreferences;
    }

    public synchronized void initParameters(@NonNull final Context context) {
        _context = context;
        if (_sharedPreferences == null) {
            EncryptSharedPreferences encryptSharedPreferences = EncryptSharedPreferences.getInstance(_context);
            String encryptKey = ACECommonStaticConfig.getEncryptKey();
            if (!TextUtils.isEmpty(encryptKey)) {
                encryptSharedPreferences.setEncryptKey(encryptKey);
            }
            _sharedPreferences = encryptSharedPreferences;
        }
    }

    //region Cookie
    @NonNull
    protected synchronized JSONObject getCookie() {
        JSONObject _json = null;
        try {
            String _jsonString = getSharedPreferencesInstance().getString(ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE, "");
            try {
                if (!TextUtils.isEmpty(_jsonString)) {
                    _json = new JSONObject(_jsonString);
                }
                else {
                    _json = new JSONObject();
                }
            } catch (JSONException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, String.format(Locale.getDefault(), "저장된 %s 값을 불러오는 과정에 예외 발생",
                        ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE)).toString());
                _json = new JSONObject();
            } catch (ClassCastException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, String.format(Locale.getDefault(), "저장된 %s 값을 불러오는 과정에 예외 발생",
                        ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE)).toString());
                _json = new JSONObject();
            } catch (RuntimeException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, String.format(Locale.getDefault(), "저장된 %s 값을 불러오는 과정에 예외 발생",
                        ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE)).toString());
                _json = new JSONObject();
            }
        }
        catch (NullPointerException e) {
            _json = new JSONObject();
        }

        return _json;
    }

    protected synchronized void setCookie(@Nullable String key,
                                          @Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(key)) {
            return;
        }
        if (TextUtils.isEmpty(value)) {
            value = "";
        }

        try {
            JSONObject _json = getCookie();
            _json.put(key, value);

            getSharedPreferencesInstance().edit().putString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE,
                    _json.toString())
                    .apply();
        }
        catch (JSONException e) {
            ACEDebugLog.wtf(TAG, String.format(Locale.getDefault(), "%s 에 값을 저장하는 과정에 예외 발생",
                    ACEPlusStaticConfig.IN_STORAGE_KEY.COOKIE));
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "cookie 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion Cookie

    //region GSCK
    @NonNull
    public synchronized String getGSCK() throws ClassCastException {
        try {
            JSONObject _json = getCookie();
            if (_json.has(ACEStaticConfig.COOKIE.JSON_KEY_GSCK)) {
                this.gsck = _json.getString(ACEStaticConfig.COOKIE.JSON_KEY_GSCK);
            }
            else {
                this.gsck = "";
            }
        }
        catch (JSONException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, String.format(Locale.getDefault(), "저장된 %s 값을 불러오는 과정에 예외 발생",
                    ACEStaticConfig.COOKIE.JSON_KEY_GSCK)).toString());
            this.gsck = "";
        }

        return this.gsck;
    }

    public synchronized void setGSCK(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.gsck = "";
        }
        else {
            this.gsck = value;
        }

        setCookie(ACEStaticConfig.COOKIE.JSON_KEY_GSCK, this.gsck);
    }
    //endregion GSCK

    //region IsNeedSetNewSession
    public synchronized Boolean getIsNeedSetNewSession() {
        return this.isNeedSetNewSession;
    }

    public synchronized void setIsNeedSetNewSession(Boolean value) {
        this.isNeedSetNewSession = value;
    }
    //endregion IsNeedSetNewSession

    //region LOGSOURCE
    public synchronized int getLOGSOURCE() {
        return this.logsource;
    }

    public synchronized void setLOGSOURCE(int value) {
        if (value < 0) {
            this.logsource = 0;
        }
        else {
            this.logsource = value;
        }
    }
    //endregion LOGSOURCE

    //region patch
    @NonNull
    public synchronized String getPATCH() {
        if (TextUtils.isEmpty(this.patch)) {
            this.patch = ACEStaticConfig.ACECONSTANT.PATCH;
        }
        return this.patch;
    }

    public synchronized void setPATCH(String value) {
        if (TextUtils.isEmpty(value)) {
            this.patch = ACEStaticConfig.ACECONSTANT.PATCH;
        }
        else {
            this.patch = value;
        }
    }
    //endregion patch
    //endregion setter/getter

    //region JSON, toString
    protected abstract JSONObject getParamsToJSONobject() throws JSONException;

    @Override
    public String toString() {
        try {
            return getParamsToJSONobject().toString(2);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return super.toString();
    }
    //endregion JSON, toString
}
