package com.acecounter.android.acetm.common.logger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

public final class ACEException {
    private String _exceptionName;
    private String _stackTraceString;
    private String _message;
    private JSONObject _jsonDebugInfo;

    public ACEException(@Nullable Throwable throwable) {
        if (throwable != null) {
            this._exceptionName = throwable.getClass().getSimpleName();
            this._stackTraceString = throwable.getMessage();
        }
    }

    public ACEException(@Nullable Throwable throwable,
                        @Nullable String debugMessage) {
        this(throwable);
        if (!TextUtils.isEmpty(debugMessage)) {
            this._message = debugMessage;
        }
    }

    public ACEException(@Nullable Throwable throwable,
                        @Nullable String debugMessage,
                        @Nullable JSONObject debugInfo) {
        this(throwable, debugMessage);
        if (debugInfo != null) {
            _jsonDebugInfo = debugInfo;
        }
    }

    public JSONObject getJSONObject() throws JSONException {
        JSONObject _json = new JSONObject();
        if (!TextUtils.isEmpty(_exceptionName)) {
            _json.put("name", _exceptionName);
        }
        if (!TextUtils.isEmpty(_stackTraceString)) {
            _json.put("stackTrace", _stackTraceString);
        }
        if (!TextUtils.isEmpty(_message)) {
            _json.put("message", _message);
        }
        if (_jsonDebugInfo != null) {
            _json.put("info", _jsonDebugInfo);
        }

        return _json;
    }

    @NonNull
    @Override
    public String toString() {
        try {
            return getJSONObject().toString();
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return super.toString();
    }
}
