package com.acecounter.android.acetm.common.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;

public final class AceActivityLifecycleCallbacks implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = AceActivityLifecycleCallbacks.class.getSimpleName();

    private boolean _isGather;

    public AceActivityLifecycleCallbacks(boolean isGather){
        _isGather = isGather;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        IACECommonAPI commonAPI = ACECommonStaticConfig.getCommonAPI();
        if (commonAPI != null) {
            if (ACEStaticConfig.isIgnoreCase(activity)) {
                ACELog.d(TAG, "included ignoreCase: " + activity.getClass().getSimpleName());
                return;
            }
            commonAPI.onCreateByDeeplinkOrPush(activity, _isGather);
        }
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {

    }

    @Override
    public void onActivityPaused(Activity activity) {

    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }
}
