package com.acecounter.android.acetm.common.config;

import androidx.annotation.IntDef;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ACEPublicStaticConfig {

    public static final String INTERFACE_NAME = "_AceTM";
    public static final String INTERFACE_ACSDK_NAME = "ace_and_interface";
    public static final String ACEConstantCallbackEnumKeyForACEofAPI_GET_URL_STRING = "get_url_string";
    public static final String ACEConstantCallbackEnumKeyForACEofAPI_Failed_Message = "message";
    public static final String ACEConstantCallbackKey_Failed_Cause = "cause";
    public static final String ACEConstantCallbackKey_Result = "result";
    public static final String ACEConstantCallbackKey_Data = "data";


    public enum ACEGender {
        Unknown ("", 0),
        Man("man", 1),
        Woman("woman", 2);

        private String name;
        private Integer value;

        ACEGender(String name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            JSONObject _json = new JSONObject();
            try {
                _json.put("name", getName());
                _json.put("value", getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return _json.toString();
        }
    }

    /**
     * ACEPlatform Platform
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            ACEPlatform.ACPlus,
            ACEPlatform.ACOne})
    public @interface ACEPlatform {
        int ACPlus = 0;
        int ACOne = 1;
    }

    public enum ACEMaritalStatus {
        Unknown ("", 0),
        Married("married", 1),
        Single("single", 2);

        private String name;
        private Integer value;

        ACEMaritalStatus(String name, Integer value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            JSONObject _json = new JSONObject();
            try {
                _json.put("name", getName());
                _json.put("value", getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return _json.toString();
        }
    }

    public enum ACEParamsType {
        AddInCart, DeleteInCart,

        TrackLinkEvent, TrackTelEvent,

        TrackEvent,

        AppearProduct, Buy,

        Leave, Login, Join,

        Search, None;
    }
}
