package com.acecounter.android.acetm.acplus.parameter;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.util.StringUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class APIForInstallReferrer extends Task {
    private static final String TAG = APIForInstallReferrer.class.getSimpleName();

    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;

    APIForInstallReferrer(final int logSource,
                 @Nullable Map<String, Object> parameters,
                 @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _as = null;
        String _ms = null;
        String _tk = null;
        String _gsck = null;
        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.AS)) {
                _as = (String) _parameters.get(ACEReducerForPlusAPIParamKey.AS);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.MS)) {
                _ms = (String) _parameters.get(ACEReducerForPlusAPIParamKey.MS);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.TK)) {
                _tk = (String) _parameters.get(ACEReducerForPlusAPIParamKey.TK);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.GSCK)) {
                _gsck = (String) _parameters.get(ACEReducerForPlusAPIParamKey.GSCK);
            }
        }

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        if (!StringUtils.isNull(_as)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _as: %s", this.getTaskHash(), _as));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _as is null", this.getTaskHash()));
        }
        _parametersForPlus.setAS(_as);

        if (!StringUtils.isNull(_ms)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _ms: %s", this.getTaskHash(), _ms));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _ms is null", this.getTaskHash()));
        }
        _parametersForPlus.setMS(_ms);

        if (!StringUtils.isNull(_tk)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _tk: %s", this.getTaskHash(), _tk));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _tk is null", this.getTaskHash()));
        }
        _parametersForPlus.setTK(_tk);

        if (!StringUtils.isNull(_gsck)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _gsck: %s", this.getTaskHash(), _gsck));
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _gsck is null", this.getTaskHash()));
        }
        _parametersForPlus.setGSCK(_gsck);

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));
            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                result.put("response", "done");
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void didWork() {
        super.didWork();
    }
}

