package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.util.StringUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackEnumKeyForACEofAPI_Failed_Message;
import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackEnumKeyForACEofAPI_GET_URL_STRING;

public final class APIForHybrid extends Task {
    private static final String TAG = APIForHybrid.class.getSimpleName();

    @Nullable
    private Context _context;
    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;
    @Nullable
    private String _singleUsePvParameters;

    APIForHybrid(final int logSource,
                 @Nullable Map<String, Object> parameters,
                 @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _pageName = null;
        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context) _parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAGE_NAME)) {
                _pageName = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PAGE_NAME);
            }
        }

        if (StringUtils.isNull(_pageName)) {
            if (_context != null) {
                _pageName = ACEParameterUtil.getContextName(_context);
            }
        }
        if (StringUtils.isNull(_pageName)) {
            _pageName = "";
        }

        try {
            JSONObject _result = new JSONObject();
            _result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
            _singleUsePvParameters = ACEParameterUtilForPlus.getInstance()
                    .getSingleUsePvParametersWithPageNameStylePlain(this._logSource, _pageName);

            if (callbackForTask != null) {
                callbackForTask.callback();
            }

            if (this._doneWorkCallback != null) {
                if (!TextUtils.isEmpty(_singleUsePvParameters)) {
                    _result.put(ACEConstantCallbackEnumKeyForACEofAPI_GET_URL_STRING, _singleUsePvParameters);
                    this._doneWorkCallback.completed(_result);
                } else {
                    _result.put(ACEConstantCallbackEnumKeyForACEofAPI_Failed_Message, "singleUsePvParameters is null");
                    this._doneWorkCallback.failed(_result);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void didWork() {
        super.didWork();
    }
}
