package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACELOG_JSON_KEY;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.util.URLUtils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForFailedLogJSON extends Task {
    private final String TAG = APIForFailedLogJSON.class.getSimpleName();

    @Nullable
    private Context _context;
    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;
    @Nullable
    private JSONObject _jsonRootObject;
    @Nullable
    private JSONObject _jsonObject;
    @Nullable
    private String _cookie;

    APIForFailedLogJSON(final int logSource,
                        @Nullable Map<String, Object> parameters,
                        @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
        _jsonRootObject = null;
        _jsonObject = null;
        _cookie = ACEParameterUtilForPlus.getInstance().getGSCKForCookie();
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.JSON_OBJECT)) {
                _jsonRootObject = (JSONObject)_parameters.get(ACEReducerForPlusAPIParamKey.JSON_OBJECT);
                if (_jsonRootObject != null) {
                    if (_jsonRootObject.has(ACELOG_JSON_KEY.PARAMS)) {
                        try {
                            _jsonObject = (JSONObject) _jsonRootObject.get(ACELOG_JSON_KEY.PARAMS);
                            if (_jsonObject != null) {
                                _jsonObject.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.CID, ACEParametersForPlus.getInstance().getCID());
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    if (_jsonRootObject.has(ACELOG_JSON_KEY.REQUEST)) {
                        try {
                            JSONObject _jsonRequest = (JSONObject) _jsonRootObject.get(ACELOG_JSON_KEY.REQUEST);
                            if (_jsonRequest.has(ACELOG_JSON_KEY.REQUEST_COOKIE)) {
                                String _cookieInFailedLog = (String) _jsonRequest.get(ACELOG_JSON_KEY.REQUEST_COOKIE);
                                if (!TextUtils.isEmpty(_cookieInFailedLog)) {
                                    _cookie = _cookieInFailedLog;
                                }
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        try {
            if (_jsonRootObject != null) {
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "%d, doWork result _params: %s", this.getTaskHash(), _jsonRootObject.toString(2)));
            }
        }
        catch (JSONException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "실패 로그 doWork ACELog 과정에 예외 발생").toString());
        }

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return URLUtils.convertFailedLogJsonToGetURL(ACEStaticConfig.HTTP_METHOD.GET, _jsonRootObject);
            }
        });
        networkAdapter.setGetRequestHeaderMap(new ACENetwork.OnGetRequestHeaderMap() {
            @NonNull
            @Override
            public ConcurrentHashMap<String, String> getRequestHeaderMap() {
                ConcurrentHashMap<String, String> _map = new ConcurrentHashMap<>();
                _map.put(ACEStaticConfig.LOG.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
                if (ACEStaticConfig.USER_AGENT != null) {
                    _map.put(ACEStaticConfig.LOG.REQUEST_USER_AGENT, ACEStaticConfig.USER_AGENT);
                }
                if (!TextUtils.isEmpty(_cookie)) {
                    _map.put(ACEStaticConfig.LOG.REQUEST_COOKIE, _cookie);
                }
                else {
                    String _cookieNow = ACEParameterUtilForPlus.getInstance().getGSCKForCookie();
                    if (!TextUtils.isEmpty(_cookieNow)) {
                        _map.put(ACEStaticConfig.LOG.REQUEST_COOKIE, _cookieNow);
                    }
                }
                return _map;
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForFailedLogJSON.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForFailedLogJSON.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json;
            if (_jsonRootObject != null) {
                _json = _jsonRootObject;
            }
            else {
                _json = getJSONobject();
            }

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() { }

    @Override
    public JSONObject getJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ACELOG_JSON_KEY.LOGTYPE, ACEStaticConfig.ACELOG_TYPE.API_LOG);
        if (_jsonObject != null) {
            if (_jsonObject.has(ACELOG_JSON_KEY.CREATETIME)) {
                _json.put(ACELOG_JSON_KEY.CREATETIME, _jsonObject.get(ACELOG_JSON_KEY.CREATETIME));
            }
            if (_jsonObject.has(ACELOG_JSON_KEY.REQUEST)) {
                _json.put(ACELOG_JSON_KEY.REQUEST, _jsonObject.getJSONObject(ACELOG_JSON_KEY.REQUEST));
            }
            if (_jsonObject.has(ACELOG_JSON_KEY.PARAMS)) {
                _json.put(ACELOG_JSON_KEY.PARAMS, _jsonObject.getJSONObject(ACELOG_JSON_KEY.PARAMS));
            }

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_jsonObject.has(ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _jsonObject.getInt(ACELOG_JSON_KEY.FAILED_COUNT);
            }
            _json.put(ACELOG_JSON_KEY.FAILED_COUNT, count);
        }
        else {
            _json.put(ACELOG_JSON_KEY.CREATETIME, getCreateTime().getTime());
        }

        return _json;
    }
}
