package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

final class APIForError extends Task {
    private final String TAG = APIForError.class.getSimpleName();

    @Nullable
    protected Context _context;
    @Nullable
    protected ConcurrentHashMap<String, Object> _parameters;

    APIForError(final int logSource,
                @Nullable Map<String, Object> parameters,
                @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        String _reason = null;
        Integer _errCode = null;

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
        _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.JSERR);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForPlusAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.REASON)) {
                _reason = (String)_parameters.get(ACEReducerForPlusAPIParamKey.REASON);
            }
            if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ERROR_CODE)) {
                _errCode = (Integer)_parameters.get(ACEReducerForPlusAPIParamKey.ERROR_CODE);
            }
        }

        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.CodeErr: {
                _parametersForPlus.setEREF(_reason);
                if (_errCode != null) {
                    _parametersForPlus.setERN(_errCode);
                }
                else {
                    _parametersForPlus.setERN(0);
                }
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        super.didWork();
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForError.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForError.this.failed(throwable);
            }
        });
    }

    @Override
    public void doneWork() {
        ACEParametersForPlus.getInstance().setERN(0);
        ACEParametersForPlus.getInstance().setEREF(null);
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}
