package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.file.ACEFileUtil;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public final class APIForCommerce extends Task {
    private final String TAG = APIForCommerce.class.getSimpleName();

    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;

    APIForCommerce(final int logSource,
                   @Nullable Map<String, Object> parameters,
                   @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();
        _parameterUtilForPlus.getUserInformation();
        _parameterUtilForPlus.setPushParameters();

        switch (_logSource) {
            case ACEPlusStaticConfig.ACEofAPIForPlus.AddCart: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.CART);

                String productQuery = null;
                String orderNumber = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY)) {
                        productQuery = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ORDER_NUMBER)) {
                        orderNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.ORDER_NUMBER);
                    }
                }
                _parametersForPlus.setEREF(productQuery);
                _parametersForPlus.setORN(orderNumber);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.BannerClick: {
                Integer bannerCode = null;
                Integer promotionCode = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.BANNER_CODE)) {
                        bannerCode = (Integer) _parameters.get(ACEReducerForPlusAPIParamKey.BANNER_CODE);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PROMOTION_CODE)) {
                        promotionCode = (Integer) _parameters.get(ACEReducerForPlusAPIParamKey.PROMOTION_CODE);
                    }
                }
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.BC);
                if (promotionCode == null) {
                    promotionCode = 0;
                }
                _parametersForPlus.setEREF(promotionCode.toString());
                if (bannerCode == null) {
                    bannerCode = 0;
                }
                _parametersForPlus.setSM(bannerCode);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.BannerView: {
                Integer bannerCode = null;
                Integer promotionCode = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.BANNER_CODE)) {
                        bannerCode = (Integer) _parameters.get(ACEReducerForPlusAPIParamKey.BANNER_CODE);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PROMOTION_CODE)) {
                        promotionCode = (Integer) _parameters.get(ACEReducerForPlusAPIParamKey.PROMOTION_CODE);
                    }
                }
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.BV);
                if (promotionCode == null) {
                    promotionCode = 0;
                }
                _parametersForPlus.setEREF(promotionCode.toString());
                if (bannerCode == null) {
                    bannerCode = 0;
                }
                _parametersForPlus.setSM(bannerCode);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.BuyList:
            case ACEPlusStaticConfig.ACEofAPIForPlus.BuyLists: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.BUY);

                String paymentMethod = null;
                String orderNumber = null;
                String totalPrice = null;
                String productQuery = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD)) {
                        paymentMethod = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ORDER_NUMBER)) {
                        orderNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.ORDER_NUMBER);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.TOTAL_PRICE)) {
                        totalPrice = (String) _parameters.get(ACEReducerForPlusAPIParamKey.TOTAL_PRICE);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY)) {
                        productQuery = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY);
                    }
                }
                _parametersForPlus.setOPA(paymentMethod);
                _parametersForPlus.setORN(orderNumber);
                _parametersForPlus.setORP(totalPrice);
                _parametersForPlus.setEREF(productQuery);
                _parameterUtilForPlus.saveOVTAtNow();
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.BuyNow: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.NOW);

                String productQuery = null;
                String orderNumber = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY)) {
                        productQuery = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ORDER_NUMBER)) {
                        orderNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.ORDER_NUMBER);
                    }
                }
                _parametersForPlus.setEREF(productQuery);
                _parametersForPlus.setORN(orderNumber);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.ClickName: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.CLICK);
                String clickName = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.CLICK_NAME)) {
                        clickName = (String) _parameters.get(ACEReducerForPlusAPIParamKey.CLICK_NAME);
                    }
                }
                _parametersForPlus.setEREF(clickName);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.Pay:
            case ACEPlusStaticConfig.ACEofAPIForPlus.Paies: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.PAY);

                String payName = null;
                String productQuery = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD)) {
                        payName = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY)) {
                        productQuery = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY);
                    }
                }
                _parametersForPlus.setPYN(payName);
                _parametersForPlus.setEREF(productQuery);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.Review: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.REVIEW);

                String productNumber = null;
                String reviewContents = null;
                Integer score = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER)) {
                        productNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.REVIEW_CONTENTS)) {
                        reviewContents = (String) _parameters.get(ACEReducerForPlusAPIParamKey.REVIEW_CONTENTS);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.SCORE)) {
                        score = (Integer) _parameters.get(ACEReducerForPlusAPIParamKey.SCORE);
                    }
                }
                _parametersForPlus.setPNO(productNumber);
                _parametersForPlus.setPRN(reviewContents);
                if (score == null) {
                    score = 0;
                }
                _parametersForPlus.setPRT(score);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.SNS: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.SNS);
                String productNumber = null;
                String snsName = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER)) {
                        productNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.SNS_NAME)) {
                        snsName = (String) _parameters.get(ACEReducerForPlusAPIParamKey.SNS_NAME);
                    }
                }
                _parametersForPlus.setPNO(productNumber);
                _parametersForPlus.setEREF(snsName);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.Tel: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.EVENT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.TEL);
                String phoneNumber = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PHONE_NUMBER)) {
                        phoneNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PHONE_NUMBER);
                    }
                }
                _parametersForPlus.setEREF(phoneNumber);
                break;
            }
            case ACEPlusStaticConfig.ACEofAPIForPlus.WishList: {
                _parametersForPlus.setACM(ACEPlusStaticConfig.ParamsPlusEnum_ACM.PRODUCT);
                _parametersForPlus.setAEM(ACEPlusStaticConfig.ParamsPlusEnum_AEM.WISH);

                String productQuery = null;
                String orderNumber = null;
                if (_parameters != null) {
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY)) {
                        productQuery = (String) _parameters.get(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY);
                    }
                    if (_parameters.containsKey(ACEReducerForPlusAPIParamKey.ORDER_NUMBER)) {
                        orderNumber = (String) _parameters.get(ACEReducerForPlusAPIParamKey.ORDER_NUMBER);
                    }
                }
                _parametersForPlus.setEREF(productQuery);
                _parametersForPlus.setORN(orderNumber);
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForPlus.toString()));

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForPlus.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForCommerce.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForCommerce.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACEStaticConfig.ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            Context _context = ACECommonStaticConfig.getContext();
            if (_context != null) {
                ACEFileUtil.appendFailedLogFile(_context, new JSONArray().put(_json));
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void doneWork() {
        ACEParametersForPlus _parametersForPlus = ACEParametersForPlus.getInstance();
        ACEParameterUtilForPlus _parameterUtilForPlus = ACEParameterUtilForPlus.getInstance();

        // 공통 [S]
        _parameterUtilForPlus.resetSessionAndParameterAfterSend();
        _parametersForPlus.setEREF(null);
        _parametersForPlus.getOVT();
        _parametersForPlus.setORN(null);
        // 공통 [E]

        // BannerClick, BannerView [S]
        _parametersForPlus.setSM(0);
        // BannerClick, BannerView [E]

        // BuyList, BuyLists [S]
        _parametersForPlus.setOPA(null);
        _parametersForPlus.setORP(null);
        // BuyList, BuyLists [E]

        // Pay, Paies [S]
        _parametersForPlus.setPYN(null);
        // Pay, Paies [E]

        // Review [S]
        // SNS [S]
        _parametersForPlus.setPNO(null);
        // SNS [E]
        _parametersForPlus.setPRN(null);
        _parametersForPlus.setPRT(0);
        // Review [E]
    }
}
