package com.acecounter.android.acetm.acplus.parameter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceProduct;
import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEReducerForPlusAPIParamKey;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ACEofAPIForPlus;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig.ParamsPlusEnum_Key;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACEofAPI;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.queue.ACEQueueManager;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACESendQueueManager;
import com.acecounter.android.acetm.common.queue.ACEWaitQueueManager;
import com.acecounter.android.acetm.common.util.StringUtils;
import com.acecounter.android.acetm.common.util.TypeUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackEnumKeyForACEofAPI_GET_URL_STRING;
import static com.acecounter.android.acetm.common.util.ThreadUtil.runOnUiThread;

public final class ACEReducerForPlus {
    private static final String TAG = ACEReducerForPlus.class.getSimpleName();

    @Nullable
    private static Task reduce(final int logSource,
                               @Nullable ConcurrentHashMap<String, Object> parameters,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        if (logSource != ACEofAPI.POLICY) {
            if (ACEControlTower.isCompletePolicy() && !ACEControlTower.isSDKEnabled()) {
                ACELog.i(TAG, "disabled SDK.");
                return null;
            }
        }

        switch (logSource) {
            case ACEofAPI.POLICY: {
                return new APIForPolicy(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.CodeErr: {
                return new APIForError(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.PageErr: {
                return new APIForErrorOnPage(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.DeepLinkAtRunningApp:
            case ACEofAPI.PushAtRunningApp:
            case ACEofAPIForPlus.PV:
            case ACEofAPIForPlus.PvWithPage: {
                return new APIForPV(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.DeepLinkAtStartApp:
                return new APIForDeepLinkAtStartAppForPlus(logSource, parameters, doneWorkCallback);
            case ACEofAPI.PushAtStartApp:
                return new APIForPushAtStartAppForPlus(logSource, parameters, doneWorkCallback);
            case ACEofAPIForPlus.AddCart:
            case ACEofAPIForPlus.ClickName:
            case ACEofAPIForPlus.BannerClick:
            case ACEofAPIForPlus.BannerView:
            case ACEofAPIForPlus.BuyList:
            case ACEofAPIForPlus.BuyLists:
            case ACEofAPIForPlus.BuyNow:
            case ACEofAPIForPlus.Pay:
            case ACEofAPIForPlus.Paies:
            case ACEofAPIForPlus.Review:
            case ACEofAPIForPlus.SNS:
            case ACEofAPIForPlus.Tel:
            case ACEofAPIForPlus.WishList: {
                return new APIForCommerce(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.DetailView:
            case ACEofAPIForPlus.DetailViewWithPage:
            case ACEofAPIForPlus.InnerSearch:
            case ACEofAPIForPlus.InnerSearchWithPage: {
                return new APIForCommerceOnPage(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.Deactivate: {
                return new APIForDeactivateOnPage(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.Join: {
                return new APIForJoinOnPage(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.Login: {
                return new APIForLoginOnPage(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPIForPlus.JSONParamsSend: {
                return new APIForJSON(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.FailedLogSend: {
                return new APIForFailedLogJSON(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.PvWithParameters:
            case ACEofAPIForPlus.SendNativeLog: {
                return new APIForPvWithParameters(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.onPageFinished:
            case ACEofAPI.PluginGetPVParameters: {
                return new APIForHybrid(logSource, parameters, doneWorkCallback);
            }
            case ACEofAPI.InstallReferrer: {
                return new APIForInstallReferrer(logSource, parameters, doneWorkCallback);
            }
            default:
                ACEDebugLog.wtf(TAG, "not implementation Task.");
        }
        return null;
    }

    //region Policy
    public static void requestPolicy(@Nullable final Context context) {
        ACEReducerForPlus.requestPolicy(
                context,
                null);
    }

    public static void requestPolicy(@Nullable final Context context,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }

        ACESendQueueManager.getInstance().enqueue(
                ACEReducerForPlus.reduce(
                        ACEofAPI.POLICY,
                        _map,
                        doneWorkCallback));
    }
    //endregion Policy

    //region Commerce
    public static void addCart(@Nullable final AceProduct product) {
        ACEReducerForPlus.addCart(
                product,
                null);
    }

    public static void addCart(@Nullable final AceProduct product,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        if (product == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            String _orn = String.valueOf(System.currentTimeMillis());
            for (String query : product.toQueryString()) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);
                _map.put(ACEReducerForPlusAPIParamKey.ORDER_NUMBER, _orn);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.AddCart,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void bannerClick(final int promotionCode,
                                   final int bannerCode) {
        ACEReducerForPlus.bannerClick(
                promotionCode,
                bannerCode,
                null);
    }

    public static void bannerClick(final int promotionCode,
                                   final int bannerCode,
                                   @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        _map.put(ACEReducerForPlusAPIParamKey.PROMOTION_CODE, promotionCode);
        _map.put(ACEReducerForPlusAPIParamKey.BANNER_CODE, bannerCode);

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.BannerClick,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void bannerView(final int promotionCode,
                                  final int bannerCode) {
        ACEReducerForPlus.bannerView(
                promotionCode,
                bannerCode,
                null);
    }

    public static void bannerView(final int promotionCode,
                                  final int bannerCode,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        _map.put(ACEReducerForPlusAPIParamKey.PROMOTION_CODE, promotionCode);
        _map.put(ACEReducerForPlusAPIParamKey.BANNER_CODE, bannerCode);

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.BannerView,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void buyList(@Nullable final String paymentMethod,
                               @Nullable final String orderNumber,
                               final double totalPrice,
                               @Nullable final AceProduct product) {
        ACEReducerForPlus.buyList(
                paymentMethod,
                orderNumber,
                totalPrice,
                product,
                null);
    }

    public static void buyList(@Nullable final String paymentMethod,
                               @Nullable final String orderNumber,
                               final double totalPrice,
                               @Nullable final AceProduct product,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        if (product == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            for (String query : product.toQueryString()) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                if (!StringUtils.isNull(paymentMethod)) {
                    _map.put(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD, paymentMethod);
                }
                if (!StringUtils.isNull(orderNumber)) {
                    _map.put(ACEReducerForPlusAPIParamKey.ORDER_NUMBER, orderNumber);
                }

                _map.put(ACEReducerForPlusAPIParamKey.TOTAL_PRICE, TypeUtil.doubleToString(totalPrice));
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.BuyList,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void buyLists(@Nullable final String paymentMethod,
                                @Nullable final String orderNumber,
                                final double totalPrice,
                                @Nullable final List<AceProduct> products) {
        ACEReducerForPlus.buyLists(
                paymentMethod,
                orderNumber,
                totalPrice,
                products,
                null);
    }

    public static void buyLists(@Nullable final String paymentMethod,
                                @Nullable final String orderNumber,
                                final double totalPrice,
                                @Nullable final List<AceProduct> products,
                                @Nullable ICallbackOfACE doneWorkCallback) {
        if (products == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            for (String query : AceProduct.toProductListQueryString(products)) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                if (!StringUtils.isNull(paymentMethod)) {
                    _map.put(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD, paymentMethod);
                }
                if (!StringUtils.isNull(orderNumber)) {
                    _map.put(ACEReducerForPlusAPIParamKey.ORDER_NUMBER, orderNumber);
                }

                _map.put(ACEReducerForPlusAPIParamKey.TOTAL_PRICE, TypeUtil.doubleToString(totalPrice));
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.BuyLists,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void buyNow(@Nullable final AceProduct product) {
        ACEReducerForPlus.buyNow(
                product,
                null);
    }

    public static void buyNow(@Nullable final AceProduct product,
                              @Nullable ICallbackOfACE doneWorkCallback) {
        if (product == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            String _orn = String.valueOf(System.currentTimeMillis());
            for (String query : product.toQueryString()) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);
                _map.put(ACEReducerForPlusAPIParamKey.ORDER_NUMBER, _orn);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.BuyNow,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void customerClick(@Nullable String clickName) {
        ACEReducerForPlus.customerClick(
                clickName,
                null);
    }

    public static void customerClick(@Nullable String clickName,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (!StringUtils.isNull(clickName)) {
            _map.put(ACEReducerForPlusAPIParamKey.CLICK_NAME, clickName);
        }
        else {
            _map.put(ACEReducerForPlusAPIParamKey.CLICK_NAME, "");
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.ClickName,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void detailView(@Nullable final Context context,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl) {
        ACEReducerForPlus.detailView(
                context,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl,
                null);
    }

    public static void detailView(@Nullable final Context context,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ACEReducerForPlus.detailView(
                ACEofAPIForPlus.DetailView,
                context,
                null,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl,
                doneWorkCallback);
    }

    public static void detailView(@Nullable final Context context,
                                  @Nullable final String pageName,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl) {
        ACEReducerForPlus.detailView(
                context,
                pageName,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl,
                null);
    }

    public static void detailView(@Nullable final Context context,
                                  @Nullable final String pageName,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ACEReducerForPlus.detailView(
                ACEofAPIForPlus.DetailViewWithPage,
                context,
                pageName,
                productNumber,
                productName,
                productPrice,
                productCategory,
                productImageUrl,
                doneWorkCallback);
    }

    public static void detailView(final int logsource,
                                  @Nullable final Context context,
                                  @Nullable final String pageName,
                                  @Nullable final String productNumber,
                                  @Nullable final String productName,
                                  final double productPrice,
                                  @Nullable final String productCategory,
                                  @Nullable final String productImageUrl,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(productNumber)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER, productNumber);
        }
        if (!StringUtils.isNull(productName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_NAME, productName);
        }
        _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_PRICE, TypeUtil.doubleToString(productPrice));
        if (!StringUtils.isNull(productCategory)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_CATEGORY, productCategory);
        }
        if (!StringUtils.isNull(productImageUrl)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_ImageURL, productImageUrl);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            logsource,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void innerSearch(@Nullable final Context context,
                                   @Nullable final String pageName,
                                   @Nullable final String keyword) {
        ACEReducerForPlus.innerSearch(
                context,
                pageName,
                keyword,
                null);
    }

    public static void innerSearch(@Nullable final Context context,
                                   @Nullable final String pageName,
                                   @Nullable final String keyword,
                                   @Nullable ICallbackOfACE doneWorkCallback) {
        ACEReducerForPlus.innerSearch(
                ACEofAPIForPlus.InnerSearchWithPage,
                context,
                pageName,
                keyword,
                doneWorkCallback);
    }

    public static void innerSearch(final int logsource,
                                   @Nullable final Context context,
                                   @Nullable final String pageName,
                                   @Nullable final String keyword,
                                   @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(keyword)) {
            _map.put(ACEReducerForPlusAPIParamKey.KEYWORD, keyword);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            logsource,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void pay(@Nullable final String payName,
                           @Nullable final AceProduct product) {
        ACEReducerForPlus.pay(
                payName,
                product,
                null);
    }

    public static void pay(@Nullable final String payName,
                           @Nullable final AceProduct product,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        if (product == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            for (String query : product.toQueryString()) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                if (!StringUtils.isNull(payName)) {
                    _map.put(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD, payName);
                }
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.Pay,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void paies(@Nullable final String payName,
                             @Nullable final List<AceProduct> products) {
        ACEReducerForPlus.paies(
                payName,
                products,
                null);
    }

    public static void paies(@Nullable final String payName,
                             @Nullable final List<AceProduct> products,
                             @Nullable ICallbackOfACE doneWorkCallback) {
        if (products == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            for (String query : AceProduct.toProductListQueryString(products)) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                if (!StringUtils.isNull(payName)) {
                    _map.put(ACEReducerForPlusAPIParamKey.PAYMENT_METHOD, payName);
                }
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.Paies,
                                _map,
                                doneWorkCallback));
            }
        }
    }

    public static void review(@Nullable final String productNumber,
                              @Nullable final String reviewContents,
                              final int score) {
        ACEReducerForPlus.review(
                productNumber,
                reviewContents,
                score,
                null);
    }

    public static void review(@Nullable final String productNumber,
                              @Nullable final String reviewContents,
                              final int score,
                              @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (!StringUtils.isNull(productNumber)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER, productNumber);
        }
        if (!StringUtils.isNull(reviewContents)) {
            _map.put(ACEReducerForPlusAPIParamKey.REVIEW_CONTENTS, reviewContents);
        }
        _map.put(ACEReducerForPlusAPIParamKey.SCORE, score);

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.Review,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void sns(@Nullable String productNumber,
                           @Nullable String snsName) {
        ACEReducerForPlus.sns(
                productNumber,
                snsName,
                null);
    }

    public static void sns(@Nullable String productNumber,
                           @Nullable String snsName,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (!StringUtils.isNull(productNumber)) {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER, productNumber);
        }
        else {
            _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER, "");
        }

        if (!StringUtils.isNull(snsName)) {
            _map.put(ACEReducerForPlusAPIParamKey.SNS_NAME, snsName);
        }
        else {
            _map.put(ACEReducerForPlusAPIParamKey.SNS_NAME, "");
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.SNS,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void tel(@Nullable String phoneNumber) {
        ACEReducerForPlus.tel(
                phoneNumber,
                null);
    }

    public static void tel(@Nullable String phoneNumber,
                           @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (!StringUtils.isNull(phoneNumber)) {
            _map.put(ACEReducerForPlusAPIParamKey.PHONE_NUMBER, phoneNumber);
        }
        else {
            _map.put(ACEReducerForPlusAPIParamKey.PHONE_NUMBER, "");
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.Tel,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void wishList(@Nullable final AceProduct product) {
        ACEReducerForPlus.wishList(
                product,
                null);
    }

    public static void wishList(@Nullable final AceProduct product,
                                @Nullable ICallbackOfACE doneWorkCallback) {
        if (product == null) {
            return;
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            String _orn = String.valueOf(System.currentTimeMillis());
            for (String query : product.toQueryString()) {
                ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
                _map.put(ACEReducerForPlusAPIParamKey.PRODUCT_QUERY, query);
                _map.put(ACEReducerForPlusAPIParamKey.ORDER_NUMBER, _orn);

                queueManagerFactory
                        .getQueueManager()
                        .enqueue(ACEReducerForPlus.reduce(
                                ACEofAPIForPlus.WishList,
                                _map,
                                doneWorkCallback));
            }
        }
    }
    //endregion Commerce

    //region deeplink, push, install referrer
    public static void referrer(@NonNull Map<String, String> map,
                                @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        if (map.containsKey(ParamsPlusEnum_Key.AS)) {
            String _as = map.get(ParamsPlusEnum_Key.AS);
            if (!StringUtils.isNull(_as)) {
                _map.put(ACEReducerForPlusAPIParamKey.AS, _as);
            }
        }
        else {
            ACELog.d(TAG, "not contained " + ParamsPlusEnum_Key.AS + " key.");
        }

        if (map.containsKey(ParamsPlusEnum_Key.MS)) {
            String _ms = map.get(ParamsPlusEnum_Key.MS);
            if (!StringUtils.isNull(_ms)) {
                _map.put(ACEReducerForPlusAPIParamKey.MS, _ms);
            }
        }
        else {
            ACELog.d(TAG, "not contained " + ParamsPlusEnum_Key.MS + " key.");
        }

        if (map.containsKey(ParamsPlusEnum_Key.TK)) {
            String _tk = map.get(ParamsPlusEnum_Key.TK);
            if (!StringUtils.isNull(_tk)) {
                _map.put(ACEReducerForPlusAPIParamKey.TK, _tk);
            }
        }
        else {
            ACELog.d(TAG, "not contained " + ParamsPlusEnum_Key.TK + " key.");
        }

        if (map.containsKey(ParamsPlusEnum_Key.GSCK)) {
            String _gsck = map.get(ParamsPlusEnum_Key.GSCK);
            if (!StringUtils.isNull(_gsck)) {
                _map.put(ACEReducerForPlusAPIParamKey.GSCK, _gsck);
            }
        }
        else {
            ACELog.d(TAG, "not contained " + ParamsPlusEnum_Key.GSCK + " key.");
        }

        ACEQueueManagerFactory _queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (_queueManagerFactory != null) {
            _queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPI.InstallReferrer,
                            _map,
                            doneWorkCallback));
        }
    }

    private static void deeplinkOrPush(@Nullable Intent intent) {
        ACEReducerForPlus.deeplinkOrPush(
                intent,
                null);
    }

    private static void deeplinkOrPush(@Nullable Intent intent,
                                       @Nullable ICallbackOfACE doneWorkCallback) {
        if (intent == null) {
            return;
        }

        ACEQueueManagerFactory _queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        ConcurrentHashMap<String, Object> _map = new ConcurrentHashMap<>();
        int _logSource = ACEofAPI.Unknown;
        // push
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            if (bundle.containsKey(ParamsPlusEnum_Key.ACP_PUSH)) {
                @Nullable String _acpPush = bundle.getString(ParamsPlusEnum_Key.ACP_PUSH);
                if (!TextUtils.isEmpty(_acpPush)) {
                    _map.put(ACEReducerForPlusAPIParamKey.ACP_PUSH, _acpPush);

                    _logSource = ACEofAPI.PushAtRunningApp;
                    if (_queueManagerFactory != null) {
                        @Nullable ACEQueueManager _queueManager = _queueManagerFactory.getQueueManager();
                        if (ACEParameterUtilForPlus.getInstance().isFirstLog() &&
                                _queueManager instanceof ACEWaitQueueManager &&
                                ((ACEWaitQueueManager)_queueManager).count() == 0) {
                            _logSource = ACEofAPI.PushAtStartApp;
                        }
                    }
                }
            }
        }

        // deeplink
        if (_logSource == ACEofAPI.Unknown) {
            Uri _uri = intent.getData();
            if (_uri != null) {
                String _query = _uri.getQuery();
                if (!TextUtils.isEmpty(_query)) {
                    Map<String, String> _UrlToMap = ACEParameterUtil.getURLToMap(_query);
                    if (_UrlToMap.containsKey(ParamsPlusEnum_Key.TK)) {
                        String _tk = _UrlToMap.get(ParamsPlusEnum_Key.TK);
                        _map.put(ACEReducerForPlusAPIParamKey.TK, StringUtils.getValueOrDefaultWhenNull(_tk, ""));
                        _UrlToMap.remove(ParamsPlusEnum_Key.TK);
                    }
                    if (_UrlToMap.containsKey(ParamsPlusEnum_Key.GSCK)) {
                        String _gsck = _UrlToMap.get(ParamsPlusEnum_Key.GSCK);
                        _map.put(ACEReducerForPlusAPIParamKey.GSCK, StringUtils.getValueOrDefaultWhenNull(_gsck, ""));
                        _UrlToMap.remove(ParamsPlusEnum_Key.GSCK);
                    }
                    if (_UrlToMap.containsKey(ParamsPlusEnum_Key.AS)) {
                        String _as = _UrlToMap.get(ParamsPlusEnum_Key.AS);
                        _map.put(ACEReducerForPlusAPIParamKey.AS, StringUtils.getValueOrDefaultWhenNull(_as, ""));
                        _UrlToMap.remove(ParamsPlusEnum_Key.AS);
                    }
                    if (_UrlToMap.containsKey(ParamsPlusEnum_Key.MS)) {
                        String _ms = _UrlToMap.get(ParamsPlusEnum_Key.MS);
                        _map.put(ACEReducerForPlusAPIParamKey.MS, StringUtils.getValueOrDefaultWhenNull(_ms, ""));
                        _UrlToMap.remove(ParamsPlusEnum_Key.MS);
                    }

                    Uri.Builder builder = new Uri.Builder()
                            .scheme(ACEStaticConfig.PROTOCOL_TYPE.HTTPS)
                            .encodedAuthority(ACEStaticConfig.ACECONSTANT.DOMAIN_DUMMY);
                    for (String key : _UrlToMap.keySet()) {
                        builder.appendQueryParameter(key, _UrlToMap.get(key));
                    }

                    String _prmt = builder.build().getQuery();
                    if (!TextUtils.isEmpty(_prmt)) {
                        _map.put(ACEReducerForPlusAPIParamKey.PRMT, _prmt);
                    }

                    _logSource = ACEofAPI.DeepLinkAtRunningApp;
                    if (_queueManagerFactory != null) {
                        @Nullable ACEQueueManager _queueManager = _queueManagerFactory.getQueueManager();
                        if (ACEParameterUtilForPlus.getInstance().isFirstLog() &&
                                _queueManager instanceof ACEWaitQueueManager &&
                                ((ACEWaitQueueManager)_queueManager).count() == 0) {
                            _logSource = ACEofAPI.DeepLinkAtStartApp;
                        }
                    }
                }
            }
        }

        if (_logSource == ACEofAPI.Unknown) {
            return;
        }

        if (_queueManagerFactory != null) {
            _queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            _logSource,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void onNewIntentByDeeplinkOrPush(@Nullable final Context context,
                                                   @Nullable Intent intent) {
        ACEReducerForPlus.onNewIntentByDeeplinkOrPush(
                context,
                intent,
                null);
    }

    public static void onNewIntentByDeeplinkOrPush(@Nullable final Context context,
                                                   @Nullable Intent intent,
                                                   @Nullable ICallbackOfACE doneWorkCallback) {
        deeplinkOrPush(
                intent,
                doneWorkCallback);
    }

    public static void onCreateByDeeplinkOrPush(@NonNull Context context,
                                                boolean isGather) {
        ACEReducerForPlus.onCreateByDeeplinkOrPush(
                context,
                isGather,
                null);
    }

    public static void onCreateByDeeplinkOrPush(@NonNull Context context,
                                                boolean isGather,
                                                @Nullable ICallbackOfACE doneWorkCallback) {
        if (context instanceof Activity) {
            Activity activity = (Activity) context;
            Intent intent = activity.getIntent();
            deeplinkOrPush(
                    intent,
                    doneWorkCallback);
        }

        if (isGather) {
            AceTM.pv(context);
        }
    }
    //endregion deeplink, push, install referrer

    //region err
    public static void codeErr(@Nullable final Context context,
                               final int errCode,
                               @Nullable final String reason) {
        ACEReducerForPlus.codeErr(
                context,
                errCode,
                reason,
                null);
    }

    public static void codeErr(@Nullable final Context context,
                               final int errCode,
                               @Nullable final String reason,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        _map.put(ACEReducerForPlusAPIParamKey.ERROR_CODE, errCode);
        if (!StringUtils.isNull(reason)) {
            _map.put(ACEReducerForPlusAPIParamKey.REASON, reason);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.CodeErr,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void pageErr(@Nullable final Context context,
                               @Nullable final String pageName) {
        ACEReducerForPlus.pageErr(
                context,
                pageName,
                null);
    }

    public static void pageErr(@Nullable final Context context,
                               @Nullable final String pageName,
                               @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.PageErr,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion err

    //region hybrid
    public static void onPageFinished(@NonNull final WebView webView) {
        String url = webView.getUrl();
        if (TextUtils.isEmpty(url)) {
            return;
        }

        Context context = webView.getContext();
        if (context != null) {
            String filesDirPath = context.getFilesDir().getAbsolutePath();
            if (url.contains(filesDirPath)) {
                url = url.replaceFirst(filesDirPath, "");
            }
        }

        if (url.matches("^(?i)(http|https).*")) {
            url = url.replaceFirst("^(https?://)[^/]*/?", "");
        } else if (url.matches("^(?i)(file).*")) {
            url = url.replaceFirst("^(file?://)[^/]*/?", "");
        }

        ACEReducerForPlus.getSingleUsePvParameters(
                ACEofAPI.onPageFinished,
                context,
                url,
                new ICallbackOfACE() {
                    @Override
                    public void completed(@Nullable final JSONObject result) {
                        if (result != null) {
                            try {
                                @Nullable final String resultParameters = result.getString(ACEConstantCallbackEnumKeyForACEofAPI_GET_URL_STRING);
                                if (!TextUtils.isEmpty(resultParameters)) {
                                    ACELog.v(TAG, String.format(Locale.getDefault(),
                                            "forwarding to WebView: %s", result));

                                    runOnUiThread(new Runnable() {
                                        @Override
                                        public void run() {
                                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                                                webView.evaluateJavascript("window.aceHybridApp=1", null);
                                                webView.evaluateJavascript("setTimeout(function(){_AceTM.applog('" + resultParameters + "')}, 100);", null);
                                            } else {
                                                webView.loadUrl("javascript:window.aceHybridApp=1");
                                                webView.loadUrl("javascript:setTimeout(function(){_AceTM.applog('" + resultParameters + "')}, 100);");
                                            }
                                        }
                                    });
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    @Override
                    public void failed(@Nullable JSONObject result) {
                        if (result != null) {
                            ACELog.d(TAG, String.format(Locale.getDefault(), "failed onPageFinished: %s", result.toString()));
                        }
                    }
                }
        );
    }

    public static void sendNativeLog(@Nullable final String params) {
        ACEReducerForPlus.sendNativeLog(
                params,
                null);
    }

    public static void sendNativeLog(@Nullable final String params,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        if (params == null) {
            return;
        }

        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (!TextUtils.isEmpty(params)) {
            _map.put(ACEReducerForPlusAPIParamKey.PARAMETERS, params);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.SendNativeLog,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion hybrid

    //region JSON
    public static void failedLogSend(@Nullable final Context context,
                                     @Nullable JSONObject jsonObject) {
        ACEReducerForPlus.failedLogSend(
                context,
                jsonObject,
                null);
    }

    public static void failedLogSend(@Nullable final Context context,
                                     @Nullable JSONObject jsonObject,
                                     @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (jsonObject != null) {
            _map.put(ACEReducerForPlusAPIParamKey.JSON_OBJECT, jsonObject);
        }

        ACESendQueueManager.getInstance()
                .enqueue(ACEReducerForPlus.reduce(
                        ACEofAPI.FailedLogSend,
                        _map,
                        doneWorkCallback));
    }

    private static void jsonParamsSend(@Nullable final Context context,
                                       @Nullable JSONObject jsonObject,
                                       @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (jsonObject != null) {
            _map.put(ACEReducerForPlusAPIParamKey.JSON_OBJECT, jsonObject);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.JSONParamsSend,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion JSON

    //region login, deactivate, join
    public static void login(@Nullable final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender,
                             final int group1,
                             final int group2,
                             final int group3,
                             final int group4,
                             final int group5) {
        ACEReducerForPlus.login(
                context,
                pageName,
                userId,
                userAge,
                userGender,
                group1,
                group2,
                group3,
                group4,
                group5,
                null);
    }

    public static void login(@Nullable final Context context,
                             @Nullable final String pageName,
                             @Nullable final String userId,
                             final int userAge,
                             @Nullable final AceTM.Gender userGender,
                             final int group1,
                             final int group2,
                             final int group3,
                             final int group4,
                             final int group5,
                             @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForPlusAPIParamKey.USER_ID, userId);
        }
        _map.put(ACEReducerForPlusAPIParamKey.AGE, userAge);
        if (userGender != null) {
            _map.put(ACEReducerForPlusAPIParamKey.GENDER, userGender);
        }
        _map.put(ACEReducerForPlusAPIParamKey.GROUP_1, group1);
        _map.put(ACEReducerForPlusAPIParamKey.GROUP_2, group2);
        _map.put(ACEReducerForPlusAPIParamKey.GROUP_3, group3);
        _map.put(ACEReducerForPlusAPIParamKey.GROUP_4, group4);
        _map.put(ACEReducerForPlusAPIParamKey.GROUP_5, group5);

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.Login,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void deactivate(@Nullable final Context context,
                                  @Nullable final String userId) {
        ACEReducerForPlus.deactivate(
                context,
                userId,
                null);
    }

    public static void deactivate(@Nullable final Context context,
                                  @Nullable final String userId,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForPlusAPIParamKey.USER_ID, userId);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.Deactivate,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void join(@Nullable final Context context,
                            @Nullable final String userId,
                            final int userValue) {
        ACEReducerForPlus.join(
                context,
                userId,
                userValue,
                null);
    }

    public static void join(@Nullable final Context context,
                            @Nullable final String userId,
                            final int userValue,
                            @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(userId)) {
            _map.put(ACEReducerForPlusAPIParamKey.USER_ID, userId);
        }
        _map.put(ACEReducerForPlusAPIParamKey.USER_VALUE, userValue);

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.Join,
                            _map,
                            doneWorkCallback));
        }
    }
    //endregion login, deactivate, join

    //region PV
    public static void pv(@Nullable final Context context) {
        ACEReducerForPlus.pv(context, null);
    }

    public static void pv(@Nullable final Context context,
                          @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.PV,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void pvWithPage(@Nullable final Context context,
                                  @Nullable String pageName) {
        ACEReducerForPlus.pvWithPage(
                context,
                pageName,
                null);
    }

    public static void pvWithPage(@Nullable final Context context,
                                  @Nullable String pageName,
                                  @Nullable ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            queueManagerFactory
                    .getQueueManager()
                    .enqueue(ACEReducerForPlus.reduce(
                            ACEofAPIForPlus.PvWithPage,
                            _map,
                            doneWorkCallback));
        }
    }

    public static void getSingleUsePvParameters(int logsource,
                                                @Nullable final Context context,
                                                @Nullable final String pageName,
                                                @Nullable final ICallbackOfACE doneWorkCallback) {
        ConcurrentHashMap <String, Object> _map = new ConcurrentHashMap<>();
        if (context != null) {
            _map.put(ACEReducerForPlusAPIParamKey.CONTEXT, context);
        }
        if (!StringUtils.isNull(pageName)) {
            _map.put(ACEReducerForPlusAPIParamKey.PAGE_NAME, pageName);
        }

        ACEQueueManagerFactory queueManagerFactory = ACECommonStaticConfig.getQueueManagerFactory();
        if (queueManagerFactory != null) {
            Task _task = ACEReducerForPlus.reduce(
                    logsource,
                    _map,
                    doneWorkCallback);

            if (_task == null) {
                ACELog.d(TAG, "task object is null");
                return;
            }

            ACESendQueueManager.getInstance().enqueue(_task);
        }
    }
    //endregion PV
}
