package com.acecounter.android.acetm.acplus.parameter;

import android.annotation.SuppressLint;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.AceTM;
import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.parameter.ACEParameters;
import com.acecounter.android.acetm.common.util.ACEGenderUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.UUID;

import static com.acecounter.android.acetm.common.config.ACEStaticConfig.STORE_CODE.Android_Market;

public final class ACEParametersForPlus extends ACEParameters {
    private final String TAG = ACEParametersForPlus.class.getSimpleName();

    private String aci;
    private String acm;
    private String acpPush;
    private String aem;
    private Long aet;
    private Integer age;
    private String as;
    private Integer avc;
    private Integer avn;
    private Long avt;

    private String bv;
    private String bz;

    private String cid;
    private Integer ck;
    private String cpy;
    private String ct;

    private String dav;
    private String did;
    private String dim;
    private String dmn;
    private String dsc;
    private String dtc;

    private String eref;
    private Integer ern;

    private String gd;

    private String inkw;

    private String mid;
    private String ms;
    private Integer mt;
    private Integer mv;

    private String opa;
    private String orn;
    private String orp;
    private String os;
    private Long ovt;

    private Integer pcm;
    private String pd;
    private String piu;
    private String pno;
    private String pr;
    private String prmt;
    private String prn;
    private Integer prt;
    private String pvg;
    private String pvn;
    private String pyn;

    private String rdm;
    private Integer rel;
    private Integer rnd;

    private Integer sm;
    private String sv;

    private String tk;

    private Integer ud1;
    private Integer ud2;
    private Integer ud3;
    private Integer ud4;
    private Integer ud5;
    private String uid;
    private String ul;
    private String url;

    private ACEParametersForPlus() { }

    //region 싱글턴
    private static class Singleton {
        private static final ACEParametersForPlus INSTANCE = new ACEParametersForPlus();
    }

    @NonNull
    public static ACEParametersForPlus getInstance() {
        return ACEParametersForPlus.Singleton.INSTANCE;
    }
    //endregion 싱글턴

    //region setter/getter

    //region ACI
    @NonNull
    String getACI() {
        if (TextUtils.isEmpty(this.aci)) {
            this.aci = "";
        }
        return this.aci;
    }

    void setACI(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.aci = "";
        }
        else {
            this.aci = value;
        }
    }
    //endregion ACI

    //region ACM
    @NonNull
    public String getACM() {
        if (TextUtils.isEmpty(this.acm)) {
            this.acm = "";
        }
        return this.acm;
    }

    public void setACM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.acm = "";
        }
        else {
            this.acm = value;
        }
    }
    //endregion ACM

    //region ACP_PUSH
    @NonNull
    public String getACP_PUSH() {
        if (TextUtils.isEmpty(this.acpPush)) {
            this.acpPush = "";
        }
        return this.acpPush;
    }

    void setACP_PUSH(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.acpPush = "";
        }
        else {
            this.acpPush = value;
        }
    }
    //endregion ACP_PUSH

    //region AEM
    @NonNull
    public String getAEM() {
        if (TextUtils.isEmpty(this.aem)) {
            this.aem = "";
        }
        return this.aem;
    }

    public void setAEM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.aem = "";
        }
        else {
            this.aem = value;
        }
    }
    //endregion AEM

    //region AET
    synchronized long getAET() throws ClassCastException {
        try {
            this.aet = getSharedPreferencesInstance().getLong(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AET,
                    0L);
        }
        catch (NullPointerException e) {
            this.aet = 0L;
        }
        return this.aet;
    }

    public synchronized void setAET(long value) throws ClassCastException {
        if (value < 0) {
            this.aet = 0L;
        }
        else {
            this.aet = value;
        }
        try {
            getSharedPreferencesInstance().edit().putLong(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AET,
                    this.aet)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "aet 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion AET

    //region AGE
    @SuppressWarnings("UnusedReturnValue")
    public synchronized int getAGE() throws ClassCastException {
        try {
            this.age = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AGE,
                    0);
        }
        catch (NullPointerException e) {
            this.age = 0;
        }
        return this.age;
    }

    public synchronized void setAGE(int value) throws ClassCastException {
        this.setAGE_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AGE,
                    this.age)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "age 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setAGE_nonInStorage(int value) {
        if (value < 0) {
            this.age = 0;
        }
        else {
            this.age = value;
        }
    }
    //endregion AGE

    //region AS
    @NonNull
    public synchronized String getAS() {
        if (TextUtils.isEmpty(this.ms)) {
            this.as = "";
        }
        return this.as;
    }

    synchronized void setAS(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.as = "";
        }
        else {
            this.as = value;
            setDSC(value);
        }
    }
    //endregion AS

    //region AVC
    synchronized int getAVC() throws ClassCastException {
        try {
            this.avc = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AVC,
                    0);
        }
        catch (NullPointerException e) {
            this.avc = 0;
        }
        return this.avc;
    }

    synchronized void setAVC(int value) throws ClassCastException {
        if (value < 0) {
            this.avc = 0;
        }
        else {
            this.avc = value;
        }
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.AVC,
                    this.avc)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "avc 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion AVC

    //region AVN
    synchronized int getAVN() {
        if (this.avn == null) {
            this.avn = 0;
        }
        return this.avn;
    }

    synchronized void setAVN(int value) {
        if (value < 0) {
            value = 0;
        }

        this.avn = value;
    }
    //endregion AVN

    //region AVT
    synchronized long getAVT() {
        if (this.avt == null) {
            this.avt = 0L;
        }
        return this.avt;
    }

    synchronized void setAVT(long value) {
        if (value < 0) {
            this.avt = 0L;
        }
        else {
            this.avt = value;
        }
    }
    //endregion AVT

    //region BV
    synchronized String getBV() {
        if (TextUtils.isEmpty(this.bv)) {
            this.bv = "";
        }
        return this.bv;
    }

    synchronized void setBV(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.bv = "";
        }
        else {
            this.bv = value;
        }
    }
    //endregion BV

    //region BZ
    public synchronized String getBZ() {
        if (TextUtils.isEmpty(this.bz)) {
            this.bz = "";
        }
        return this.bz;
    }

    synchronized void setBZ(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.bz = "";
        }
        else {
            this.bz = value;
        }
    }
    //endregion BZ

    //region CID
    @NonNull
    public synchronized String getCID() throws ClassCastException {
        try {
            this.cid = getSharedPreferencesInstance().getString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.CID,
                    "");
        }
        catch (NullPointerException e) {
            this.cid = "";
        }
        return this.cid;
    }

    synchronized void setCID(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.cid = "";
        }
        else {
            this.cid = value;
        }
        try {
            getSharedPreferencesInstance().edit().putString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.CID,
                    this.cid)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "cid 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion CID

    //region CK
    synchronized void setCK(int value) {
        if (value < 0) {
            this.ck = 0;
        }
        else {
            this.ck = value;
        }
    }
    //endregion CK

    //region CPY
    @NonNull
    synchronized String getCPY() {
        if (TextUtils.isEmpty(this.cpy)) {
            this.cpy = "";
        }
        return this.cpy;
    }

    public synchronized void setCPY(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.cpy = "";
        }
        else {
            this.cpy = value;
        }
    }
    //endregion CPY

    //region CT
    @NonNull
    public synchronized String getCT() {
        if (TextUtils.isEmpty(this.ct)) {
            this.ct = "";
        }
        return this.ct;
    }

    public synchronized void setCT(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ct = "";
        }
        else {
            this.ct = value;
        }
    }
    //endregion CT

    //region DAV
    synchronized void setDAV(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.dav = "";
        }
        else {
            this.dav = value;
        }
    }
    //endregion DAV

    //region Device ID
    @NonNull
    @SuppressLint("HardwareIds")
    String getDeviceId() {
        try {
            String adid = getSharedPreferencesInstance().getString(ACEPlusStaticConfig.IN_STORAGE_KEY.ADID, null);
            String did = getSharedPreferencesInstance().getString(ACEPlusStaticConfig.IN_STORAGE_KEY.DID, null);
            if (adid != null) {
                return adid;
            } else if (did != null) {
                return did;
            } else {
                UUID uuid = UUID.randomUUID();
                did = getSha1(uuid.toString());

                getSharedPreferencesInstance().edit().putString(ACEPlusStaticConfig.IN_STORAGE_KEY.DID, did).apply();
            }

            return did;
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "getDeviceId 과정에 nullPointerException 예외 발생").toString());
            return "";
        }
        catch (Exception e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "getDeviceId 실패 했습니다.").toString());
            return "";
        }
    }

    private String getSha1(String str) {
        try {
            if (TextUtils.isEmpty(str)) {
                return "";
            }
            MessageDigest sh = MessageDigest.getInstance("SHA-1");
            sh.update(str.getBytes());
            byte byteData[] = sh.digest();
            StringBuilder sb = new StringBuilder();

            for (byte aByteData : byteData) {
                sb.append(Integer.toString((aByteData & 0xff) + 0x100, 16).substring(1));
            }
            return sb.toString();

        } catch (NoSuchAlgorithmException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "getSha1 실패 했습니다.").toString());
            return "";
        }
    }
    //endregion Device ID

    //region DID
    @NonNull
    synchronized String getDID() {
        if (TextUtils.isEmpty(this.did)) {
            this.did = "";
        }
        return this.did;
    }

    synchronized void setDID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.did = "";
        }
        else {
            this.did = value;
        }
    }
    //endregion DID

    //region DIM
    @NonNull
    synchronized String getDIM() {
        if (TextUtils.isEmpty(this.dim)) {
            this.dim = "";
        }
        return this.dim;
    }

    synchronized void setDIM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.dim = "";
        }
        else {
            this.dim = value;
        }
    }
    //endregion DIM

    //region DMN
    @NonNull
    synchronized String getDMN() {
        if (TextUtils.isEmpty(this.dmn)) {
            this.dmn = "";
        }
        return this.dmn;
    }

    synchronized void setDMN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.dmn = "";
        }
        else {
            this.dmn = value;
        }
    }
    //endregion DMN

    //region DSC
    @SuppressWarnings("UnusedReturnValue")
    @NonNull
    synchronized String getDSC() throws ClassCastException {
        try {
            String value = getSharedPreferencesInstance().getString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.DSC,
                    Android_Market);
            if (value.isEmpty()) {
                this.dsc = Android_Market;
                return this.dsc;
            }

            this.dsc = value;
        }
        catch (NullPointerException e) {
            this.dsc = Android_Market;
        }
        return this.dsc;
    }

    synchronized void setDSC(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.dsc = Android_Market;
        }
        else {
            this.dsc = value;
        }

        try {
            getSharedPreferencesInstance().edit().putString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.DSC,
                    this.dsc)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "dsc 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion DSC

    //region DTC
    @NonNull
    synchronized String getDTC() {
        if (TextUtils.isEmpty(this.dtc)) {
            this.dtc = "";
        }
        return this.dtc;
    }

    synchronized void setDTC(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.dtc = "";
        }
        else {
            this.dtc = value;
        }
    }
    //endregion DTC

    //region EREF
    @NonNull
    public synchronized String getEREF() {
        if (TextUtils.isEmpty(this.eref)) {
            this.eref = "";
        }
        return this.eref;
    }

    public synchronized void setEREF(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.eref = "";
        }
        else {
            this.eref = value;
        }
    }
    //endregion EREF

    //region ERN
    public synchronized int getERN() {
        if (this.ern == null) {
            this.ern = 0;
        }
        return this.ern;
    }

    public synchronized void setERN(int value) {
        if (value < 0) {
            this.ern = 0;
        }
        else {
            this.ern = value;
        }
    }
    //endregion ERN

    //region GD
    @SuppressWarnings("UnusedReturnValue")
    @NonNull
    synchronized String getGD() {
        try {
            try {
                this.gd = getSharedPreferencesInstance().getString(
                        ACEPlusStaticConfig.IN_STORAGE_KEY.GD,
                        AceTM.Gender.UNKNOWN.toString());
            } catch (ClassCastException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, String.format(Locale.getDefault(), "저장된 %s 값을 불러오는 과정에 예외 발생",
                        ACEPlusStaticConfig.IN_STORAGE_KEY.GD)).toString());
                getSharedPreferencesInstance().edit().remove(ACEPlusStaticConfig.IN_STORAGE_KEY.GD).apply();
                this.gd = AceTM.Gender.UNKNOWN.toString();
            }
        }
        catch (NullPointerException e) {
            this.gd = AceTM.Gender.UNKNOWN.toString();
        }

        this.gd = ACEGenderUtils.validateGender(this.gd);

        return this.gd;
    }

    public synchronized void setGD(@Nullable AceTM.Gender value) {
        if (value == null) {
            value = AceTM.Gender.UNKNOWN;
        }
        setGD(value.toString());
    }

    synchronized void setGD(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            value = AceTM.Gender.UNKNOWN.toString();
        }
        setGD_nonInStorage(value);
        this.gd = ACEGenderUtils.validateGender(value);
        try {
            try {
                getSharedPreferencesInstance().edit().putString(
                        ACEPlusStaticConfig.IN_STORAGE_KEY.GD,
                        this.gd)
                        .apply();
            } catch (ClassCastException e) {
                getSharedPreferencesInstance().edit().remove(ACEPlusStaticConfig.IN_STORAGE_KEY.GD).apply();
                getSharedPreferencesInstance().edit().putString(
                        ACEPlusStaticConfig.IN_STORAGE_KEY.GD,
                        this.gd)
                        .apply();
            }
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "gd 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setGD_nonInStorage(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.gd = AceTM.Gender.UNKNOWN.toString();
        }
        else {
            this.gd = value;
        }
    }
    //endregion GD

    //region INKW
    @NonNull
    public synchronized String getINKW() {
        if (TextUtils.isEmpty(this.inkw)) {
            this.inkw = "";
        }
        return this.inkw;
    }

    public synchronized void setINKW(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.inkw = "";
        }
        else {
            this.inkw = value;
        }
    }
    //endregion INKW

    //region InstallReferrer
    @Nullable
    synchronized String getInstallReferrer() throws ClassCastException {
        String value = null;
        try {
            value = getSharedPreferencesInstance().getString(
                    ACEStaticConfig.IN_STORAGE.InstallReferrer,
                    null);
        }
        catch (NullPointerException e) {
            return null;
        }
        return value;
    }

    synchronized void setInstallReferrer(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            value = "";
        }

        getSharedPreferencesInstance().edit().putString(
                ACEStaticConfig.IN_STORAGE.InstallReferrer,
                value)
                .apply();
    }
    //endregion InstallReferrer

    //region MID
    @NonNull
    public synchronized String getMID() {
        if (TextUtils.isEmpty(this.mid)) {
            this.mid = "";
        }
        return this.mid;
    }

    public synchronized void setMID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.mid = "";
        }
        else {
            this.mid = value;
        }
    }
    //endregion MID

    //region MS
    @NonNull
    public synchronized String getMS() {
        if (TextUtils.isEmpty(this.ms)) {
            this.ms = "";
        }
        return this.ms;
    }

    synchronized void setMS(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.ms = "";
        }
        else {
            this.ms = value;
            setDSC(value);
        }
    }
    //endregion MS

    //region MT
    @SuppressWarnings("UnusedReturnValue")
    @ACEPlusStaticConfig.MEMBERSHIP
    synchronized int getMT() {
        try {
            this.mt = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.MT,
                    ACEPlusStaticConfig.MEMBERSHIP.DEFAULT);
        }
        catch (NullPointerException e) {
            this.mt = ACEPlusStaticConfig.MEMBERSHIP.DEFAULT;
        }
        return this.mt;
    }

    public synchronized void setMT(@ACEPlusStaticConfig.MEMBERSHIP int value) throws ClassCastException {
        setMT_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.MT,
                    this.mt)
                    .apply();
        }
        catch (NullPointerException e) {
            this.mt = ACEPlusStaticConfig.MEMBERSHIP.DEFAULT;
        }
    }

    public synchronized void removeMT() {
        this.mt = ACEPlusStaticConfig.MEMBERSHIP.DEFAULT;
        try {
            getSharedPreferencesInstance().edit().remove(ACEPlusStaticConfig.IN_STORAGE_KEY.MT).apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "mt 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setMT_nonInStorage(int value) {
        if (value < 0) {
            this.mt = 0;
        }
        else {
            this.mt = value;
        }
    }
    //endregion MT

    //region MV
    public synchronized int getMV() {
        if (this.mv == null) {
            this.mv = 0;
        }
        return this.mv;
    }

    public synchronized void setMV(int value) {
        if (value < 0) {
            this.mv = 0;
        }
        else {
            this.mv = value;
        }
    }
    //endregion MV

    //region OS
    @NonNull
    synchronized String getOS() {
        if (TextUtils.isEmpty(this.os)) {
            this.os = "";
        }
        return this.os;
    }

    synchronized void setOS(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.os = "";
        }
        else {
            this.os = value;
        }
    }
    //endregion OS

    //region OPA
    @NonNull
    public synchronized String getOPA() {
        if (TextUtils.isEmpty(this.opa)) {
            this.opa = "";
        }
        return this.opa;
    }

    public synchronized void setOPA(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.opa = "";
        }
        else {
            this.opa = value;
        }
    }
    //endregion OPA

    //region ORN
    @NonNull
    public synchronized String getORN() {
        if (TextUtils.isEmpty(this.orn)) {
            this.orn = "";
        }
        return this.orn;
    }

    public synchronized void setORN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.orn = "";
        }
        else {
            this.orn = value;
        }
    }
    //endregion ORN

    //region ORP
    @NonNull
    public synchronized String getORP() {
        if (TextUtils.isEmpty(this.orp)) {
            this.orp = "";
        }
        return this.orp;
    }

    public synchronized void setORP(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.orp = "";
        }
        else {
            this.orp = value;
        }
    }
    //endregion ORP

    //region OVT
    @SuppressWarnings("UnusedReturnValue")
    public synchronized long getOVT() throws ClassCastException {
        try {
            this.ovt = getSharedPreferencesInstance().getLong(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.OVT,
                    0L);
        }
        catch (NullPointerException e) {
            this.ovt = 0L;
        }

        return this.ovt;
    }

    public synchronized void setOVT(long value) throws ClassCastException {
        setOVT_nonInStorage(value);
        setOVT_inStorage(value);
    }

    synchronized void setOVT_nonInStorage(long value) {
        if (value < 0L) {
            this.ovt = 0L;
        }
        else {
            this.ovt = value;
        }
    }

    synchronized void setOVT_inStorage(long value) throws ClassCastException {
        if (value < 0L) {
            value = 0L;
        }

        try {
            getSharedPreferencesInstance().edit().putLong(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.OVT,
                    value)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ovt 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion OVT

    //region PCM
    @ACEPlusStaticConfig.SOURCE
    synchronized int getPCM() {
        if (this.pcm == null) {
            this.pcm = ACEPlusStaticConfig.SOURCE.ANDROID;
        }
        return this.pcm;
    }

    synchronized void setPCM(@ACEPlusStaticConfig.SOURCE int value) {
        this.pcm = value;
    }
    //endregion PCM

    //region PD
    @NonNull
    public synchronized String getPD() {
        if (TextUtils.isEmpty(this.pd)) {
            this.pd = "";
        }
        return this.pd;
    }

    public synchronized void setPD(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pd = "";
        }
        else {
            this.pd = value;
        }
    }
    //endregion PD

    //region PIU
    @NonNull
    public synchronized String getPIU() {
        if (TextUtils.isEmpty(this.piu)) {
            this.piu = "";
        }
        return this.piu;
    }

    public synchronized void setPIU(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.piu = "";
        }
        else {
            this.piu = value;
        }
    }
    //endregion PIU

    //region PNO
    @NonNull
    public synchronized String getPNO() {
        if (TextUtils.isEmpty(this.pno)) {
            this.pno = "";
        }
        return this.pno;
    }

    public synchronized void setPNO(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pno = "";
        }
        else {
            this.pno = value;
        }
    }
    //endregion PNO

    //region PR
    @NonNull
    public synchronized String getPR() {
        if (TextUtils.isEmpty(this.pr)) {
            this.pr = "";
        }
        return this.pr;
    }

    public synchronized void setPR(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pr = "";
        }
        else {
            this.pr = value;
        }
    }
    //endregion PR

    //region PRMT
    @NonNull
    public synchronized String getPRMT() {
        if (TextUtils.isEmpty(this.prmt)) {
            this.prmt = "";
        }
        return this.prmt;
    }

    synchronized void setPRMT(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.prmt = "";
        }
        else {
            this.prmt = value;
        }
    }
    //endregion PRMT

    //region PRN
    @NonNull
    public synchronized String getPRN() {
        if (TextUtils.isEmpty(this.prn)) {
            this.prn = "";
        }
        return this.prn;
    }

    public synchronized void setPRN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.prn = "";
        }
        else {
            this.prn = value;
        }
    }
    //endregion PRN

    //region PRT
    public synchronized int getPRT() {
        if (this.prt == null) {
            this.prt = 0;
        }
        return this.prt;
    }

    public synchronized void setPRT(int value) {
        if (value < 0) {
            this.prt = 0;
        }
        else {
            this.prt = value;
        }
    }
    //endregion PRT

    //region PVG
    @NonNull
    synchronized String getPVG() {
        if (TextUtils.isEmpty(this.pvg)) {
            this.pvg = "";
        }
        return this.pvg;
    }

    synchronized void setPVG(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pvg = "";
        }
        else {
            this.pvg = value;
        }
    }
    //endregion PVG

    //region PVN
    @NonNull
    synchronized String getPVN() {
        if (TextUtils.isEmpty(this.pvn)) {
            this.pvn = "";
        }
        return this.pvn;
    }

    synchronized void setPVN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pvn = "";
        }
        else {
            this.pvn = value;
        }
    }
    //endregion PVN

    //region PYN
    @NonNull
    public synchronized String getPYN() {
        if (TextUtils.isEmpty(this.pyn)) {
            this.pyn = "";
        }
        return this.pyn;
    }

    public synchronized void setPYN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pyn = "";
        }
        else {
            this.pyn = value;
        }
    }
    //endregion PYN

    //region RDM
    @NonNull
    public synchronized String getRDM() {
        if (TextUtils.isEmpty(this.rdm)) {
            this.rdm = "";
        }
        return this.rdm;
    }

    synchronized void setRDM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.rdm = "";
        }
        else {
            this.rdm = value;
        }
    }
    //endregion RDM

    //region REL
    synchronized void setREL(int value) {
        if (value < 0) {
            this.rel = 0;
        }
        else {
            this.rel = value;
        }
    }
    //endregion REL

    //region RND
    public synchronized int getRND() {
        if (this.rnd == null) {
            this.rnd = 0;
        }
        return this.rnd;
    }

    public synchronized void setRND(int value) {
        if (value < 0) {
            this.rnd = 0;
        }
        else {
            this.rnd = value;
        }
    }
    //endregion RND

    //region SM
    public synchronized int getSM() {
        if (this.sm == null) {
            this.sm = 0;
        }
        return this.sm;
    }

    public synchronized void setSM(int value) {
        if (value < 0) {
            this.sm = 0;
        }
        else {
            this.sm = value;
        }
    }
    //endregion SM

    //region SV
    synchronized void setSV(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.sv = "";
        }
        else {
            this.sv = value;
        }
    }
    //endregion SV

    //region TK
    @NonNull
    public synchronized String getTK() {
        if (TextUtils.isEmpty(this.tk)) {
            this.tk = "";
        }
        return this.tk;
    }

    synchronized void setTK(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.tk = "";
        }
        else {
            this.tk = value;
        }
    }
    //endregion TK

    //region UD1
    @SuppressWarnings("UnusedReturnValue")
    synchronized int getUD1() throws ClassCastException {
        try {
            this.ud1 = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD1,
                    0);
        }
        catch (NullPointerException e) {
            this.ud1 = 0;
        }
        return this.ud1;
    }

    public synchronized void setUD1(int value) throws ClassCastException {
        setUD1_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD1,
                    this.ud1)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ud1 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setUD1_nonInStorage(int value) {
        if (value < 0) {
            this.ud1 = 0;
        }
        else {
            this.ud1 = value;
        }
    }
    //endregion UD1

    //region UD2
    @SuppressWarnings("UnusedReturnValue")
    synchronized int getUD2() throws ClassCastException {
        try {
            this.ud2 = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD2,
                    0);
        }
        catch (NullPointerException e) {
            this.ud2 = 0;
        }
        return this.ud2;
    }

    public synchronized void setUD2(int value) throws ClassCastException {
        setUD2_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD2,
                    this.ud2)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ud2 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setUD2_nonInStorage(int value) {
        if (value < 0) {
            this.ud2 = 0;
        }
        else {
            this.ud2 = value;
        }
    }
    //endregion UD2

    //region UD3
    @SuppressWarnings("UnusedReturnValue")
    synchronized int getUD3() throws ClassCastException {
        try {
            this.ud3 = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD3,
                    0);
        }
        catch (NullPointerException e) {
            this.ud3 = 0;
        }
        return this.ud3;
    }

    public synchronized void setUD3(int value) throws ClassCastException {
        setUD3_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD3,
                    this.ud3)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ud3 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setUD3_nonInStorage(int value) {
        if (value < 0) {
            this.ud3 = 0;
        }
        else {
            this.ud3 = value;
        }
    }
    //endregion UD3

    //region UD4
    @SuppressWarnings("UnusedReturnValue")
    synchronized int getUD4() throws ClassCastException {
        try {
            this.ud4 = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD4,
                    0);
        }
        catch (NullPointerException e) {
            this.ud4 = 0;
        }
        return this.ud4;
    }

    public synchronized void setUD4(int value) throws ClassCastException {
        setUD4_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD4,
                    this.ud4)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ud4 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setUD4_nonInStorage(int value) {
        if (value < 0) {
            this.ud4 = 0;
        }
        else {
            this.ud4 = value;
        }
    }
    //endregion UD4

    //region UD5
    @SuppressWarnings("UnusedReturnValue")
    synchronized int getUD5() throws ClassCastException {
        try {
            this.ud5 = getSharedPreferencesInstance().getInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD5,
                    0);
        }
        catch (NullPointerException e) {
            this.ud5 = 0;
        }
        return this.ud5;
    }

    public synchronized void setUD5(int value) throws ClassCastException {
        setUD5_nonInStorage(value);
        try {
            getSharedPreferencesInstance().edit().putInt(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UD5,
                    this.ud5)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "ud5 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void setUD5_nonInStorage(int value) {
        if (value < 0) {
            this.ud5 = 0;
        }
        else {
            this.ud5 = value;
        }
    }
    //endregion UD5

    //region UID
    @SuppressWarnings("UnusedReturnValue")
    @NonNull
    public synchronized String getUID() throws ClassCastException {
        try {
            this.uid = getSharedPreferencesInstance().getString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UID,
                    "");
        }
        catch (NullPointerException e) {
            this.uid = "";
        }

        return this.uid;
    }

    public synchronized void setUID(@Nullable String value) throws ClassCastException {
        if (TextUtils.isEmpty(value)) {
            this.uid = "";
        }
        else {
            this.uid = value;
        }
        this.uid = getSha1(this.uid);
        try {
            getSharedPreferencesInstance().edit().putString(
                    ACEPlusStaticConfig.IN_STORAGE_KEY.UID,
                    this.uid)
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "uid 저장하는 과정에 nullPointerException 예외 발생").toString());
        }
    }

    public synchronized void removeUID() {
        this.uid = "";
        try {
            getSharedPreferencesInstance().edit().remove(ACEPlusStaticConfig.IN_STORAGE_KEY.UID).apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "uid 제거하는 과정에 nullPointerException 예외 발생").toString());
        }
    }
    //endregion UID

    //region URL
    @NonNull
    synchronized String getURL() {
        if (TextUtils.isEmpty(this.url)) {
            this.url = "";
        }
        return this.url;
    }

    synchronized void setURL(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.url = "";
        }
        else {
            this.url = value;
        }
    }
    //endregion URL

    //region UL
    @NonNull
    String getUL() {
        if (TextUtils.isEmpty(this.ul)) {
            this.ul = "";
        }
        return this.ul;
    }

    void setUL(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ul = "";
        }
        else {
            this.ul = value;
        }
    }
    //endregion UL
    //endregion setter/getter

    //region JSON, toString
    @Override
    protected JSONObject getParamsToJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ACI, this.aci);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ACM, this.acm);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ACP_PUSH, this.acpPush);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AEM, this.aem);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AET, this.aet);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AGE, this.age);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AS, this.as);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AVC, this.avc);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AVN, this.avn);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.AVT, this.avt);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.BV, this.bv);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.BZ, this.bz);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.CID, this.cid);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.CK, this.ck);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.CPY, this.cpy);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.CT, this.ct);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DAV, this.dav);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DSC, this.dsc);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DID, this.did);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DIM, this.dim);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DMN, this.dmn);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.DTC, this.dtc);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.EREF, this.eref);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ERN, this.ern);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.GD, this.gd);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.GSCK, this.gsck);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.INKW, this.inkw);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.MID, this.mid);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.MS, this.ms);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.MT, this.mt);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.MV, this.mv);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.LOGSOURCE, this.logsource);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.OPA, this.opa);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ORN, this.orn);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.ORP, this.orp);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.OVT, this.ovt);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.OS, this.os);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.Patch, this.patch);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PCM, this.pcm);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PD, this.pd);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PIU, this.piu);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PNO, this.pno);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PR, this.pr);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PRMT, this.prmt);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PRN, this.prn);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PRT, this.prt);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PVG, this.pvg);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PVN, this.pvn);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.PYN, this.pyn);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.RDM, this.rdm);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.REL, this.rel);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.RND, this.rnd);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.SM, this.sm);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.SV, this.sv);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.TK, this.tk);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UD1, this.ud1);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UD2, this.ud2);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UD3, this.ud3);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UD4, this.ud4);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UD5, this.ud5);

        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UID, this.uid);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.UL, this.ul);
        _json.put(ACEPlusStaticConfig.ParamsPlusEnum_Key.URL, this.url);

        return _json;
    }
    //endregion JSON, toString
}
