package com.acecounter.android.acetm.acplus.parameter;

import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;

import org.json.JSONObject;

import java.util.Locale;

public final class ACEInternalAPIForPlus implements IACECommonAPI {
    private static final String TAG = ACEInternalAPIForPlus.class.getSimpleName();

    @Override
    public void onCreateByDeeplinkOrPush(@NonNull Context context, boolean isGather) {
        ACEReducerForPlus.onCreateByDeeplinkOrPush(context, isGather);
    }

    @Override
    public void requestPolicy(@Nullable Context context) {
        ACEReducerForPlus.requestPolicy(context);
    }

    @Override
    public void send(int logSource, @Nullable String params) {
        @Nullable String _desc = this.getDescriptionForAPI(logSource);
        if (TextUtils.isEmpty(_desc)) {
            _desc = "not implementation logSource";
        }
        else {
            ACELog.d(TAG, "logSource desc: " + _desc);
        }

        switch (logSource) {
            case ACEStaticConfig.ACEofAPI.SendByHybridAPI:
                ACEReducerForPlus.sendNativeLog(params);
                break;
            default:
                ACELog.d(TAG, "not implementation API in send.");
        }
    }

    @Override
    public void send(int logSource,
                     @Nullable Context context,
                     @Nullable JSONObject jsonObject) {
        @Nullable String _desc = this.getDescriptionForAPI(logSource);
        if (TextUtils.isEmpty(_desc)) {
            _desc = "not implementation logSource";
        }
        else {
            ACELog.d(TAG, "logSource desc: " + _desc);
        }

        switch (logSource) {
            case ACEStaticConfig.ACEofAPI.FailedLogSend:
                ACEReducerForPlus.failedLogSend(context, jsonObject);
                break;
            default:
                ACELog.d(TAG, "not implementation API in send.");
        }
    }

    @Nullable
    @Override
    public String getDescriptionForAPI(int logSource) {
        @Nullable String description = ACEPlusStaticConfig.getDescriptionAtACEofAPIForPlus(logSource);
        if (TextUtils.isEmpty(description)) {
            description = ACEStaticConfig.getDescriptionAtACEofAPI(logSource);
        }
        return description;
    }
}
