package com.acecounter.android.acetm.acplus.config;

import android.content.Context;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringDef;

import com.acecounter.android.acetm.AceConfiguration;
import com.acecounter.android.acetm.acplus.controltower.ACEControlTowerForPlus;
import com.acecounter.android.acetm.acplus.parameter.ACEInternalAPIForPlus;
import com.acecounter.android.acetm.acplus.parameter.ACEParameterUtilForPlus;
import com.acecounter.android.acetm.acplus.queue.ACEQueueManagerFactoryForPlus;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.installreferrer.ACEInstallReferrerUtil;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;

public final class ACEPlusStaticConfig extends ACEStaticConfig {
    private static final String TAG = ACEPlusStaticConfig.class.getSimpleName();

    public static final int INSTALL_REFERRER_TIMEOUT = 60000;

    @Nullable
    private String _encryptKey;

    //region init
    public ACEPlusStaticConfig() {
        this._controlTower = new ACEControlTowerForPlus();
        this._queueManagerFactory = new ACEQueueManagerFactoryForPlus();
        this._commonAPI = new ACEInternalAPIForPlus();
    }
    //endregion init

    @Override
    public synchronized void configure(@NonNull AceConfiguration configuration,
                                       @NonNull ICallbackOfTask callback) {
        this._context = configuration.getApplication();
        this._encryptKey = configuration.getEncryptKey();
        this._key = configuration.getKey();
        this._gather = configuration.getGather();

        if (this._ignoreCaseActivityClassNameSet == null) {
            this._ignoreCaseActivityClassNameSet = new HashSet<>();
        }
        else {
            this._ignoreCaseActivityClassNameSet.clear();
        }
        this._ignoreCaseActivityClassNameSet.addAll(configuration.getIgnoreCase());

        ACEInstallReferrerUtil.launchInstallReferrerHandler();
        ACEParameterUtilForPlus.getInstance().initParameters(configuration.getApplication(), callback);
    }

    //region override methods
    @Nullable
    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public boolean getEnablePrivacyPolicy() {
        return false;
    }

    @Nullable
    @Override
    public String getEncryptKey() {
        return this._encryptKey;
    }

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public boolean isGather() {
        return this._gather;
    }

    @Nullable
    @Override
    public HashSet<String> getIgnoreCaseActivityClassNameSet() {
        return this._ignoreCaseActivityClassNameSet;
    }
    //endregion override methods

    //region getter manager instances
    @Override
    public IACECommonAPI getCommonAPI() {
        return _commonAPI;
    }

    @Override
    public ACEControlTower getControlTower() {
        return _controlTower;
    }

    @Override
    public IACEParameterUtil getParameterUtil() {
        return ACEParameterUtilForPlus.getInstance();
    }

    @Override
    public ACEQueueManagerFactory getQueueManagerFactory() {
        return _queueManagerFactory;
    }
    //endregion getter manager instances

    //region static
    @Nullable
    public static String getDescriptionAtACEofAPIForPlus(int identifier) {
        switch (identifier) {
            case ACEofAPIForPlus.AddCart:
                return "AddCart";
            case ACEofAPIForPlus.ClickName:
                return "ClickName";
            case ACEofAPIForPlus.CodeErr:
                return "CodeErr";
            case ACEofAPIForPlus.BannerClick:
                return "BannerClick";
            case ACEofAPIForPlus.BannerView:
                return "BannerView";
            case ACEofAPIForPlus.BuyList:
                return "BuyList";
            case ACEofAPIForPlus.BuyLists:
                return "BuyLists";
            case ACEofAPIForPlus.BuyNow:
                return "BuyNow";
            case ACEofAPIForPlus.Deactivate:
                return "Deactivate";
            case ACEofAPIForPlus.DetailView:
                return "DetailView";
            case ACEofAPIForPlus.DetailViewWithPage:
                return "DetailViewWithPage";
            case ACEofAPIForPlus.InnerSearch:
                return "InnerSearch";
            case ACEofAPIForPlus.InnerSearchWithPage:
                return "InnerSearchWithPage";
            case ACEofAPIForPlus.Join:
                return "Join";
            case ACEofAPIForPlus.JSONParamsSend:
                return "JSONParamsSend";
            case ACEofAPIForPlus.Login:
                return "Login";
            case ACEofAPIForPlus.Pay:
                return "Pay";
            case ACEofAPIForPlus.PageErr:
                return "PageErr";
            case ACEofAPIForPlus.Paies:
                return "Paies";
            case ACEofAPIForPlus.PV:
                return "PV";
            case ACEofAPIForPlus.PvWithPage:
                return "PvWithPage";
            case ACEofAPIForPlus.Review:
                return "Review";
            case ACEofAPIForPlus.SNS:
                return "SNS";
            case ACEofAPIForPlus.SendNativeLog:
                return "SendNativeLog";
            case ACEofAPIForPlus.Tel:
                return "Tel";
            case ACEofAPIForPlus.WishList:
                return "WishList";
        }

        return null;
    }
    //endregion static

    //region enum

    //region Parameter
    /**
     * 내부 API 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            ACEofAPIForPlus.AddCart,
            ACEofAPIForPlus.BannerClick,
            ACEofAPIForPlus.BannerView,
            ACEofAPIForPlus.BuyList,
            ACEofAPIForPlus.BuyLists,
            ACEofAPIForPlus.BuyNow,
            ACEofAPIForPlus.ClickName,
            ACEofAPIForPlus.CodeErr,
            ACEofAPIForPlus.Deactivate,
            ACEofAPIForPlus.DetailView,
            ACEofAPIForPlus.DetailViewWithPage,
            ACEofAPIForPlus.InnerSearch,
            ACEofAPIForPlus.InnerSearchWithPage,
            ACEofAPIForPlus.Join,
            ACEofAPIForPlus.JSONParamsSend,
            ACEofAPIForPlus.Login,
            ACEofAPIForPlus.Pay,
            ACEofAPIForPlus.PageErr,
            ACEofAPIForPlus.Paies,
            ACEofAPIForPlus.PV,
            ACEofAPIForPlus.PvWithPage,
            ACEofAPIForPlus.Review,
            ACEofAPIForPlus.SingleUsePvParametersWithPageNameStylePlain,
            ACEofAPIForPlus.SingleUsePvParametersWithPageNameStyleJson,
            ACEofAPIForPlus.SendNativeLog,
            ACEofAPIForPlus.SNS,
            ACEofAPIForPlus.Tel,
            ACEofAPIForPlus.WishList})
    public @interface ACEofAPIForPlus {
        int AddCart = 110;
        int BannerClick = 111;
        int BannerView = 112;
        int BuyList = 10299;
        int BuyLists = 102;
        int BuyNow = 132;
        int ClickName = 109;

        int CodeErr = 113;
        int PageErr = 106;

        int DetailView = 137;
        int DetailViewWithPage = 138;

        int InnerSearch = 19099;
        int InnerSearchWithPage = 190;

        int JSONParamsSend = 161;

        int Deactivate = 150;
        int Join = 151;
        int Login = 152;

        int Pay = 130;
        int Paies = 13099;

        int PV = 101;
        int PvWithPage = 100;
        int Review = 114;
        int SendNativeLog = 163;
        int SingleUsePvParametersWithPageNameStylePlain = 1989;
        int SingleUsePvParametersWithPageNameStyleJson = 1999;
        int SNS = 180;
        int Tel = 131;
        int WishList = 133;
    }

    /**
     * ACEReducerForPlus 의 파라미터 key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACEReducerForPlusAPIParamKey.ACP_PUSH,
            ACEReducerForPlusAPIParamKey.AGE,
            ACEReducerForPlusAPIParamKey.AS,
            ACEReducerForPlusAPIParamKey.BANNER_CODE,
            ACEReducerForPlusAPIParamKey.CLICK_NAME,
            ACEReducerForPlusAPIParamKey.CONTEXT,
            ACEReducerForPlusAPIParamKey.ERROR_CODE,
            ACEReducerForPlusAPIParamKey.GENDER,
            ACEReducerForPlusAPIParamKey.GROUP_1,
            ACEReducerForPlusAPIParamKey.GROUP_2,
            ACEReducerForPlusAPIParamKey.GROUP_3,
            ACEReducerForPlusAPIParamKey.GROUP_4,
            ACEReducerForPlusAPIParamKey.GROUP_5,
            ACEReducerForPlusAPIParamKey.GSCK,
            ACEReducerForPlusAPIParamKey.JSON_OBJECT,
            ACEReducerForPlusAPIParamKey.KEYWORD,
            ACEReducerForPlusAPIParamKey.MS,
            ACEReducerForPlusAPIParamKey.ORDER_NUMBER,
            ACEReducerForPlusAPIParamKey.PAGE_NAME,
            ACEReducerForPlusAPIParamKey.PARAMETERS,
            ACEReducerForPlusAPIParamKey.PAYMENT_METHOD,
            ACEReducerForPlusAPIParamKey.PHONE_NUMBER,
            ACEReducerForPlusAPIParamKey.PRMT,
            ACEReducerForPlusAPIParamKey.PRODUCT,
            ACEReducerForPlusAPIParamKey.PRODUCT_CATEGORY,
            ACEReducerForPlusAPIParamKey.PRODUCT_ImageURL,
            ACEReducerForPlusAPIParamKey.PRODUCT_NAME,
            ACEReducerForPlusAPIParamKey.PRODUCT_NUMBER,
            ACEReducerForPlusAPIParamKey.PRODUCT_PRICE,
            ACEReducerForPlusAPIParamKey.PRODUCT_QUERY,
            ACEReducerForPlusAPIParamKey.PROMOTION_CODE,
            ACEReducerForPlusAPIParamKey.REASON,
            ACEReducerForPlusAPIParamKey.REVIEW_CONTENTS,
            ACEReducerForPlusAPIParamKey.SCORE,
            ACEReducerForPlusAPIParamKey.SNS_NAME,
            ACEReducerForPlusAPIParamKey.TK,
            ACEReducerForPlusAPIParamKey.TOTAL_PRICE,
            ACEReducerForPlusAPIParamKey.USER_ID,
            ACEReducerForPlusAPIParamKey.USER_VALUE})
    public @interface ACEReducerForPlusAPIParamKey {
        String ACP_PUSH = "acp_push";
        String AGE = "age";
        String AS = "as";
        String BANNER_CODE = "bannerCode";
        String CLICK_NAME = "clickName";
        String CONTEXT = "context";
        String ERROR_CODE = "errCode";
        String GENDER = "gender";
        String GROUP_1 = "group_1";
        String GROUP_2 = "group_2";
        String GROUP_3 = "group_3";
        String GROUP_4 = "group_4";
        String GROUP_5 = "group_5";
        String GSCK = "gsck";
        String JSON_OBJECT = "jsonObject";
        String KEYWORD = "keyword";
        String MS = "ms";
        String ORDER_NUMBER = "orderNumber";
        String PAGE_NAME = "pageName";
        String PARAMETERS = "parameters";
        String PAYMENT_METHOD = "paymentMethod";
        String PHONE_NUMBER = "phoneNumber";
        String PRMT = "prmt";
        String PRODUCT = "product";
        String PRODUCT_CATEGORY = "productCategory";
        String PRODUCT_ImageURL = "productImageURL";
        String PRODUCT_NAME = "productName";
        String PRODUCT_NUMBER = "productNumber";
        String PRODUCT_PRICE = "productPrice";
        String PRODUCT_QUERY = "productQuery";
        String PROMOTION_CODE = "promotionCode";
        String REASON = "reason";
        String REVIEW_CONTENTS = "reviewContents";
        String SCORE = "score";
        String SNS_NAME = "snsName";
        String TK = "tk";
        String TOTAL_PRICE = "totalPrice";
        String USER_ID = "userID";
        String USER_VALUE = "userValue";
    }

    /**
     * 내부 저장소에 저장시 사용하는 key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            IN_STORAGE_KEY.ADID,
            IN_STORAGE_KEY.AET,
            IN_STORAGE_KEY.AGE,
            IN_STORAGE_KEY.AVC,
            IN_STORAGE_KEY.CID,
            IN_STORAGE_KEY.COOKIE,
            IN_STORAGE_KEY.DID,
            IN_STORAGE_KEY.DSC,
            IN_STORAGE_KEY.FIRST_EXEC,
            IN_STORAGE_KEY.GD,
            IN_STORAGE_KEY.MT,
            IN_STORAGE_KEY.OVT,
            IN_STORAGE_KEY.UD1,
            IN_STORAGE_KEY.UD2,
            IN_STORAGE_KEY.UD3,
            IN_STORAGE_KEY.UD4,
            IN_STORAGE_KEY.UD5,
            IN_STORAGE_KEY.UID})
    public @interface IN_STORAGE_KEY {
        String ADID = "_AceTM.ADID";
        String AET = "_AceTM.Aet";
        String AGE = "_AceTM.Age";
        String AVC = "_AceTM.Avc";

        String CID = "_AceTM.Cid";
        String COOKIE = "_AceTM.Cookie";

        String DID = "_AceTM.DID";
        String DSC = "_AceTM.DSC";

        String FIRST_EXEC = "_AceTM.FirstExec";

        String GD = "_AceTM.Gd";

        String MT = "_AceTM.Mt";

        String OVT = "_AceTM.Ovt";

        String UD1 = "_AceTM.Ud1";
        String UD2 = "_AceTM.Ud2";
        String UD3 = "_AceTM.Ud3";
        String UD4 = "_AceTM.Ud4";
        String UD5 = "_AceTM.Ud5";
        String UID = "_AceTM.Uid";
    }

    /**
     * 회원가입/회원탈퇴/로그인 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            MEMBERSHIP.DEFAULT,
            MEMBERSHIP.LOGIN,
            MEMBERSHIP.REGISTER,
            MEMBERSHIP.LEAVE,
            MEMBERSHIP.LOGGED_IN})
    public @interface MEMBERSHIP {
        int DEFAULT = 0;
        int LOGIN = 1;
        int REGISTER = 2;
        int LEAVE = 3;
        int LOGGED_IN = 4;
    }

    /**
     * API 별 ACM 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            ParamsPlusEnum_ACM.NONE,
            ParamsPlusEnum_ACM.SITE,
            ParamsPlusEnum_ACM.EVENT,
            ParamsPlusEnum_ACM.PRODUCT,
            ParamsPlusEnum_ACM.APP})
    public @interface ParamsPlusEnum_ACM {
        String NONE = "NONE";
        String SITE = "SITE";
        String EVENT = "EVENT";
        String PRODUCT = "PRODUCT";
        String APP = "APP";
    }

    /**
     * API 별 AEM 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            ParamsPlusEnum_AEM.NONE,
            ParamsPlusEnum_AEM.PV,
            ParamsPlusEnum_AEM.PU,
            ParamsPlusEnum_AEM.HREF,
            ParamsPlusEnum_AEM.SNS,
            ParamsPlusEnum_AEM.CLICK,
            ParamsPlusEnum_AEM.BC,
            ParamsPlusEnum_AEM.BV,
            ParamsPlusEnum_AEM.PGERR,
            ParamsPlusEnum_AEM.JSERR,
            ParamsPlusEnum_AEM.TEL,
            ParamsPlusEnum_AEM.ACQ,
            ParamsPlusEnum_AEM.NOW,
            ParamsPlusEnum_AEM.WISH,
            ParamsPlusEnum_AEM.CART,
            ParamsPlusEnum_AEM.BUY,
            ParamsPlusEnum_AEM.PAY,
            ParamsPlusEnum_AEM.REVIEW,
            ParamsPlusEnum_AEM.SDKERR,
            ParamsPlusEnum_AEM.LIST})
    public @interface ParamsPlusEnum_AEM {
        String NONE = "NONE";
        String PV = "PV";
        String PU = "PU";
        String HREF = "HREF";
        String SNS = "SNS";
        String CLICK = "CLICK";
        String BC = "BC";
        String BV = "BV";
        String PGERR = "PGERR";
        String JSERR = "JSERR";
        String TEL = "TEL";
        String ACQ = "ACQ";
        String NOW = "NOW";
        String WISH = "WISH";
        String CART = "CART";
        String BUY = "BUY";
        String PAY = "PAY";
        String REVIEW = "REVIEW";
        String SDKERR = "SDKERR";
        String LIST = "LIST";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            ParamsPlusEnum_Key.ACI,
            ParamsPlusEnum_Key.ACM,
            ParamsPlusEnum_Key.ACP_PUSH,
            ParamsPlusEnum_Key.AEM,
            // long
            ParamsPlusEnum_Key.AET,
            // int
            ParamsPlusEnum_Key.AGE,
            ParamsPlusEnum_Key.AS,
            // int
            ParamsPlusEnum_Key.AVC,
            // int
            ParamsPlusEnum_Key.AVN,
            // long
            ParamsPlusEnum_Key.AVT,
            ParamsPlusEnum_Key.BV,
            ParamsPlusEnum_Key.BZ,
            ParamsPlusEnum_Key.CID,
            // int
            ParamsPlusEnum_Key.CK,
            ParamsPlusEnum_Key.CPY,
            ParamsPlusEnum_Key.CT,
            ParamsPlusEnum_Key.DAV,
            ParamsPlusEnum_Key.DID,
            ParamsPlusEnum_Key.DIM,
            ParamsPlusEnum_Key.DMN,
            ParamsPlusEnum_Key.DSC,
            ParamsPlusEnum_Key.DTC,

            ParamsPlusEnum_Key.EREF,
            ParamsPlusEnum_Key.GD,
            ParamsPlusEnum_Key.GSCK,
            ParamsPlusEnum_Key.INKW,
            // int
            ParamsPlusEnum_Key.LOGSOURCE,
            ParamsPlusEnum_Key.MID,
            ParamsPlusEnum_Key.MS,
            // int
            ParamsPlusEnum_Key.MT,
            // int
            ParamsPlusEnum_Key.MV,
            ParamsPlusEnum_Key.OPA,
            ParamsPlusEnum_Key.ORN,
            ParamsPlusEnum_Key.ORP,
            ParamsPlusEnum_Key.OS,
            // long
            ParamsPlusEnum_Key.OVT,
            // String
            ParamsPlusEnum_Key.Patch,
            // int
            ParamsPlusEnum_Key.PCM,
            ParamsPlusEnum_Key.PD,
            ParamsPlusEnum_Key.PIU,
            ParamsPlusEnum_Key.PNO,
            ParamsPlusEnum_Key.PR,
            ParamsPlusEnum_Key.PRMT,
            ParamsPlusEnum_Key.PRN,
            ParamsPlusEnum_Key.PRT,
            ParamsPlusEnum_Key.PVG,
            ParamsPlusEnum_Key.PVN,
            ParamsPlusEnum_Key.PYN,
            ParamsPlusEnum_Key.RDM,
            // int
            ParamsPlusEnum_Key.REL,
            // int
            ParamsPlusEnum_Key.RND,
            // int
            ParamsPlusEnum_Key.SM,
            ParamsPlusEnum_Key.SV,

            ParamsPlusEnum_Key.TK,
            // int
            ParamsPlusEnum_Key.UD1,
            // int
            ParamsPlusEnum_Key.UD2,
            // int
            ParamsPlusEnum_Key.UD3,
            // int
            ParamsPlusEnum_Key.UD4,
            // int
            ParamsPlusEnum_Key.UD5,
            ParamsPlusEnum_Key.UID,
            ParamsPlusEnum_Key.UL,
            ParamsPlusEnum_Key.URL})
    public @interface ParamsPlusEnum_Key {
        String ACI = "aci";
        String ACM = "acm";
        String ACP_PUSH = "acp_push";
        String AEM = "aem";
        String AET = "aet";
        String AGE = "age";
        String AS = "as";
        String AVC = "avc";
        String AVN = "avn";
        String AVT = "avt";

        String BV = "bv";
        String BZ = "bz";

        String CID = "cid";
        String CK = "ck";
        String CPY = "cpy";
        String CT = "ct";

        String DAV = "dav";
        String DID = "did";
        String DIM = "dim";
        String DMN = "dmn";
        String DSC = "dsc";
        String DTC = "dtc";

        String EREF = "eref";
        String ERN = "ern";

        String GD = "gd";
        String GSCK = "gsck";

        String INKW = "inkw";

        String LOGSOURCE = "logsource";

        String MID = "mid";
        String MS = "ms";
        String MT = "mt";
        String MV = "mv";

        String OPA = "opa";
        String ORN = "orn";
        String ORP = "orp";
        String OVT = "ovt";
        String OS = "os";

        String Patch = "patch";
        String PCM = "pcm";
        String PD = "pd";
        String PIU = "piu";
        String PNO = "pno";
        String PR = "pr";
        String PRMT = "prmt";
        String PRN = "prn";
        String PRT = "prt";
        String PVG = "pvg";
        String PVN = "pvn";
        String PYN = "pyn";

        String RDM = "rdm";
        String REL = "rel";
        String RND = "rnd";

        String SM = "sm";
        String SV = "sv";

        String TK = "tk";

        String UD1 = "ud1";
        String UD2 = "ud2";
        String UD3 = "ud3";
        String UD4 = "ud4";
        String UD5 = "ud5";
        String UID = "uid";
        String UL = "ul";
        String URL = "url";
    }

    /**
     * 로그의 출처 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            SOURCE.PC,
            SOURCE.MOBILE,
            SOURCE.ANDROID,
            SOURCE.IOS})
    public @interface SOURCE {
        int PC = 0;
        int MOBILE = 1;
        int ANDROID = 2;
        int IOS = 3;
    }
    //endregion Parameter

    //endregion enum
}
