package com.acecounter.android.acetm.acone.queue;

import androidx.annotation.NonNull;

import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.queue.ACEQueueManager;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;
import com.acecounter.android.acetm.common.queue.ACESendQueueManager;
import com.acecounter.android.acetm.common.queue.ACEWaitQueueManager;

public final class ACEQueueManagerFactoryForOne extends ACEQueueManagerFactory {
    @NonNull
    public ACEQueueManager getQueueManager() {
        if (ACEControlTower.isSDKEnabled()) {
            return ACESendQueueManager.getInstance();
        }
        else {
            return ACEWaitQueueManager.getInstance();
        }
    }
}
