package com.acecounter.android.acetm.acone.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameterUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;
import static com.acecounter.android.acetm.common.util.ThreadUtil.runOnUiThread;

final public class APIForPolicy extends Task {
    private final String TAG = APIForPolicy.class.getSimpleName();

    private Context _context;
    @Nullable
    private ConcurrentHashMap<String, Object> _parameters;

    APIForPolicy(final int identifier,
                 final @Nullable Map<String, Object> parameters,
                 @Nullable ICallbackOfACE doneWorkCallback) {
        super(identifier, doneWorkCallback);
        _context = null;
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForOneAPIParamKey.CONTEXT);
            }
        }

        if (callbackForTask != null) {
            callbackForTask.callback();
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEPolicyParameterUtil.getInstance().getURL();
            }
        });
        networkAdapter.setGetRequestHeaderMap(new ACENetwork.OnGetRequestHeaderMap() {
            @NonNull
            @Override
            public ConcurrentHashMap<String, String> getRequestHeaderMap() {
                ConcurrentHashMap<String, String> _map = new ConcurrentHashMap<>();
                if (_context != null) {
                    _map.put(ACEStaticConfig.POLICY.REQUEST_APPLICATION_ID, _context.getPackageName());
                }
                _map.put(ACEStaticConfig.POLICY.REQUEST_CID, ACECommonStaticConfig.getKey());
                _map.put(ACEStaticConfig.POLICY.REQUEST_PLATFORM, ACEStaticConfig.ACECONSTANT.ANDROID);
                _map.put(ACEStaticConfig.POLICY.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
                _map.put(ACEStaticConfig.POLICY.REQUEST_TIME, Long.toString(System.currentTimeMillis()));
                _map.put(ACEStaticConfig.POLICY.REQUEST_VERSION, ACEParameterUtil.getSdkVersion());
                return _map;
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@NonNull final ACENetworkResult response) {
                APIForPolicy.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForPolicy.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (response == null) {
                    ACELog.d(TAG,
                            String.format(
                                    Locale.getDefault(),
                                    "%d, response is null.", APIForPolicy.this.getTaskHash()));
                    ACEControlTower.failedRequestPolicy();
                    return;
                }
                ACEPolicyParameterUtil.getInstance().savePolicy(response);
                ACEControlTower.succeedRequestPolicy();
            }
        });
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ACELog.d(TAG,
                        String.format(
                                Locale.getDefault(),
                                "%d, failed request policy.", APIForPolicy.this.getTaskHash()));
                ACEControlTower.failedRequestPolicy();
            }
        });

        try {
            JSONObject _json = new JSONObject();

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACEStaticConfig.ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACEStaticConfig.ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public JSONObject getJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();
        _json.put(ACEStaticConfig.ACELOG_JSON_KEY.LOGTYPE, ACEStaticConfig.ACELOG_TYPE.POLICY);
        _json.put(ACEStaticConfig.ACELOG_JSON_KEY.CREATETIME, getCreateTime().getTime());

        JSONObject _params = new JSONObject();
        _params.put(ACEStaticConfig.ACELOG_JSON_KEY.URL, ACEPolicyParameterUtil.getInstance().getURL());
        _params.put(ACEStaticConfig.ACELOG_JSON_KEY.METHOD, ACEStaticConfig.HTTP_METHOD.GET);
        _params.put(ACEStaticConfig.POLICY.REQUEST_SERVICE_ID, ACECommonStaticConfig.getKey());
        if (_context != null) {
            _params.put(ACEStaticConfig.POLICY.REQUEST_APPLICATION_ID, _context.getPackageName());
        }

        _json.put(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS, _params);

        return _json;
    }
}
