package com.acecounter.android.acetm.acone.parameter;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.TP;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACELOG_JSON_KEY;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.parameter.Task;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

public class APIForPL extends Task {
    final private String TAG = APIForPL.class.getSimpleName();

    @Nullable
    protected Context _context;
    @Nullable
    protected ConcurrentHashMap<String, Object> _parameters;

    @Nullable
    protected ACEntityForST _willUpdateSt;
    @Nullable
    protected ACEntityForVT _willUpdateVt;

    APIForPL(final int logSource,
             @Nullable Map<String, Object> parameters,
             @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, doneWorkCallback);
        if (parameters != null) {
            _parameters = new ConcurrentHashMap<>();
            _parameters.putAll(parameters);
        }
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);
        String _pageName = null;

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.CONTEXT)) {
                _context = (Context)_parameters.get(ACEReducerForOneAPIParamKey.CONTEXT);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.PAGE_NAME)) {
                _pageName = (String)_parameters.get(ACEReducerForOneAPIParamKey.PAGE_NAME);
            }
        }

        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();

        _parameterUtilForOne.setTP(TP.SITE);
        _parameterUtilForOne.updateUrlToRef(_pageName);

        _parameterUtilForOne.loadVT();
        _parameterUtilForOne.updateSTnVT(assignWillUpdateVt());

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForOne.toString()));
        if (callbackForTask != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            callbackForTask.callback();
        }
        else if (callbackForTask != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void didWork() {
        super.didWork();

        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForOne.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForPL.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForPL.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);

        ACELog.d(TAG, "in completed()");
        if (response != null) {
            ACELog.d(TAG, response.toString());
        }

        doneWork();
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));

        if (this._doneWorkCallback != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);

        ACELog.d(TAG, "in failed()");
        try {
            JSONObject _json = getJSONobject();

            doneWork();

            int count = ACEStaticConfig.ACECONSTANT_INTEGER.INIT_FAILED_LOG_COUNT;
            if (_json.has(ACELOG_JSON_KEY.FAILED_COUNT)) {
                count = _json.getInt(ACELOG_JSON_KEY.FAILED_COUNT) + 1;
            }
            _json.put(ACELOG_JSON_KEY.FAILED_COUNT, count);

            if (throwable != null) {
                JSONObject _jsonThrowable = new JSONObject();
                _jsonThrowable.put(ACELOG_JSON_KEY.STACKTRACE, throwable.getMessage());
                _jsonThrowable.put(ACELOG_JSON_KEY.CAUSE, throwable.getCause());
                _json.put(ACELOG_JSON_KEY.THROWABLE, _jsonThrowable);
            }

            ACEDebugLog.v(TAG, _json.toString());
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, failed: %s", this.getTaskHash(), _json.toString(2)));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (this._doneWorkCallback != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void doneWork() {
        ACELog.d(TAG, "in doneWork()");

        // 공통 [S]
        Map<String, Object> params = new HashMap<>();
        if (this._willUpdateSt != null) {
            params.put(ACEOneStaticConfig.ACOneConstantSt.KeyWillUpdateSt, assignWillUpdateSt());
        }
        if (this._willUpdateVt != null) {
            params.put(ACEOneStaticConfig.ACOneConstantVt.KeyWillUpdateVt, assignWillUpdateVt());
        }
        ACEParameterUtilForOne.getInstance().resetSessionAndParameterAfterSendWithParams(params);
        // 공통 [E]
    }

    //region assignWillUpdate Entities
    protected ACEntityForST assignWillUpdateSt() {
        if (this._willUpdateSt == null) {
            ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
            this._willUpdateSt = new ACEntityForST(_parametersForOne.getST());
        }

        return this._willUpdateSt;
    }

    protected ACEntityForVT assignWillUpdateVt() {
        if (this._willUpdateVt == null) {
            ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
            this._willUpdateVt = new ACEntityForVT(_parametersForOne.getVT());
        }

        return this._willUpdateVt;
    }
    //endregion assignWillUpdate Entities
}
