package com.acecounter.android.acetm.acone.parameter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ICallbackOfACE;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACEReducerForOneAPIParamKey;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.http.ACENetwork;
import com.acecounter.android.acetm.common.http.ACENetworkAdapter;
import com.acecounter.android.acetm.common.http.ACENetworkResult;
import com.acecounter.android.acetm.common.http.IACENetworkParams;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.config.ACEPublicStaticConfig.ACEConstantCallbackKey_Failed_Cause;

final public class APIForLogin extends APIForPL {
    final private String TAG = APIForLogin.class.getSimpleName();

    @Nullable
    protected String _userId;
    @Nullable
    protected Integer _age;
    @Nullable
    protected ACEPublicStaticConfig.ACEGender _gender;
    @Nullable
    protected ACEPublicStaticConfig.ACEMaritalStatus _maritalStatus;

    APIForLogin(int logSource,
                @Nullable Map<String, Object> parameters,
                @Nullable ICallbackOfACE doneWorkCallback) {
        super(logSource, parameters, doneWorkCallback);
        _age = 0;
    }

    @Override
    public void doWork(@Nullable final ICallbackOfTask callbackForTask) {
        super.doWork(callbackForTask);

        if (_parameters != null) {
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.USER_ID)) {
                _userId = (String)_parameters.get(ACEReducerForOneAPIParamKey.USER_ID);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.AGE)) {
                _age = (Integer)_parameters.get(ACEReducerForOneAPIParamKey.AGE);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.GENDER)) {
                _gender = (ACEPublicStaticConfig.ACEGender)_parameters.get(ACEReducerForOneAPIParamKey.GENDER);
            }
            if (_parameters.containsKey(ACEReducerForOneAPIParamKey.MARITAL_STATUS)) {
                _maritalStatus = (ACEPublicStaticConfig.ACEMaritalStatus)_parameters.get(ACEReducerForOneAPIParamKey.MARITAL_STATUS);
            }
        }

        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();

        _parameterUtilForOne.setJn(_logSource);
        switch (_logSource) {
            case ACEOneStaticConfig.ACEofAPIForOne.Login: {
                _parameterUtilForOne.setAge(_age);
                _parameterUtilForOne.setGender(_gender);
                _parameterUtilForOne.setID(_userId);
                _parameterUtilForOne.setMaritalStatus(_maritalStatus);
                break;
            }
            default:
                break;
        }

        // doWork 결과
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, doWork result _params: %s", this.getTaskHash(), _parameterUtilForOne.toString()));
        if (callbackForTask != null &&
                this.getClass().getSimpleName().equalsIgnoreCase(TAG)) {
            callbackForTask.callback();
        }
        else if (callbackForTask != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, class name: %s", this.getTaskHash(), this.getClass().getSimpleName()));
        }
    }

    @Override
    public void didWork() {
        ACENetworkAdapter networkAdapter = new ACENetworkAdapter();
        networkAdapter.setGetURL(new ACENetwork.OnGetURL() {
            @NonNull
            @Override
            public String getURL() {
                return ACEParameterUtilForOne.getInstance().getParametersToURL(ACEStaticConfig.HTTP_METHOD.GET);
            }
        });
        networkAdapter.request(new IACENetworkParams() {
            @Override
            public void completed(@Nullable final ACENetworkResult response) {
                APIForLogin.this.completed(response);
            }

            @Override
            public void failed(@Nullable final Throwable throwable) {
                APIForLogin.this.failed(throwable);
            }
        });
    }

    @Override
    public void completed(@Nullable final ACENetworkResult response) {
        super.completed(response);
        ACELog.d(TAG,
                String.format(
                        Locale.getDefault(),
                        "%d, completed done", this.getTaskHash()));
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (response != null) {
                    result.put("response", response.getsVariablesToJSONobject());
                }
                this._doneWorkCallback.completed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void failed(@Nullable final Throwable throwable) {
        super.failed(throwable);
        if (this._doneWorkCallback != null) {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, Start doneWorkCallback: %s", this.getTaskHash(), this.getClass().getSimpleName()));

            try {
                JSONObject result = new JSONObject();
                result.put(ACEStaticConfig.ACELOG_JSON_KEY.TaskHash, String.valueOf(getTaskHash()));
                if (throwable != null) {
                    result.put(ACEConstantCallbackKey_Failed_Cause, throwable.getCause().toString());
                }
                this._doneWorkCallback.failed(result);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        else {
            ACELog.d(TAG,
                    String.format(
                            Locale.getDefault(),
                            "%d, _doneWorkCallback is null", this.getTaskHash()));
        }
    }

    @Override
    public void doneWork() {
        super.doneWork();

        ACELog.d(TAG, "in doneWork()");
        ACEParameterUtilForOne _parameterUtilForOne = ACEParameterUtilForOne.getInstance();
        // Login [S]
        _parameterUtilForOne.clearAge();
        _parameterUtilForOne.clearGender();
        _parameterUtilForOne.clearID();
        _parameterUtilForOne.clearMaritalStatus();
        // Login [E]
    }
}
