package com.acecounter.android.acetm.acone.parameter;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantSt;
import com.acecounter.android.acetm.common.logger.ACELog;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class ACEntityForST {
    private final String TAG = ACEntityForST.class.getSimpleName();

    private Map<String, Object> _dic;

    ACEntityForST() {
        _dic = new TreeMap<>();
        _dic.put(ACOneConstantSt.KeyGetTS, ACOneConstantSt.DefaultTS);
        _dic.put(ACOneConstantSt.KeyRandom6ForGetTS, "");

        _dic.put(ACOneConstantSt.KeyInsenginetTS, ACOneConstantSt.DefaultTS);
        _dic.put(ACOneConstantSt.KeyRandom6ForInsenginetTS, "");

        _dic.put(ACOneConstantSt.KeyRTS, ACOneConstantSt.DefaultTS);
        _dic.put(ACOneConstantSt.KeyRandom6ForRTS, "");

        _dic.put(ACOneConstantSt.KeyStartTS, ACOneConstantSt.DefaultTS);
        _dic.put(ACOneConstantSt.KeyRandom6ForStartTS, "");
    }

    ACEntityForST(@Nullable ACEntityForST value) {
        _dic = new TreeMap<>();
        if (value != null) {
            _dic.putAll(value.getMap());
        }
    }

    ACEntityForST(@Nullable Map<String, Object> value) {
        _dic = new TreeMap<>();
        if (value != null) {
            _dic.putAll(value);
        }
    }

    //region query 관련
    @NonNull
    public String getAssembleParams() {
        @NonNull String _getTS = getGetTSGoldMaster();
        @NonNull String _insenginetTS = getInsenginetTSGoldMaster();
        @NonNull String _rTS = getRTSGoldMaster();
        @NonNull String _startTS = getStartTSGoldMaster();

        return String.format(Locale.getDefault(), "%s|%s|%s|%s", _startTS, _getTS, _rTS, _insenginetTS);
    }

    @NonNull
    public String getGetTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _getTS = getGetTS();
        if (TextUtils.isEmpty(_getTS)) {
            _string.append(ACOneConstantSt.DefaultTS);
        }
        else {
            _string.append(_getTS);
        }

        String _random = getRandom6ForGetTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }

    @NonNull
    public String getInsenginetTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _insenginetTS = getInsenginetTS();
        if (TextUtils.isEmpty(_insenginetTS)) {
            _string.append(ACOneConstantSt.DefaultTS);
        }
        else {
            _string.append(_insenginetTS);
        }

        String _random = getRandom6ForInsenginetTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }

    @NonNull
    public String getRTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _rTS = getRTS();
        if (TextUtils.isEmpty(_rTS)) {
            _string.append(ACOneConstantSt.DefaultTS);
        }
        else {
            _string.append(_rTS);
        }

        String _random = getRandom6ForRTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }

    @NonNull
    public String getStartTSGoldMaster() {
        StringBuilder _string = new StringBuilder();

        @Nullable
        String _startTS = getStartTS();
        if (TextUtils.isEmpty(_startTS)) {
            _string.append(ACOneConstantSt.DefaultTS);
        }
        else {
            _string.append(_startTS);
        }

        String _random = getRandom6ForStartTS();
        if (!TextUtils.isEmpty(_random)) {
            _string.append(_random);
        }

        return _string.toString();
    }
    //endregion query 관련

    //region setter/getter

    //region GetTS
    @Nullable
    public String getGetTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyGetTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyGetTS);
        }
        else {
            return null;
        }
    }

    public void setGetTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyGetTS, value);
        }
    }

    @Nullable
    public Date getGetTSWithDate() {
        String _string = getGetTS();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setGetTSWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setGetTS(_string);
        }
    }
    //endregion GetTS

    //region GetTS random
    @Nullable
    public String getRandom6ForGetTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForGetTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyRandom6ForGetTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForGetTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyRandom6ForGetTS, value);
        }
    }
    //endregion GetTS random

    //region InsenginetTS
    @Nullable
    public String getInsenginetTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyInsenginetTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyInsenginetTS);
        }
        else {
            return null;
        }
    }

    public void setInsenginetTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyInsenginetTS, value);
        }
    }

    @Nullable
    public Date getInsenginetTSWithDate() {
        String _string = getInsenginetTS();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setInsenginetTSWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setInsenginetTS(_string);
        }
    }
    //endregion InsenginetTS

    //region InsenginetTS random
    @Nullable
    public String getRandom6ForInsenginetTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForInsenginetTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyRandom6ForInsenginetTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForInsenginetTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyRandom6ForInsenginetTS, value);
        }
    }
    //endregion InsenginetTS random

    //region RTS
    @Nullable
    public String getRTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyRTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyRTS);
        }
        else {
            return null;
        }
    }

    public void setRTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyRTS, value);
        }
    }
    //endregion RTS

    //region RTS random
    @Nullable
    public String getRandom6ForRTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForRTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyRandom6ForRTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForRTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyRandom6ForRTS, value);
        }
    }
    //endregion RTS random

    //region StartTS
    @Nullable
    public String getStartTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyStartTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyStartTS);
        }
        else {
            return null;
        }
    }

    public void setStartTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyStartTS, value);
        }
    }

    @Nullable
    public Date getStartTSWithDate() {
        String _string = getStartTS();
        if (!TextUtils.isEmpty(_string)) {
            try {
                return new Date(Long.parseLong(_string));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        else {
            return null;
        }
    }

    public void setStartTSWithDate(@Nullable Date value) {
        if (value != null) {
            String _string = String.valueOf(value.getTime());
            setStartTS(_string);
        }
    }
    //endregion StartTS

    //region StartTS random
    @Nullable
    public String getRandom6ForStartTS() {
        if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForStartTS)) {
            return (String)_dic.get(ACOneConstantSt.KeyRandom6ForStartTS);
        }
        else {
            return null;
        }
    }

    public void setRandom6ForStartTS(@Nullable String value) {
        if (!TextUtils.isEmpty(value)) {
            _dic.put(ACOneConstantSt.KeyRandom6ForStartTS, value);
        }
    }
    //endregion StartTS random

    public void setST(@Nullable ACEntityForST value) {
        if (value != null) {
            _dic.clear();

            setGetTS(value.getGetTS());
            setRandom6ForGetTS(value.getRandom6ForGetTS());

            setInsenginetTS(value.getInsenginetTS());
            setRandom6ForInsenginetTS(value.getRandom6ForInsenginetTS());

            setRTS(value.getRTS());
            setRandom6ForRTS(value.getRandom6ForRTS());

            setStartTS(value.getStartTS());
            setRandom6ForStartTS(value.getRandom6ForStartTS());
        }
    }

    public void setSTByMap(@Nullable Map<String, Object> value) {
        try {
            if (value != null) {
                _dic.clear();
                _dic.putAll(value);
            }
        } catch (UnsupportedOperationException ex) {
            ex.printStackTrace();
        }
    }
    //endregion setter/getter

    //region utils
    public Map<String, Object> getMap() {
        return _dic;
    }

    @NonNull
    public JSONObject getJSONObjectSimpleStyle() throws JSONException {
        @NonNull String _getTS = getGetTSGoldMaster();
        @NonNull String _insenginetTS = getInsenginetTSGoldMaster();
        @NonNull String _rTS = getRTSGoldMaster();
        @NonNull String _startTS = getStartTSGoldMaster();

        JSONObject _json = new JSONObject();
        _json.put("getts", _getTS);
        _json.put("insenginets", _insenginetTS);
        _json.put("referts", _rTS);
        _json.put("startts", _startTS);

        return _json;
    }

    @NonNull
    public JSONObject getJSONObject() {
        JSONObject _json = new JSONObject();
        try {
            if (_dic.containsKey(ACOneConstantSt.KeyGetTS)) {
                _json.put(ACOneConstantSt.KeyGetTS, _dic.get(ACOneConstantSt.KeyGetTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyGetTS, ACOneConstantSt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForGetTS)) {
                _json.put(ACOneConstantSt.KeyRandom6ForGetTS, _dic.get(ACOneConstantSt.KeyRandom6ForGetTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyRandom6ForGetTS, "");
            }

            if (_dic.containsKey(ACOneConstantSt.KeyInsenginetTS)) {
                _json.put(ACOneConstantSt.KeyInsenginetTS, _dic.get(ACOneConstantSt.KeyInsenginetTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyInsenginetTS, ACOneConstantSt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForInsenginetTS)) {
                _json.put(ACOneConstantSt.KeyRandom6ForInsenginetTS, _dic.get(ACOneConstantSt.KeyRandom6ForInsenginetTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyRandom6ForInsenginetTS, "");
            }

            if (_dic.containsKey(ACOneConstantSt.KeyRTS)) {
                _json.put(ACOneConstantSt.KeyRTS, _dic.get(ACOneConstantSt.KeyRTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyRTS, ACOneConstantSt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForRTS)) {
                _json.put(ACOneConstantSt.KeyRandom6ForRTS, _dic.get(ACOneConstantSt.KeyRandom6ForRTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyRandom6ForRTS, "");
            }

            if (_dic.containsKey(ACOneConstantSt.KeyStartTS)) {
                _json.put(ACOneConstantSt.KeyStartTS, _dic.get(ACOneConstantSt.KeyStartTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyStartTS, ACOneConstantSt.DefaultTS);
            }

            if (_dic.containsKey(ACOneConstantSt.KeyRandom6ForStartTS)) {
                _json.put(ACOneConstantSt.KeyRandom6ForStartTS, _dic.get(ACOneConstantSt.KeyRandom6ForStartTS));
            }
            else {
                _json.put(ACOneConstantSt.KeyRandom6ForStartTS, "");
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return _json;
    }
    //endregion utils
}
