package com.acecounter.android.acetm.acone.parameter;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantSt;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantVt;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ParamsOneEnum_Key;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameters;
import com.acecounter.android.acetm.common.util.JsonUtil;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

import static com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantInteger.TimezoneArrayIndexAtAceServer;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.SESSION.KEEP;
import static com.acecounter.android.acetm.common.config.ACEStaticConfig.SESSION.NEW;

public final class ACEParametersForOne extends ACEParameters {
    private final String TAG = ACEParametersForOne.class.getSimpleName();

    private String adeld;
    private String adid;
    private Integer ag;
    private String push;
    private String amt;

    private String ce;
    private String ct;

    private String dm;

    private String gd;

    private String _id;

    private String jn;

    private String kw;

    private String lg;
    private String ll;

    private String md;
    private String mid;
    private String mr;

    private String onum;

    private String payMethod;
    private String pd;

    private Integer re;
    private String ref;
    private String ri;

    private String skey;
    private String src;
    private ACEntityForST st;
    private String sts;
    private String sv;

    private String tp;

    private Integer udf1;
    private Integer udf2;
    private Integer udf3;
    private String url;
    private String userId;

    private Integer vk;
    private ACEntityForVT vt;

    private ACEParametersForOne() { }

    //region 싱글턴
    private static class Singleton {
        private static final ACEParametersForOne INSTANCE = new ACEParametersForOne();
    }

    @NonNull
    public static ACEParametersForOne getInstance() {
        return ACEParametersForOne.Singleton.INSTANCE;
    }
    //endregion 싱글턴

    //region setter/getter

    //region ADELD
    @NonNull
    synchronized String getADELD() {
        if (TextUtils.isEmpty(this.adeld)) {
            this.adeld = "0";
        }
        return this.adeld;
    }

    synchronized void setADELD(boolean value) {
        this.adeld = value ? "1" : "0";
    }
    //endregion ADELD

    //region ADID
    @Nullable
    synchronized String getADID() {
        if (TextUtils.isEmpty(this.adid)) {
            this.adid = ACEStaticConfig.ACECONSTANT.DEFAULT_ADID;
        }
        return this.adid;
    }

    synchronized void setADID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.adid = ACEStaticConfig.ACECONSTANT.DEFAULT_ADID;
        }
        else {
            this.adid = value;
        }
    }
    //endregion ADID

    //region AG
    synchronized int getAG() {
        if (this.ag == null) {
            this.ag = 0;
        }
        return this.ag;
    }

    synchronized void setAG(int value) {
        if (value < 0) {
            value = 0;
        }

        this.ag = value;
    }
    //endregion AG

    //region AMT
    @NonNull
    public String getAMT() {
        if (TextUtils.isEmpty(this.amt)) {
            this.amt = "";
        }
        return this.amt;
    }

    void setAMT(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.amt = "";
        }
        else {
            this.amt = value;
        }
    }
    //endregion AMT

    //region CE
    @NonNull
    public String getCE() {
        if (TextUtils.isEmpty(this.ce)) {
            this.ce = ACEOneStaticConfig.ACOneConstant.DefaultCE;
        }
        return this.ce;
    }

    void setCE(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ce = ACEOneStaticConfig.ACOneConstant.DefaultCE;
        }
        else {
            this.ce = value;
        }
    }
    //endregion CE

    //region CT
    @NonNull
    public String getCT() {
        if (TextUtils.isEmpty(this.ct)) {
            this.ct = "";
        }
        return this.ct;
    }

    void setCT(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ct = "";
        }
        else {
            this.ct = value;
        }
    }
    //endregion CT

    //region DM
    @NonNull
    public String getDM() {
        if (TextUtils.isEmpty(this.dm)) {
            this.dm = "";
        }
        return this.dm;
    }

    void setDM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.dm = "";
        }
        else {
            this.dm = value;
        }
    }
    //endregion DM

    //region GD
    @NonNull
    public String getGD() {
        if (TextUtils.isEmpty(this.gd)) {
            this.gd = "";
        }
        return this.gd;
    }

    void setGD(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.gd = "";
        }
        else {
            this.gd = value;
        }
    }
    //endregion GD

    //region ID
    @NonNull
    public String getID() {
        if (TextUtils.isEmpty(this._id)) {
            this._id = "";
        }
        return this._id;
    }

    void setID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this._id = "";
        }
        else {
            this._id = value;
        }
    }
    //endregion ID

    @Nullable
    synchronized String getInstallReferrer() throws ClassCastException {
        String value = null;
        try {
            value = getSharedPreferencesInstance().getString(
                    ACEStaticConfig.IN_STORAGE.InstallReferrer,
                    null);
        }
        catch (NullPointerException e) {
            return null;
        }
        return value;
    }

    synchronized void setInstallReferrer(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            value = "";
        }

        getSharedPreferencesInstance().edit().putString(
                ACEStaticConfig.IN_STORAGE.InstallReferrer,
                value)
                .apply();
    }

    //region JN
    @NonNull
    public String getJN() {
        if (TextUtils.isEmpty(this.jn)) {
            this.jn = "";
        }
        return this.jn;
    }

    void setJN(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.jn = "";
        }
        else {
            this.jn = value;
        }
    }
    //endregion JN

    //region KW
    @NonNull
    public String getKW() {
        if (TextUtils.isEmpty(this.kw)) {
            this.kw = "";
        }
        return this.kw;
    }

    void setKW(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.kw = "";
        }
        else {
            this.kw = value;
        }
    }
    //endregion KW

    //region LG
    @NonNull
    public String getLG() {
        if (TextUtils.isEmpty(this.lg)) {
            this.lg = "";
        }
        return this.lg;
    }

    void setLG(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.lg = "";
        }
        else {
            this.lg = value;
        }
    }
    //endregion LG

    //region LL
    @NonNull
    public String getLL() {
        if (TextUtils.isEmpty(this.ll)) {
            this.ll = "";
        }
        return this.ll;
    }

    void setLL(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ll = "";
        }
        else {
            this.ll = value;
        }
    }
    //endregion LL

    //region MD
    @NonNull
    public @ACEOneStaticConfig.IACBuyMode String getMD() {
        if (TextUtils.isEmpty(this.md)) {
            this.md = ACEOneStaticConfig.IACBuyMode.Unknown;
        }
        return this.md;
    }

    void setBuyModeToMD(@ACEOneStaticConfig.IACBuyMode String value) {
        this.md = value;
    }
    //endregion MD

    //region MID
    @NonNull
    public String getMID() {
        if (TextUtils.isEmpty(this.mid)) {
            this.mid = "";
        }
        return this.mid;
    }

    void setMID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.mid = "";
        }
        else {
            this.mid = value;
        }
    }
    //endregion MID

    //region MR
    @NonNull
    public String getMR() {
        if (TextUtils.isEmpty(this.mr)) {
            this.mr = ACEPublicStaticConfig.ACEMaritalStatus.Unknown.getName();
        }
        return this.mr;
    }

    void setMR(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.mr = ACEPublicStaticConfig.ACEMaritalStatus.Unknown.getName();
        }
        else {
            this.mr = value;
        }
    }
    //endregion MR

    //region ONUM
    @NonNull
    public String getONUM() {
        if (TextUtils.isEmpty(this.onum)) {
            this.onum = "";
        }
        return this.onum;
    }

    void setONUM(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.onum = "";
        }
        else {
            this.onum = value;
        }
    }
    //endregion ONUM

    //region PayMethod
    @NonNull
    public String getPayMethod() {
        if (TextUtils.isEmpty(this.payMethod)) {
            this.payMethod = "";
        }
        return this.payMethod;
    }

    void setPayMethod(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.payMethod = "";
        }
        else {
            this.payMethod = value;
        }
    }
    //endregion PayMethod

    //region PD
    @NonNull
    public String getPD() {
        if (TextUtils.isEmpty(this.pd)) {
            this.pd = "";
        }
        return this.pd;
    }

    void setPD(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.pd = "";
        }
        else {
            this.pd = value;
        }
    }
    //endregion PD

    //region PUSH
    @NonNull
    public String getPUSH() {
        if (TextUtils.isEmpty(this.push)) {
            this.push = "";
        }
        return this.push;
    }

    void setPUSH(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.push = "";
        }
        else {
            this.push = value;
        }
    }
    //endregion PUSH

    //region RE
    synchronized int getRE() {
        if (this.re == null) {
            this.re = 0;
        }
        return this.re;
    }

    synchronized void setRE(int value) {
        if (value < 0) {
            value = 0;
        }

        this.re = value;
    }
    //endregion RE

    //region REF
    @NonNull
    public String getREF() {
        if (TextUtils.isEmpty(this.ref)) {
            this.ref = ACEStaticConfig.ACECONSTANT.BOOKMARK;
        }
        return this.ref;
    }

    void setREF(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ref = ACEStaticConfig.ACECONSTANT.BOOKMARK;
        }
        else {
            this.ref = value;
        }
    }
    //endregion REF

    //region RI
    @NonNull
    public String getRI() {
        if (TextUtils.isEmpty(this.ri)) {
            this.ri = ACEOneStaticConfig.ACOneConstant.DefaultRI;
        }
        return this.ri;
    }

    void setRI(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.ri = ACEOneStaticConfig.ACOneConstant.DefaultRI;
        }
        else {
            this.ri = value;
        }
    }
    //endregion RI

    //region SKEY
    @NonNull
    public String getSKEY() {
        if (TextUtils.isEmpty(this.skey)) {
            this.skey = "";
        }
        return this.skey;
    }

    void setSKEY(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.skey = "";
        }
        else {
            this.skey = value;
        }
    }
    //endregion SKEY

    //region SRC
    @NonNull
    public String getSRC() {
        if (TextUtils.isEmpty(this.src)) {
            this.src = "";
        }
        return this.src;
    }

    void setSRC(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.src = "";
        }
        else {
            this.src = value;
        }
    }
    //endregion SRC

    //region ST
    @NonNull
    public ACEntityForST getST() {
        if (this.st == null) {
            this.st = new ACEntityForST();
        }
        return this.st;
    }

    void setST(@Nullable ACEntityForST value) {
        if (this.st == null) {
            this.st = new ACEntityForST(value);
        }
        else {
            this.st.setST(value);
        }
    }

    public ACEntityForST loadST() {
        try {
            JSONObject _json = JsonUtil.getJSONObjectInStorage(getSharedPreferencesInstance(),
                    ACOneConstantSt.KeyInStorage,
                    "");

            if (_json.length() != 0) {
                @Nullable Map<String, Object> _dic = JsonUtil.jsonToMap(_json);
                if (_dic != null) {
                    setST(new ACEntityForST(_dic));
                }
            }
        } catch (JSONException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantSt.KeyInStorage)).toString());
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantSt.KeyInStorage)).toString());
        }

        return getST();
    }

    public void saveWithST(@NonNull JSONObject json) {
        try {
            ACELog.d(TAG, "saveWithST::json: " + json.toString(2));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        try {
            getSharedPreferencesInstance().edit().putString(
                    ACOneConstantSt.KeyInStorage,
                    json.toString())
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantSt.KeyInStorage)).toString());
        }
    }
    //endregion ST

    //region STS
    @NonNull
    synchronized String getSTS() {
        if (TextUtils.isEmpty(this.sts)) {
            this.sts = "0";
        }
        return this.sts;
    }

    synchronized void setSTS(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.sts = "0";
        }
        else {
            this.sts = value;
        }
    }
    //endregion STS

    //region SV
    @NonNull
    public String getSV() {
        if (TextUtils.isEmpty(this.sv)) {
            this.sv = "";
        }
        return this.sv;
    }

    void setSV(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.sv = "";
        }
        else {
            this.sv = value;
        }
    }
    //endregion SV

    //region TP
    @NonNull
    public String getTP() {
        if (TextUtils.isEmpty(this.tp)) {
            this.tp = "";
        }
        return this.tp;
    }

    void setTP(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.tp = "";
        }
        else {
            this.tp = value;
        }
    }
    //endregion TP

    //region TZ
    @NonNull
    public String getTZ() {
        TimeZone tz = TimeZone.getDefault();
        int _timezoneOffset = tz.getOffset(new Date().getTime()) / 3600000;
        int timeForACE = -_timezoneOffset + TimezoneArrayIndexAtAceServer;
        if (timeForACE > 24) {
            timeForACE -= 24;
        }
        return String.valueOf(timeForACE);
    }
    //endregion TZ

    //region UDF1
    synchronized int getUDF1() {
        if (this.udf1 == null) {
            this.udf1 = 0;
        }

        return this.udf1;
    }

    synchronized void setUDF1(int value) {
        if (value < 0) {
            value = 0;
        }

        this.udf1 = value;
    }
    //endregion UDF1

    //region UDF2
    synchronized int getUDF2() {
        if (this.udf2 == null) {
            this.udf2 = 0;
        }
        return this.udf2;
    }

    synchronized void setUDF2(int value) {
        if (value < 0) {
            value = 0;
        }

        this.udf2 = value;
    }
    //endregion UDF2

    //region UDF3
    synchronized int getUDF3() {
        if (this.udf3 == null) {
            this.udf3 = 0;
        }
        return this.udf3;
    }

    synchronized void setUDF3(int value) {
        if (value < 0) {
            value = 0;
        }

        this.udf3 = value;
    }
    //endregion UDF3

    //region URL
    @NonNull
    public String getURL() {
        if (TextUtils.isEmpty(this.url)) {
            this.url = ACEStaticConfig.ACECONSTANT.BOOKMARK;
        }
        return this.url;
    }

    void setURL(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.url = ACEStaticConfig.ACECONSTANT.BOOKMARK;
        }
        else {
            this.url = value;
        }
    }
    //endregion URL

    //region UserID
    @NonNull
    public String getUserID() {
        if (TextUtils.isEmpty(this.userId)) {
            this.userId = "";
        }
        return this.userId;
    }

    void setUserID(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            this.userId = "";
        }
        else {
            this.userId = value;
        }
    }
    //endregion UserID

    //region VK
    synchronized int getVK() {
        if (this.vk == null) {
            this.vk = NEW;
        }
        return this.vk;
    }

    synchronized void setVK(int value) {
        if (value > NEW) {
            value = NEW;
        }
        if (value < KEEP) {
            value = KEEP;
        }

        this.vk = value;
    }
    //endregion VK

    //region VT
    @NonNull
    public ACEntityForVT getVT() {
        if (this.vt == null) {
            this.vt = new ACEntityForVT();
        }
        return this.vt;
    }

    void setVT(@Nullable ACEntityForVT value) {
        if (this.vt == null) {
            this.vt = new ACEntityForVT(value);
        }
        else {
            if (value != null) {
                this.vt.setVT(value);
            }
        }
    }

    public void setPcStampWhenNotStored() {
        if (this.vt != null) {
            this.vt.setPcStampWhenNotStored();
        }
    }

    @SuppressWarnings("UnusedReturnValue")
    public ACEntityForVT loadVT() {
        try {
            JSONObject _json = JsonUtil.getJSONObjectInStorage(
                    getSharedPreferencesInstance(),
                    ACOneConstantVt.KeyInStorage,
                    "");
            @Nullable
            Map<String, Object> _dic = JsonUtil.jsonToMap(_json);
            if (_dic != null && _dic.size() > 0) {
                setVT(new ACEntityForVT(_dic));
                setPcStampWhenNotStored();
            }
        } catch (JSONException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantVt.KeyInStorage)).toString());
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantVt.KeyInStorage)).toString());
        }

        return getVT();
    }

    public void saveWithVT(@NonNull JSONObject json) {
        try {
            ACELog.d(TAG, "saveWithVT::json: " + json.toString(2));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        try {
            getSharedPreferencesInstance().edit().putString(
                    ACOneConstantVt.KeyInStorage,
                    json.toString())
                    .apply();
        }
        catch (NullPointerException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", ACOneConstantVt.KeyInStorage)).toString());
        }
    }
    //endregion VT

    //endregion setter/getter

    //region JSON, toString
    @Override
    protected JSONObject getParamsToJSONobject() throws JSONException {
        JSONObject _json = new JSONObject();

        _json.put(ParamsOneEnum_Key.ADELD, this.adeld);
        _json.put(ParamsOneEnum_Key.ADID, this.adid);
        _json.put(ParamsOneEnum_Key.AG, this.ag);
        _json.put(ParamsOneEnum_Key.AMT, this.amt);

        _json.put(ParamsOneEnum_Key.CE, this.ce);
        _json.put(ParamsOneEnum_Key.CT, this.ct);

        _json.put(ParamsOneEnum_Key.DM, this.dm);

        _json.put(ParamsOneEnum_Key.GD, this.gd);

        _json.put(ParamsOneEnum_Key.ID, this._id);

        _json.put(ParamsOneEnum_Key.JN, this.jn);

        _json.put(ParamsOneEnum_Key.KW, this.kw);

        _json.put(ParamsOneEnum_Key.LG, this.lg);
        _json.put(ParamsOneEnum_Key.LL, this.ll);
        _json.put(ParamsOneEnum_Key.LOGSOURCE, this.logsource);

        _json.put(ParamsOneEnum_Key.MD, this.md);
        _json.put(ParamsOneEnum_Key.MID, this.mid);
        _json.put(ParamsOneEnum_Key.MR, this.mr);

        _json.put(ParamsOneEnum_Key.ONUM, this.onum);

        _json.put(ParamsOneEnum_Key.Patch, this.patch);
        _json.put(ParamsOneEnum_Key.PAY, this.payMethod);
        _json.put(ParamsOneEnum_Key.PD, this.pd);
        _json.put(ParamsOneEnum_Key.PUSH, this.push);

        _json.put(ParamsOneEnum_Key.RE, this.re);
        _json.put(ParamsOneEnum_Key.REF, this.ref);
        _json.put(ParamsOneEnum_Key.RI, this.ri);

        _json.put(ParamsOneEnum_Key.SKEY, this.skey);
        _json.put(ParamsOneEnum_Key.SRC, this.src);
        _json.put(ParamsOneEnum_Key.ST, this.st.getAssembleParams());
        _json.put(ParamsOneEnum_Key.STS, this.sts);
        _json.put(ParamsOneEnum_Key.SV, this.sv);

        _json.put(ParamsOneEnum_Key.TP, this.tp);
        _json.put(ParamsOneEnum_Key.TZ, getTZ());

        _json.put(ParamsOneEnum_Key.UDF1, this.udf1);
        _json.put(ParamsOneEnum_Key.UDF2, this.udf2);
        _json.put(ParamsOneEnum_Key.UDF3, this.udf3);
        _json.put(ParamsOneEnum_Key.URL, this.url);
        _json.put(ParamsOneEnum_Key.UserID, this.userId);

        _json.put(ParamsOneEnum_Key.VK, this.vk);
        _json.put(ParamsOneEnum_Key.VT, this.vt.getAssembleParams());

        return _json;
    }
    //endregion JSON, toString
}
