package com.acecounter.android.acetm.acone.parameter;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstant;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ACOneConstantInteger;
import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig.ParamsOneEnum_Key;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ACECONSTANT;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.ICallbackDoneAndFail_Result_JSON_KEY;
import com.acecounter.android.acetm.common.config.ACEStaticConfig.SESSION;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackDoneAndFail;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameters;
import com.acecounter.android.acetm.common.util.StringUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public final class ACEParameterUtilForOne implements IACEParameterUtil {
    static final private String TAG = ACEParameterUtilForOne.class.getSimpleName();

    private Context _context;

    private ACEParameterUtilForOne() { }

    //region 싱글턴
    private static class Singleton {
        private static final ACEParameterUtilForOne INSTANCE = new ACEParameterUtilForOne();
    }

    @NonNull
    public static ACEParameterUtilForOne getInstance() {
        return ACEParameterUtilForOne.Singleton.INSTANCE;
    }
    //endregion 싱글턴

    /**
     * _params 들을 초기화하고 SDK 필수값을 채움
     */
    public synchronized void initParameters(@NonNull final Context context,
                                            @NonNull final ICallbackOfTask callback) {
        _context = context;
        ACEParametersForOne.getInstance().initParameters(_context);
        setFixedParameters(callback);
    }

    private synchronized void setFixedParameters(@NonNull final ICallbackOfTask callback) {
        final ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();

        _parametersForOne.getCE();
        _parametersForOne.setDM(ACEParameterUtil.getResolution(_context));

        _parametersForOne.setMID(ACECommonStaticConfig.getKey());
        _parametersForOne.setIsNeedSetNewSession(false);
        _parametersForOne.setPATCH(ACECONSTANT.PATCH);
        _parametersForOne.setRE(ACOneConstantInteger.DefaultRE);
        _parametersForOne.setREF(ACECONSTANT.BOOKMARK);
        _parametersForOne.setRI(ACOneConstant.DefaultRI);
        loadSV();
        _parametersForOne.getUDF1();
        _parametersForOne.getUDF2();
        _parametersForOne.getUDF3();

        setNewSession();
        loadVT();

        loadUniqueKeyForSDK();

        setSTS("0");
        _parametersForOne.setADELD(false);
        _parametersForOne.setADID(ACECONSTANT.DEFAULT_ADID);
        ACEParameterUtil.getAdvertisingIdInfo(_context, new ICallbackDoneAndFail() {
            @Override
            public void done(@Nullable JSONObject result) {
                try {
                    if (result != null) {
                        boolean _isAdTrackingEnabled = false;
                        if (result.has(ICallbackDoneAndFail_Result_JSON_KEY.IsAdTrackingEnabled)) {
                            _isAdTrackingEnabled = result.getBoolean(ICallbackDoneAndFail_Result_JSON_KEY.IsAdTrackingEnabled);
                        }
                        _parametersForOne.setADELD(_isAdTrackingEnabled);

                        String _adid = ACECONSTANT.DEFAULT_ADID;
                        if (result.has(ICallbackDoneAndFail_Result_JSON_KEY.ADID)) {
                            _adid = result.getString(ICallbackDoneAndFail_Result_JSON_KEY.ADID);
                        }
                        _parametersForOne.setADID(_adid);
                    }

                }
                catch (JSONException _ex) {
                    ACEDebugLog.wtf(TAG, new ACEException(_ex, "Occurred in adid done callback").toString());
                }
                finally {
                    callback.callback();
                }
            }

            @Override
            public void failed(@Nullable JSONObject result) {
                _parametersForOne.setADELD(false);
                _parametersForOne.setADID(ACECONSTANT.DEFAULT_ADID);
                callback.callback();
            }
        });
    }

    //region Parameter Helpers

    //region override

    //region except get url key
    @Override
    public boolean isExceptKeyInstance(@NonNull String key) {
        return ACEParameterUtilForOne.isExceptKey(key);
    }

    private static boolean isExceptKey(@NonNull String key) {
        switch (key) {
            case ParamsOneEnum_Key.PUSH:
                return true;
        }

        return false;
    }
    //endregion except get url key

    //region Common
    @Override
    public void setterForString(@NonNull String key, @Nullable String value) {
        if (StringUtils.isNull(value)) {
            value = "";
        }

        switch (key) {
            case "gsck":
                ACEParametersForOne.getInstance().setGSCK(value);
                break;
        }
    }

    @Nullable
    @Override
    public String getterForString(@NonNull String key) {
        switch (key) {
            case "gsck":
                return ACEParametersForOne.getInstance().getGSCK();
        }

        return null;
    }
    //endregion Common

    //region INSTALL_REFERRER
    @Override
    public void setReferrer(@NonNull Map<String, String> map) {
        ACEReducerForOne.referrer(
                map,
                null);
    }

    @Nullable
    @Override
    public String getInstallReferrer() {
        @Nullable
        String value = null;
        try {
            value = ACEParametersForOne.getInstance().getInstallReferrer();
        }
        catch (ClassCastException e) {
            value = null;
        }
        catch (Exception e) {
            value = null;
        }
        return value;
    }

    @Override
    public void setInstallReferrer(@Nullable String value) {
        ACEParametersForOne.getInstance().setInstallReferrer(value);
    }
    //endregion INSTALL_REFERRER

    //region parameter utils
    @Override
    public void loadUniqueKeyForSDK() {
        ACEParametersForOne.getInstance().setPcStampWhenNotStored();
    }

    @Override
    public void setFirstLogParameters() {
//        if (this.isFirstLog()) { }
    }

    @Override
    public void setLogSource(int value) {
        ACEParametersForOne.getInstance().setLOGSOURCE(value);
    }
    //endregion parameter utils

    //region request Header
    @Override
    public String getCookies() {
        return "";
    }
    //endregion request Header

    //region Session
    @Override
    public Boolean isFirstLog() {
        return getSession() == SESSION.NEW;
    }

    @Override
    public void resetSessionAndParameterAfterSend() {
        resetSessionAndParameterAfterSendWithParams(null);
    }

    @Override
    public void resetSessionAndParameterAfterSendWithParams(@Nullable Map<String, Object> params) {
        if (isFirstLog()) {
            setKeepSession();
        }

        if (params != null) {
            if (params.containsKey(ACEOneStaticConfig.ACOneConstantSt.KeyWillUpdateSt)) {
                @Nullable ACEntityForST _willUpdateSt = (ACEntityForST)params.get(ACEOneStaticConfig.ACOneConstantSt.KeyWillUpdateSt);
                if (_willUpdateSt != null) {
                    ACELog.d(TAG, "willUpdateSt 를 저장합니다.");
                    saveWithST(_willUpdateSt.getJSONObject());
                }
            }

            if (params.containsKey(ACEOneStaticConfig.ACOneConstantVt.KeyWillUpdateVt)) {
                @Nullable ACEntityForVT _willUpdateVt = (ACEntityForVT)params.get(ACEOneStaticConfig.ACOneConstantVt.KeyWillUpdateVt);
                if (_willUpdateVt != null) {
                    ACELog.d(TAG, "willUpdateVt 를 저장합니다.");
                    saveWithVT(_willUpdateVt.getJSONObject());
                }
            }
        }
    }

    @Override
    public void setNewSession() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setVK(SESSION.NEW);
    }

    @Override
    public synchronized int getSession() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getVK();
    }

    @Override
    public synchronized void setKeepSession() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setVK(SESSION.KEEP);
    }
    //endregion Session

    //endregion override

    //region Age
    public void clearAge() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setAG(0);
    }

    public int getAge() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getAG();
    }

    public void setAge(@Nullable Integer value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        if (value == null) {
            value = 0;
        }
        _parametersForOne.setAG(value);
    }
    //endregion Age

    //region BuyMode
    public void clearBuyMode() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setBuyModeToMD(ACEOneStaticConfig.IACBuyMode.Unknown);
    }

    @NonNull
    public String getBuyMode() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getMD();
    }

    public void setBuyMode(@Nullable @ACEOneStaticConfig.IACBuyMode String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        if (StringUtils.isNull(value)) {
            value = ACEOneStaticConfig.IACBuyMode.Unknown;
        }
        _parametersForOne.setBuyModeToMD(value);
    }
    //endregion BuyMode

    //region Gender
    public void clearGender() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setGD(null);
    }

    @NonNull
    public String getGender() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getGD();
    }

    public void setGender(String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setGD(value);
    }

    public void setGender(@Nullable ACEPublicStaticConfig.ACEGender value) {
        if (value != null) {
            setGender(value.getName());
        }
    }
    //endregion Gender

    //region ID
    public void clearID() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setID(null);
    }

    @NonNull
    public String getID() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getID();
    }

    public void setID(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        if (!TextUtils.isEmpty(value) && ACECommonStaticConfig.getEnablePrivacyPolicy()) {
            value = ACOneConstant.EnabledPrivacyPolicyUserID;
        }
        _parametersForOne.setID(value);
    }
    //endregion ID

    //region JN
    public void clearJn() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setJN(ACEOneStaticConfig.JN.Unknown);
    }

    public void setJn(int logSource) {
        String _jn = ACEOneStaticConfig.JN.Unknown;
        switch (logSource) {
            case ACEOneStaticConfig.ACEofAPIForOne.Join:
                _jn = ACEOneStaticConfig.JN.Join;
                break;
            case ACEOneStaticConfig.ACEofAPIForOne.Leave:
                _jn = ACEOneStaticConfig.JN.Withdraw;
                break;
        }

        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setJN(_jn);
    }
    //endregion JN

    //region Keyword
    public void clearKeyword() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSKEY(null);
    }

    @NonNull
    public String getKeyword() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getSKEY();
    }

    public void setKeyword(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSKEY(value);
    }
    //endregion Keyword

    //region KW
    public void clearKW() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setKW(null);
    }

    @NonNull
    public String getKW() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getKW();
    }

    public void setKW(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setKW(value);
    }
    //endregion KW

    //region MR
    public void clearMaritalStatus() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setMR(ACEPublicStaticConfig.ACEMaritalStatus.Unknown.getName());
    }

    @NonNull
    public String getMaritalStatus() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getMR();
    }

    public void setMaritalStatus(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setMR(value);
    }

    public void setMaritalStatus(@Nullable ACEPublicStaticConfig.ACEMaritalStatus value) {
        if (value != null) {
            setMaritalStatus(value.getName());
        }
    }
    //endregion MR

    //region OrderNumber
    public void clearOrderNumber() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setONUM(null);
    }

    @NonNull
    public String getOrderNumber() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getONUM();
    }

    public void setOrderNumber(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setONUM(value);
    }
    //endregion OrderNumber

    //region Pay
    public void clearPay() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setPayMethod(null);
    }

    @NonNull
    public String getPay() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getPayMethod();
    }

    public void setPay(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setPayMethod(value);
    }
    //endregion Pay

    //region Product
    public void clearProduct() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setLL(null);
    }

    @NonNull
    public String getProduct() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getLL();
    }

    public void setProduct(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setLL(value);
    }
    //endregion Product

    //region ProductCategoryName
    public void clearProductCategoryName() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setCT(null);
    }

    @NonNull
    public String getProductCategoryName() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getCT();
    }

    public void setProductCategoryName(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setCT(value);
    }
    //endregion ProductCategoryName

    //region ProductName
    public void clearProductName() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setPD(null);
    }

    @NonNull
    public String getProductName() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getPD();
    }

    public void setProductName(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setPD(value);
    }
    //endregion ProductName

    //region ProductPrice
    public void clearProductPrice() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setAMT(null);
    }

    @NonNull
    public String getProductPrice() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getAMT();
    }

    public void setProductPrice(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setAMT(value);
    }
    //endregion ProductPrice

    //region Ref
    public void clearRef() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setREF(null);
    }

    @NonNull
    public String getRef() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getREF();
    }

    public void setRef(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setREF(value);
    }

    public void setRefWithBundleID(@Nullable String value) {
        if (StringUtils.isNull(value)) {
            value = "";
        }

        value = StringUtils.onlyLetteringAtStartIndex(value);
        setRef(String.format(Locale.getDefault(), "%s/%s", _context.getPackageName(), value));
    }

    public void setRefForTel(@Nullable String value) {
        if (StringUtils.isNull(value)) {
            value = "";
        }

        value = StringUtils.onlyLetteringAtStartIndex(value);
        setRef(String.format(Locale.getDefault(), "tel:%s", value));
    }
    //endregion Ref

    //region Src
    public void clearSrc() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSRC(null);
    }

    @NonNull
    public String getSrc() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getSRC();
    }

    public void setSrc(@NonNull @ACEOneStaticConfig.SRC String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSRC(value);
    }
    //endregion Src

    //region ST
    // GetTS [S]
    @Nullable
    public Date getGetTS() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getGetTSWithDate();
    }

    @Nullable
    public String getGetTS6RandomSuffix() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getRandom6ForGetTS();
    }

    public void setGetTS(@Nullable Date value,
                         @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        _st.setGetTSWithDate(value);
        _st.setRandom6ForGetTS(random6Value);
    }
    // GetTS [E]

    // InsenginetTS [S]
    public void makeInsenginetTS() {
        @NonNull Date _now = new Date();
        @NonNull String _randomString = ACEParameterUtil.getRandomNumber6Length();

        setInsenginetTS(_now, _randomString);
    }

    @Nullable
    public Date getInsenginetTS() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getInsenginetTSWithDate();
    }

    public void setInsenginetTS(@Nullable Date value,
                                @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        _st.setInsenginetTSWithDate(value);
        _st.setRandom6ForInsenginetTS(random6Value);
    }

    public void setInsenginetTSAtObject(@NonNull ACEntityForST willUpdateSt,
                                        @Nullable Date value,
                                        @Nullable String random6Value) {
        willUpdateSt.setInsenginetTSWithDate(value);
        willUpdateSt.setRandom6ForInsenginetTS(random6Value);
    }
    // InsenginetTS [E]

    // RTS [S]
    @Nullable
    public String getRTS() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getRTS();
    }

    public void setRTS(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        _st.setRTS(value);
    }

    public void setRTS(@Nullable String value,
                       @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        _st.setRTS(value);
        _st.setRandom6ForRTS(random6Value);
    }
    // RTS [E]

    // StartTS [S]
    @Nullable
    public Date getStartTS() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getStartTSWithDate();
    }

    public void setStartTS(@Nullable Date value,
                           @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        _st.setStartTSWithDate(value);
        _st.setRandom6ForStartTS(random6Value);
    }

    @NonNull
    String getStartTSGoldMaster() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForST _st = _parametersForOne.getST();
        return _st.getStartTSGoldMaster();
    }
    // StartTS [E]

    public void loadST() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.loadST();
    }

    public void saveWithST(JSONObject json) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.saveWithST(json);
    }
    //endregion ST

    // STS [S]
    @NonNull
    public String getSTS() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getSTS();
    }

    public void setSTS(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSTS(value);
    }
    // STS [E]

    //region SV
    public void clearSV() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSV(null);
    }

    public void loadSV() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setSV(makeSV());
    }

    @NonNull
    public String makeSV() {
        return String.format(
                Locale.getDefault(),
                "%s%s%s",
                ACOneConstant.DefaultServiceCode,
                ACEParameterUtil.getSdkVersion(),
                ACOneConstant.DefaultNotCustomSDKForCustomer);
    }
    //endregion SV

    //region Update ST & VT
    public void updateSTnVT(@NonNull ACEntityForVT willUpdateVt) {
        @NonNull Date _now = new Date();
        @NonNull String _randomString = ACEParameterUtil.getRandomNumber6Length();
        if (isFirstLog()) {
            setStartTS(_now, _randomString);
            setSTS(getStartTSGoldMaster());

            @Nullable Date _vts = getVTSWithDate();
            if (_vts == null || _vts.getTime() == 0) {
                ACELog.d(TAG, "update vts");
                setVTS(_now, _randomString);
            }
            setVTSAtObject(
                    willUpdateVt,
                    _now,
                    _randomString);

            int visitCount = getVisitCount();
            if (visitCount == 0) {
                ACELog.d(TAG, "visitCount is 0");
                setVisitCountAtObject(willUpdateVt, 2);
            }
            else {
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "visitCount: %d", visitCount));
                setVisitCountAtObject(willUpdateVt, visitCount + 1);
            }

            // 최초 BuyTimeTS 초기화
           if (getBuyTimeTSWithDate() == null || getBuyTimeTSWithDate().getTime() == 0) {
               setBuyTimeTS(_now, _randomString);
               setBuyTimeTSAtObject(
                       willUpdateVt,
                       _now,
                       _randomString);
               setBuyCountAtObject(willUpdateVt, 1);
           }
        }

        setGetTS(_now, _randomString);
    }
    //endregion Update ST & VT

    //region TP
    public void setTP(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setTP(value);
    }
    //endregion TP

    //region URL
    public String getParametersToURL(@NonNull @ACEStaticConfig.HTTP_METHOD String method) {
        Uri.Builder builder = Uri.parse(ACEPolicyParameters.getInstance().getCpDomain()).buildUpon();
        if (method.equals(ACEStaticConfig.HTTP_METHOD.GET)) {
            try {
                JSONObject _params = getParamsToJSONobject();
                Iterator keys = _params.keys();

                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (!ACEParameterUtilForOne.isExceptKey(key)) {
                        builder.appendQueryParameter(key, _params.getString(key));
                    }
                }
            }
            catch (JSONException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, "JSONObject to GET URL 과정에 예외 발생").toString());
            }
        }

        return builder.toString();
    }

    public void setUrl(@Nullable String value) {
        if (StringUtils.isNull(value)) {
            value = "";
        }

        value = StringUtils.onlyLetteringAtStartIndex(value);
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setURL(
                String.format(
                        Locale.getDefault(),
                        "%s/%s", _context.getPackageName(), value));
    }

    public void updateUrlToRef(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setREF(_parametersForOne.getURL());
        setUrl(value);
    }
    //endregion URL

    //region USER ID
    public void clearUserID() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.setUserID(null);
    }

    @NonNull
    public String getUserID() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        return _parametersForOne.getUserID();
    }

    public void setUserID(@Nullable String value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        if (!TextUtils.isEmpty(value) && ACECommonStaticConfig.getEnablePrivacyPolicy()) {
            value = ACOneConstant.EnabledPrivacyPolicyUserID;
        }
        _parametersForOne.setUserID(value);
    }
    //endregion USER ID

    //region VT
    // BuyCount [S]
    public int getBuyCount() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getBuyCount();
    }

    public void setBuyCount(int value) {
        setBuyCount_nonInStorage(value);

        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        saveWithVT(_vt.getJSONObject());
    }

    public void setBuyCount_nonInStorage(int value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        _vt.setBuyCount(value);
    }

    public void setBuyCountAtObject(@NonNull ACEntityForVT willUpdateVt,
                                    int value) {
        willUpdateVt.setBuyCount(value);
    }
    // BuyCount [E]

    // BuyTimeTS [S]
    @Nullable
    public Date getBuyTimeTSWithDate() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getBuyTimeTSWithDate();
    }

    @Nullable
    public String getBuyTimeTS6RandomSuffix() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getRandom6ForBuyTimeTS();
    }

    public void setBuyTimeTS(@Nullable Date value,
                             @Nullable String random6Value) {
        setBuyTimeTS_nonInStorage(value, random6Value);

        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        saveWithVT(_vt.getJSONObject());
    }

    public void setBuyTimeTS_nonInStorage(@Nullable Date value,
                                          @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        _vt.setBuyTimeTSWithDate(value);
        _vt.setRandom6ForBuyTimeTS(random6Value);
    }

    public void setBuyTimeTSAtObject(@NonNull ACEntityForVT willUpdateVt,
                                     @Nullable Date value,
                                     @Nullable String random6Value) {
        willUpdateVt.setBuyTimeTSWithDate(value);
        willUpdateVt.setRandom6ForBuyTimeTS(random6Value);
    }
    // BuyTimeTS [E]

    // VisitCount [S]
    public int getVisitCount() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getVisitCount();
    }

    public void setVisitCount(int value) {
        setVisitCount_nonInStorage(value);

        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        saveWithVT(_vt.getJSONObject());
    }

    public void setVisitCount_nonInStorage(int value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        _vt.setVisitCount(value);
    }

    public void setVisitCountAtObject(@NonNull ACEntityForVT willUpdateVt,
                                      int value) {
        willUpdateVt.setVisitCount(value);
    }
    // VisitCount [E]

    // VTS [S]
    @Nullable
    public Date getVTSWithDate() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getVTSWithDate();
    }

    @Nullable
    public String getVTS6RandomSuffix() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getRandom6ForVTS();
    }

    public void setVTS(@Nullable Date value,
                       @Nullable String random6Value) {
        setVTS_nonInStorage(value, random6Value);

        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        saveWithVT(_vt.getJSONObject());
    }

    public void setVTS_nonInStorage(@Nullable Date value,
                                    @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        _vt.setVTSWithDate(value);
        _vt.setRandom6ForVTS(random6Value);
    }

    public void setVTSAtObject(@NonNull ACEntityForVT willUpdateVt,
                               @Nullable Date value,
                               @Nullable String random6Value) {
        willUpdateVt.setVTSWithDate(value);
        willUpdateVt.setRandom6ForVTS(random6Value);
    }
    // VTS [E]

    // PcStamp [S]
    @Nullable
    public Date getPcStampWithDate() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getPcStampWithDate();
    }

    @Nullable
    public String getPcStamp6RandomSuffix() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        return _vt.getRandom6ForPcStamp();
    }

    public void setPcStamp(@Nullable Date value,
                           @Nullable String random6Value) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        @NonNull ACEntityForVT _vt = _parametersForOne.getVT();
        _vt.setPcStampWithDate(value);
        _vt.setRandom6ForPcStamp(random6Value);
        saveWithVT(_vt.getJSONObject());
    }

    public void setPcStampAtObject(@NonNull ACEntityForVT willUpdateVt,
                                   @Nullable Date value,
                                   @Nullable String random6Value) {
        willUpdateVt.setPcStampWithDate(value);
        willUpdateVt.setRandom6ForPcStamp(random6Value);
    }
    // PcStamp [E]

    public void loadVT() {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        ACEntityForVT _vt = _parametersForOne.loadVT();
        try {
            ACELog.d(TAG, "loadVT::_vt: " + _vt.getJSONObject().toString(2));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void saveWithVT(JSONObject json) {
        ACEParametersForOne _parametersForOne = ACEParametersForOne.getInstance();
        _parametersForOne.saveWithVT(json);
    }
    //endregion VT

    //endregion Parameter Helpers

    //region JSON, toString
    @Override
    public JSONObject getParamsToJSONobject() throws JSONException {
        return ACEParametersForOne.getInstance().getParamsToJSONobject();
    }

    @Override
    public String toString() {
        try {
            return getParamsToJSONobject().toString(2);
        } catch (JSONException e) {
            ACEDebugLog.wtf(TAG, new ACEException(e, "getParamsToJSONobject().toString() 과정에 예외 발생").toString());
        }
        return super.toString();
    }
    //endregion JSON, toString
}
