package com.acecounter.android.acetm.acone.config;

import android.content.Context;

import androidx.annotation.IntDef;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringDef;

import com.acecounter.android.acetm.AceConfiguration;
import com.acecounter.android.acetm.acone.controltower.ACEControlTowerForOne;
import com.acecounter.android.acetm.acone.parameter.ACEInternalAPIForOne;
import com.acecounter.android.acetm.acone.parameter.ACEParameterUtilForOne;
import com.acecounter.android.acetm.acone.queue.ACEQueueManagerFactoryForOne;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.ICallbackOfTask;
import com.acecounter.android.acetm.common.queue.ACEQueueManagerFactory;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;

public final class ACEOneStaticConfig extends ACEStaticConfig {
    private static final String TAG = ACEOneStaticConfig.class.getSimpleName();

    private boolean _enablePrivacyPolicy;

    //region init
    public ACEOneStaticConfig() {
        this._controlTower = new ACEControlTowerForOne();
        this._queueManagerFactory = new ACEQueueManagerFactoryForOne();
        this._commonAPI = new ACEInternalAPIForOne();
    }
    //endregion init

    @Override
    public synchronized void configure(@NonNull final AceConfiguration configuration,
                                       @NonNull final ICallbackOfTask callback) {
        this._context = configuration.getApplication();
        this._enablePrivacyPolicy = configuration.getEnablePrivacyPolicy();
        this._gather = configuration.getGather();
        this._key = configuration.getKey();

        if (this._ignoreCaseActivityClassNameSet == null) {
            this._ignoreCaseActivityClassNameSet = new HashSet<>();
        }
        else {
            this._ignoreCaseActivityClassNameSet.clear();
        }
        this._ignoreCaseActivityClassNameSet.addAll(configuration.getIgnoreCase());

        ACEParameterUtilForOne.getInstance().initParameters(configuration.getApplication(), callback);
    }

    //region override methods
    @Nullable
    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public boolean getEnablePrivacyPolicy() {
        return this._enablePrivacyPolicy;
    }

    @Nullable
    @Override
    public String getEncryptKey() {
        return null;
    }

    @Override
    public String getKey() {
        return this._key;
    }

    @Override
    public boolean isGather() {
        return this._gather;
    }

    @Nullable
    @Override
    public HashSet<String> getIgnoreCaseActivityClassNameSet() {
        return this._ignoreCaseActivityClassNameSet;
    }
    //endregion override methods

    //region getter manager instances
    @Override
    public IACECommonAPI getCommonAPI() {
        return _commonAPI;
    }

    @Override
    public ACEControlTower getControlTower() {
        return _controlTower;
    }

    @Override
    public IACEParameterUtil getParameterUtil() {
        return ACEParameterUtilForOne.getInstance();
    }

    @Override
    public ACEQueueManagerFactory getQueueManagerFactory() {
        return _queueManagerFactory;
    }
    //endregion getter manager instances

    //region static
    @Nullable
    public static String getDescriptionAtACEofAPIForOne(int identifier) {
        switch (identifier) {
            case ACEofAPIForOne.AddInCart:
                return "AddInCart";
            case ACEofAPIForOne.DeleteInCart:
                return "DeleteInCart";

            case ACEofAPIForOne.TrackLinkEvent:
                return "TrackLinkEvent";
            case ACEofAPIForOne.TrackTelEvent:
                return "TrackTelEvent";

            case ACEofAPIForOne.PlWithPage:
                return "PlWithPage";
            case ACEofAPIForOne.AppearProduct:
                return "AppearProduct";
            case ACEofAPIForOne.Buy:
                return "Buy";

            case ACEofAPIForOne.Leave:
                return "Leave";
            case ACEofAPIForOne.Login:
                return "Login";
            case ACEofAPIForOne.Join:
                return "Join";

            case ACEofAPIForOne.Search:
                return "Search";

            case ACEofAPIForOne.JSONParamsSend:
                return "JSONParamsSend";
            case ACEofAPIForOne.OnPageFinished:
                return "OnPageFinished";
            case ACEofAPIForOne.PvWithParameters:
                return "PvWithParameters";
            case ACEofAPIForOne.SingleUsePvParametersWithPageNameStylePlain:
                return "SingleUsePvParametersWithPageNameStylePlain";
            case ACEofAPIForOne.SingleUsePvParametersWithPageNameStyleJson:
                return "SingleUsePvParametersWithPageNameStyleJson";
            case ACEofAPIForOne.SendNativeLog:
                return "SendNativeLog";
        }

        return null;
    }
    //endregion static

    //region enum

    //region 상수
    /**
     * 곳곳에서 사용하는 string 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACOneConstant.CustomSDKForCustomer,
            ACOneConstant.DefaultCE,
            ACOneConstant.DefaultNotCustomSDKForCustomer,
            ACOneConstant.DefaultRI,
            ACOneConstant.DefaultServiceCode,
            ACOneConstant.EnabledPrivacyPolicyUserID,
            ACOneConstant.JavascriptSuccessCallbackName,
            ACOneConstant.JavascriptFailCallbackName
    })
    public @interface ACOneConstant {
        String CustomSDKForCustomer = "1";
        String DefaultCE = "1";
        String DefaultNotCustomSDKForCustomer = "0";
        String DefaultRI = "1";
        String DefaultServiceCode = "ACA";
        String EnabledPrivacyPolicyUserID = "undefined_member";
        String JavascriptSuccessCallbackName = "callbackSuccessCommon";
        String JavascriptFailCallbackName = "callbackFailCommon";
    }

    /**
     * 곳곳에서 사용하는 int 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            ACOneConstantInteger.DefaultRE,
            ACOneConstantInteger.TimezoneArrayIndexAtAceServer,
            ACOneConstantInteger.VtVisitCountMax
    })
    public @interface ACOneConstantInteger {
        int DefaultRE = 0;
        int TimezoneArrayIndexAtAceServer = 29;
        int VtVisitCountMax = 11;
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACOneConstantSt.DefaultTS,
            ACOneConstantSt.KeyInStorage,
            ACOneConstantSt.KeyWillUpdateSt,

            ACOneConstantSt.KeyGetTS,
            ACOneConstantSt.KeyRandom6ForGetTS,

            ACOneConstantSt.KeyInsenginetTS,
            ACOneConstantSt.KeyRandom6ForInsenginetTS,

            ACOneConstantSt.KeyRTS,
            ACOneConstantSt.KeyRandom6ForRTS,

            ACOneConstantSt.KeyStartTS,
            ACOneConstantSt.KeyRandom6ForStartTS
    })
    public @interface ACOneConstantSt {
        String DefaultTS = "0";
        String KeyInStorage = "ac1_st";
        String KeyWillUpdateSt = "ac1_willUpdateSt";

        String KeyGetTS = "ac1_getTS";
        String KeyRandom6ForGetTS = "ac1_random6GetTS";

        String KeyInsenginetTS = "ac1_insenginetTS";
        String KeyRandom6ForInsenginetTS = "ac1_random6InsenginetTS";

        String KeyRTS = "ac1_rTS";
        String KeyRandom6ForRTS = "ac1_random6RTS";

        String KeyStartTS = "ac1_startTS";
        String KeyRandom6ForStartTS = "ac1_random6StartTS";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACOneConstantVt.DefaultTS,
            ACOneConstantVt.KeyInStorage,
            ACOneConstantVt.KeyWillUpdateVt,

            ACOneConstantVt.KeyBuyCount,

            ACOneConstantVt.KeyBuyTimeTS,
            ACOneConstantVt.KeyRandom6ForBuyTimeTS,

            ACOneConstantVt.KeyVisitCount,

            ACOneConstantVt.KeyVTS,
            ACOneConstantVt.KeyRandom6ForVTS,

            ACOneConstantVt.KeyPcStamp,
            ACOneConstantVt.KeyRandom6ForPcStamp
    })
    public @interface ACOneConstantVt {
        String DefaultTS = "0";
        String KeyInStorage = "ac1_vt";
        String KeyWillUpdateVt = "ac1_willUpdateVt";

        String KeyBuyCount = "ac1_buyCount";

        String KeyBuyTimeTS = "ac1_buyTimeTS";
        String KeyRandom6ForBuyTimeTS = "ac1_random6BuyTimeTS";

        String KeyVisitCount = "ac1_visitCount";

        String KeyVTS = "ac1_vTS";
        String KeyRandom6ForVTS = "ac1_random6VTS";

        String KeyPcStamp = "ac1_pcStamp";
        String KeyRandom6ForPcStamp = "ac1_random6pcStamp";
    }

    //region Parameter
    /**
     * 내부 API 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @IntDef({
            ACEofAPIForOne.AddInCart,
            ACEofAPIForOne.DeleteInCart,

            ACEofAPIForOne.TrackLinkEvent,
            ACEofAPIForOne.TrackTelEvent,

            ACEofAPIForOne.PlWithPage,
            ACEofAPIForOne.AppearProduct,
            ACEofAPIForOne.Buy,

            ACEofAPIForOne.Leave,
            ACEofAPIForOne.Login,
            ACEofAPIForOne.Join,

            ACEofAPIForOne.Search,

            ACEofAPIForOne.JSONParamsSend,
            ACEofAPIForOne.OnPageFinished,
            ACEofAPIForOne.PvWithParameters,
            ACEofAPIForOne.SingleUsePvParametersWithPageNameStylePlain,
            ACEofAPIForOne.SingleUsePvParametersWithPageNameStyleJson,
            ACEofAPIForOne.SendNativeLog})
    public @interface ACEofAPIForOne {
        int AddInCart = 110;
        int DeleteInCart = 111;

        int TrackLinkEvent = 130;
        int TrackTelEvent = 131;

        int PlWithPage = 100;
        int AppearProduct = 101;
        int Buy = 102;

        int Leave = 150;
        int Join = 151;
        int Login = 152;

        int Search = 190;

        int OnPageFinished = 160;
        int JSONParamsSend = 161;
        int PvWithParameters = 162;
        int SendNativeLog = 163;
        int SingleUsePvParametersWithPageNameStylePlain = 1989;
        int SingleUsePvParametersWithPageNameStyleJson = 1999;
    }

    /**
     * ACEReducerForOne 의 파라미터 key 상수
     */
    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            ACEReducerForOneAPIParamKey.AGE,
            ACEReducerForOneAPIParamKey.BuyMode,
            ACEReducerForOneAPIParamKey.CLICK_NAME,
            ACEReducerForOneAPIParamKey.CONTEXT,
            ACEReducerForOneAPIParamKey.ERROR_CODE,
            ACEReducerForOneAPIParamKey.GENDER,
            ACEReducerForOneAPIParamKey.JSON_OBJECT,
            ACEReducerForOneAPIParamKey.KEYWORD,
            ACEReducerForOneAPIParamKey.KW,
            ACEReducerForOneAPIParamKey.LinkName,
            ACEReducerForOneAPIParamKey.MARITAL_STATUS,
            ACEReducerForOneAPIParamKey.ORDER_NUMBER,
            ACEReducerForOneAPIParamKey.PAGE_NAME,
            ACEReducerForOneAPIParamKey.PARAMETERS,
            ACEReducerForOneAPIParamKey.PAYMENT_METHOD,
            ACEReducerForOneAPIParamKey.PHONE_NUMBER,
            ACEReducerForOneAPIParamKey.PRODUCT,
            ACEReducerForOneAPIParamKey.PRODUCT_CATEGORY,
            ACEReducerForOneAPIParamKey.PRODUCT_ImageURL,
            ACEReducerForOneAPIParamKey.PRODUCT_NAME,
            ACEReducerForOneAPIParamKey.PRODUCT_NUMBER,
            ACEReducerForOneAPIParamKey.PRODUCT_PRICE,
            ACEReducerForOneAPIParamKey.PRODUCT_QUERY,
            ACEReducerForOneAPIParamKey.PROMOTION_CODE,
            ACEReducerForOneAPIParamKey.PUSH,
            ACEReducerForOneAPIParamKey.QUERY,
            ACEReducerForOneAPIParamKey.REASON,
            ACEReducerForOneAPIParamKey.Tel,
            ACEReducerForOneAPIParamKey.TOTAL_PRICE,
            ACEReducerForOneAPIParamKey.UDF1,
            ACEReducerForOneAPIParamKey.UDF2,
            ACEReducerForOneAPIParamKey.UDF3,
            ACEReducerForOneAPIParamKey.USER_ID
    })
    public @interface ACEReducerForOneAPIParamKey {
        String AGE = "age";
        String BuyMode = "buyMode";
        String CLICK_NAME = "clickName";
        String CONTEXT = "context";
        String ERROR_CODE = "errCode";
        String GENDER = "gender";
        String JSON_OBJECT = "jsonObject";
        String KEYWORD = "keyword";
        String KW = "kw";
        String LinkName = "linkName";
        String MARITAL_STATUS = "maritalStatus";
        String ORDER_NUMBER = "orderNumber";
        String PAGE_NAME = "pageName";
        String PARAMETERS = "parameters";
        String PAYMENT_METHOD = "paymentMethod";
        String PHONE_NUMBER = "phoneNumber";
        String PRODUCT = "product";
        String PRODUCT_CATEGORY = "productCategory";
        String PRODUCT_ImageURL = "productImageURL";
        String PRODUCT_NAME = "productName";
        String PRODUCT_NUMBER = "productNumber";
        String PRODUCT_PRICE = "productPrice";
        String PRODUCT_QUERY = "productQuery";
        String PROMOTION_CODE = "promotionCode";
        String PUSH = "push";
        String QUERY = "query";
        String REASON = "reason";
        String Tel = "tel";
        String TOTAL_PRICE = "totalPrice";
        String UDF1 = "udf1";
        String UDF2 = "udf2";
        String UDF3 = "udf3";
        String USER_ID = "userID";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            IACBuyMode.Unknown,

            IACBuyMode.AddProductAtCart,
            IACBuyMode.Order,
            IACBuyMode.RemoveProductAtCart
    })
    public @interface IACBuyMode {
        String Unknown = "";

        String AddProductAtCart = "i";
        String Order = "b";
        String RemoveProductAtCart = "o";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            JN.Unknown,

            JN.Join,
            JN.Withdraw
    })
    public @interface JN {
        String Unknown = "";

        String Join = "join";
        String Withdraw = "withdraw";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef(value = {
            ParamsOneEnum_Key.ADID,
            ParamsOneEnum_Key.AG,
            ParamsOneEnum_Key.AMT,

            ParamsOneEnum_Key.CE,
            ParamsOneEnum_Key.Cookie,
            ParamsOneEnum_Key.CreateTime,
            ParamsOneEnum_Key.CT,

            ParamsOneEnum_Key.DM,

            ParamsOneEnum_Key.Error,
            ParamsOneEnum_Key.ErrorDebugDescription,

            ParamsOneEnum_Key.FailedCount,

            ParamsOneEnum_Key.GD,

            ParamsOneEnum_Key.ID,
            ParamsOneEnum_Key.IsNeedSetNewSession,

            ParamsOneEnum_Key.JN,

            ParamsOneEnum_Key.KW,

            ParamsOneEnum_Key.LG,
            ParamsOneEnum_Key.LL,
            ParamsOneEnum_Key.LOGSOURCE,

            ParamsOneEnum_Key.MD,
            ParamsOneEnum_Key.MID,
            ParamsOneEnum_Key.MR,

            ParamsOneEnum_Key.NONE,

            ParamsOneEnum_Key.ONUM,

            ParamsOneEnum_Key.Params,
            ParamsOneEnum_Key.Patch,
            ParamsOneEnum_Key.PAY,
            ParamsOneEnum_Key.PD,
            ParamsOneEnum_Key.PUSH,

            ParamsOneEnum_Key.RE,
            ParamsOneEnum_Key.REF,
            ParamsOneEnum_Key.REQUEST,
            ParamsOneEnum_Key.RI,

            ParamsOneEnum_Key.SKEY,
            ParamsOneEnum_Key.SRC,
            ParamsOneEnum_Key.ST,
            ParamsOneEnum_Key.StackTrace,
            ParamsOneEnum_Key.STS,
            ParamsOneEnum_Key.SV,

            ParamsOneEnum_Key.TaskHash,
            ParamsOneEnum_Key.TP,
            ParamsOneEnum_Key.TZ,

            ParamsOneEnum_Key.UDF1,
            ParamsOneEnum_Key.UDF2,
            ParamsOneEnum_Key.UDF3,
            ParamsOneEnum_Key.URL,
            ParamsOneEnum_Key.UserAgent,
            ParamsOneEnum_Key.UserID,

            ParamsOneEnum_Key.VK,
            ParamsOneEnum_Key.VT})
    public @interface ParamsOneEnum_Key {
        String ADELD = "adeld";
        String ADID = "adid";
        String AG = "ag";
        String AMT = "amt";

        String CE = "ce";
        String Cookie = "cookie";
        String CreateTime = "createtime";
        String CT = "ct";

        String DM = "dm";

        String Error = "error";
        String ErrorDebugDescription = "errorDebugDescription";

        String FailedCount = "failedCount";

        String GD = "gd";

        String ID = "id";
        String IsNeedSetNewSession = "isNeedSetNewSession";

        String JN = "jn";

        String KW = "kw";

        String LG = "lg";
        String LL = "ll";
        String LOGSOURCE = "logsource";

        String MD = "md";
        String MID = "mid";
        String MR = "mr";

        String NONE = "none";

        String ONUM = "onum";

        String Params = "params";
        String Patch = "patch";
        String PAY = "pay";
        String PD = "pd";
        String PUSH = "acp_push";

        String RE = "re";
        String REF = "ref";
        String REQUEST = "request";
        String RI = "ri";

        String SKEY = "skey";
        String SRC = "src";
        String ST = "st";
        String StackTrace = "stackTrace";
        String STS = "sts";
        String SV = "sv";

        String TaskHash = "taskHash";
        String TP = "tp";
        String TZ = "tz";

        String UDF1 = "udf1";
        String UDF2 = "udf2";
        String UDF3 = "udf3";
        String URL = "url";
        String UserAgent = "useragent";
        String UserID = "jid";

        String VK = "vk";
        String VT = "vt";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            SRC.Deeplink,
            SRC.InstallReferrer,
            SRC.Push
    })
    public @interface SRC {
        String Deeplink = "ACE_link";
        String InstallReferrer = "ACE_inst";
        String Push = "ACE_push";
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            TP.UNKNOWN,
            TP.CART,
            TP.LINK,
            TP.MCLICK,
            TP.SITE,
            TP.TEL
    })
    public @interface TP {
        String UNKNOWN = "unknown";
        String CART = "cart";
        String LINK = "link";
        String MCLICK = "mclick";
        String SITE = "site";
        String TEL = "tel";
    }
    //endregion Parameter

    //endregion enum
}
