package com.acecounter.android.acetm;

import android.content.Context;
import android.content.Intent;

import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.config.ACEOneStaticConfig;
import com.acecounter.android.acetm.acone.parameter.ACEReducerForOne;
import com.acecounter.android.acetm.acone.parameter.IACParamsAppearProductEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsBuilder;
import com.acecounter.android.acetm.acone.parameter.IACParamsBuyEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsCart;
import com.acecounter.android.acetm.acone.parameter.IACParamsJoinLeaveEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsLoginEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsSearchEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsTrackEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsTrackLinkEvent;
import com.acecounter.android.acetm.acone.parameter.IACParamsTrackTelEvent;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.util.StringUtils;
import com.acecounter.android.acetm.installreferrer.ACEInstallReferrerUtil;

import java.util.List;
import java.util.Locale;
import java.util.Map;

import static com.acecounter.android.acetm.common.util.ThreadUtil.runOnUiThread;

public final class ACSDK extends IAC {
    private static final String TAG = ACSDK.class.getSimpleName();

    //region 초기화
    @Keep
    @MainThread
    public static void configure(@NonNull final AceConfiguration configuration) {
        ACSDK.configureWithCallback(
                configuration,
                null);
    }

    @Keep
    @MainThread
    public static void configureWithCallback(@NonNull final AceConfiguration configuration,
                                             @Nullable final ICallbackOfACE doneWorkCallback) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                switch (configuration.getPlatform()) {
                    case ACEPublicStaticConfig.ACEPlatform.ACOne:
                        ACSDK._configure(
                                configuration,
                                doneWorkCallback);
                        break;
                    default: {
                        ACELog.w(TAG, "Please check the 'class'.");
                        ACELog.w(TAG, "Only use '" + TAG + "'.");
                    }
                }
            }
        });
    }

    @MainThread
    private static void _configure(@NonNull final AceConfiguration configuration,
                                   @Nullable final ICallbackOfACE doneWorkCallback) {
        // AceConfiguration [S]
        ACELog.i(TAG, "Initialize to '" + TAG + "'.");
        ACECommonStaticConfig.configure(
                configuration,
                doneWorkCallback);
        // AceConfiguration [E]
    }
    //endregion 초기화

    //region api
    @Keep
    @MainThread
    public static void send(@NonNull final IACParamsBuilder params) {
        if (params instanceof IACParamsBuyEvent) {
            ACELog.d(TAG, "IACParamsBuyEvent");
            IACParamsBuyEvent _params = (IACParamsBuyEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String payMethodName = StringUtils.getValueOrDefaultWhenNull(_params.getPayMethodName(), "");
            ACELog.d(TAG, "payMethodName: " + payMethodName);
            @Nullable String orderNumber = StringUtils.getValueOrDefaultWhenNull(_params.getOrderNumber(), "");
            ACELog.d(TAG, "orderNumber: " + orderNumber);

            @Nullable List<ACProduct> products = _params.getProducts();
            if (products != null) {
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "products: %s", products.toString()));
            } else {
                ACELog.d(TAG, "products is null");
            }

            ACEReducerForOne.buy(
                    context,
                    eventName,
                    payMethodName,
                    orderNumber,
                    products,
                    null);
        } else if (params instanceof IACParamsLoginEvent) {
            ACELog.d(TAG, "IACParamsLoginEvent");
            IACParamsLoginEvent _params = (IACParamsLoginEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String userId = StringUtils.getValueOrDefaultWhenNull(_params.getUserID(), "");
            ACELog.d(TAG, "userId: " + userId);
            @Nullable Integer userAge = _params.getAge();
            ACELog.d(TAG, "userAge: " + userId);
            @Nullable ACEPublicStaticConfig.ACEGender userGender = _params.getGender();
            if (userGender != null) {
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "userGender: %s", userGender.toString()));
            } else {
                ACELog.d(TAG, "userGender is null");
                userGender = ACEPublicStaticConfig.ACEGender.Unknown;
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "userGender: %s", userGender.toString()));
            }

            @Nullable ACEPublicStaticConfig.ACEMaritalStatus userMeritalStatus = _params.getMeritalStatus();
            if (userMeritalStatus != null) {
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "userMeritalStatus: %s", userMeritalStatus.toString()));
            } else {
                ACELog.d(TAG, "userMeritalStatus is null");
                userMeritalStatus = ACEPublicStaticConfig.ACEMaritalStatus.Unknown;
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "userMeritalStatus: %s", userMeritalStatus.toString()));
            }

            @NonNull ACEPublicStaticConfig.ACEParamsType _type = _params.getType();
            ACELog.d(TAG, "_type: " + _type);
            ACEReducerForOne.login(
                    context,
                    eventName,
                    userId,
                    userAge,
                    userGender,
                    userMeritalStatus,
                    null);
        } else if (params instanceof IACParamsJoinLeaveEvent) {
            ACELog.d(TAG, "IACParamsJoinLeaveEvent");
            IACParamsJoinLeaveEvent _params = (IACParamsJoinLeaveEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String userId = StringUtils.getValueOrDefaultWhenNull(_params.getUserID(), "");
            ACELog.d(TAG, "userId: " + userId);

            @NonNull ACEPublicStaticConfig.ACEParamsType _type = _params.getType();
            ACELog.d(TAG, "_type: " + _type);
            if (_type.equals(ACEPublicStaticConfig.ACEParamsType.Join)) {
                ACEReducerForOne.join(
                        context,
                        eventName,
                        userId,
                        null);
            } else if (_type.equals(ACEPublicStaticConfig.ACEParamsType.Leave)) {
                ACEReducerForOne.leave(
                        context,
                        eventName,
                        userId,
                        null);
            }
        } else if (params instanceof IACParamsAppearProductEvent) {
            ACELog.d(TAG, "IACParamsAppearProductEvent");
            IACParamsAppearProductEvent _params = (IACParamsAppearProductEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String productName = StringUtils.getValueOrDefaultWhenNull(_params.getProductName(), "");
            ACELog.d(TAG, "productName: " + productName);
            @Nullable String productCategoryName = StringUtils.getValueOrDefaultWhenNull(_params.getProductCategoryName(), "");
            ACELog.d(TAG, "productCategoryName: " + productCategoryName);
            @Nullable String productPrice = StringUtils.getValueOrDefaultWhenNull(_params.getProductPrice(), "");
            ACELog.d(TAG, "productPrice: " + productPrice);

            ACEReducerForOne.appearProduct(
                    context,
                    eventName,
                    productName,
                    productCategoryName,
                    productPrice,
                    null);
        } else if (params instanceof IACParamsCart) {
            ACELog.d(TAG, "IACParamsCart");
            IACParamsCart _params = (IACParamsCart) params;

            @Nullable Context context = _params.getContext();
            @Nullable List<ACProduct> products = _params.getProducts();
            if (products != null) {
                ACELog.d(TAG, String.format(
                        Locale.getDefault(),
                        "products: %s", products.toString()));
            } else {
                ACELog.d(TAG, "products is null");
            }

            @NonNull ACEPublicStaticConfig.ACEParamsType _type = _params.getType();
            ACELog.d(TAG, "_type: " + _type);
            int _logSource = ACEStaticConfig.ACEofAPI.Unknown;
            if (_type.equals(ACEPublicStaticConfig.ACEParamsType.AddInCart)) {
                _logSource = ACEOneStaticConfig.ACEofAPIForOne.AddInCart;
            } else if (_type.equals(ACEPublicStaticConfig.ACEParamsType.DeleteInCart)) {
                _logSource = ACEOneStaticConfig.ACEofAPIForOne.DeleteInCart;
            }

            ACEReducerForOne.cart(
                    _logSource,
                    context,
                    products,
                    null);
        } else if (params instanceof IACParamsTrackLinkEvent) {
            ACELog.d(TAG, "IACParamsTrackLinkEvent");
            IACParamsTrackLinkEvent _params = (IACParamsTrackLinkEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String linkName = StringUtils.getValueOrDefaultWhenNull(_params.getLinkName(), "");
            ACELog.d(TAG, "linkName: " + linkName);

            ACEReducerForOne.link(
                    context,
                    eventName,
                    linkName,
                    null);
        } else if (params instanceof IACParamsTrackTelEvent) {
            ACELog.d(TAG, "IACParamsTrackTelEvent");
            IACParamsTrackTelEvent _params = (IACParamsTrackTelEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String tel = StringUtils.getValueOrDefaultWhenNull(_params.getTel(), "");
            ACELog.d(TAG, "tel: " + tel);

            ACEReducerForOne.tel(
                    context,
                    eventName,
                    tel,
                    null);
        } else if (params instanceof IACParamsSearchEvent) {
            ACELog.d(TAG, "IACParamsSearchEvent");
            IACParamsSearchEvent _params = (IACParamsSearchEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);
            @Nullable String keyword = StringUtils.getValueOrDefaultWhenNull(_params.getKeyword(), "");
            ACELog.d(TAG, "keyword: " + keyword);

            ACEReducerForOne.search(
                    context,
                    eventName,
                    keyword,
                    null);
        } else if (params instanceof IACParamsTrackEvent) {
            ACELog.d(TAG, "IACParamsTrackEvent");
            IACParamsTrackEvent _params = (IACParamsTrackEvent) params;

            @Nullable Context context = _params.getContext();
            @Nullable String eventName = StringUtils.getValueOrDefaultWhenNull(_params.getEventName(), "");
            ACELog.d(TAG, "eventName: " + eventName);

            ACEReducerForOne.plWithPage(
                    context,
                    eventName,
                    null);
        } else {
            ACELog.d(TAG, "unknown");
        }
    }
    //endregion api

    //region Deeplink, push
    @Keep
    @MainThread
    public static void push(@NonNull Intent intent,
                            @Nullable Map<String, String> data) {
        if (data != null && data.containsKey(ACEOneStaticConfig.ParamsOneEnum_Key.KW)) {
            ACELog.v(TAG, String.format(Locale.getDefault(), "%s: %s",
                    ACEOneStaticConfig.ParamsOneEnum_Key.KW, data.get(ACEOneStaticConfig.ParamsOneEnum_Key.KW)));
            intent.putExtra(ACEOneStaticConfig.ParamsOneEnum_Key.KW, data.get(ACEOneStaticConfig.ParamsOneEnum_Key.KW));
        }
    }

    @Keep
    @MainThread
    public static void onNewIntent(@Nullable Intent intent) {
        ACEReducerForOne.onNewIntentByDeeplinkOrPush(
                intent,
                null);
    }

    @Keep
    public static void setInstallReferrer(@Nullable String referrer) {
        ACEInstallReferrerUtil.setInstallReferrer(referrer);
    }
    //endregion Deeplink, push
}
