package com.acecounter.android.acetm.webview;

import android.os.Build;
import android.webkit.JavascriptInterface;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acone.parameter.ACEParameterUtilForOne;
import com.acecounter.android.acetm.acone.parameter.ACEParametersForOne;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.parameter.IACECommonAPI;

import org.json.JSONException;
import org.json.JSONObject;

public final class AceWebViewInterface {
    private static final String TAG = AceWebViewInterface.class.getSimpleName();

    public static final String INTERFACE_NAME = ACEPublicStaticConfig.INTERFACE_NAME;

    public AceWebViewInterface() { }

    @JavascriptInterface
    public String appid() {
        return ACECommonStaticConfig.getKey();
    }

    @JavascriptInterface
    public boolean isHybridApp() {
        return true;
    }

    @JavascriptInterface
    public String getKey() {
        return ACECommonStaticConfig.getKey();
    }

    @JavascriptInterface
    public String getDevice() {
        return Build.MODEL;
    }

    @JavascriptInterface
    public String getTS() {
        try {
            ACEParameterUtilForOne.getInstance().loadST();
            @NonNull
            JSONObject _storedTS = new JSONObject();
            @NonNull
            JSONObject _st = ACEParametersForOne.getInstance().getST().getJSONObjectSimpleStyle();
            _storedTS.put("st", _st);
            @NonNull
            JSONObject _vt = ACEParametersForOne.getInstance().getVT().getJSONObjectSimpleStyle();
            _storedTS.put("vt", _vt);
            return _storedTS.toString();
        }
        catch (JSONException ex) {
            return "{}";
        }
        catch (Exception ex) {
            return "{}";
        }
    }

    @JavascriptInterface
    public void sendNativeLog(@Nullable String queryString) {
        if (queryString != null) {
            IACECommonAPI commonAPI = ACECommonStaticConfig.getCommonAPI();
            if (commonAPI != null) {
                commonAPI.send(ACEStaticConfig.ACEofAPI.SendByHybridAPI, queryString);
            }
        }
    }
}
