package com.acecounter.android.acetm.installreferrer;

import android.os.Handler;
import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.acecounter.android.acetm.acplus.config.ACEPlusStaticConfig;
import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.controltower.ACEControlTower;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;
import com.acecounter.android.acetm.common.parameter.ACEParameterUtil;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.util.StringUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class ACEInstallReferrerUtil {
    private static final String TAG = ACEInstallReferrerUtil.class.getSimpleName();

    private static Handler _handler;
    private static Runnable _installReferrerRunnable;

    public static void launchInstallReferrerHandler() {
        removeInstallReferrerHandler();

        if (!ACEControlTower.isInstallReferrerWaitDone()) {
            _installReferrerRunnable = new Runnable() {
                @Override
                public void run() {
                    ACELog.i(TAG, "Start wait install referrer.");
                    removeInstallReferrerHandler();
                    ACEControlTower.installReferrerWaitDone();
                }
            };

            _handler = new Handler();
            _handler.postDelayed(_installReferrerRunnable, ACEPlusStaticConfig.INSTALL_REFERRER_TIMEOUT);
        }
    }

    private static void removeInstallReferrerHandler() {
        if (_handler != null) {
            ACELog.i(TAG, "End wait install referrer.");
            if (_installReferrerRunnable != null) {
                _handler.removeCallbacks(_installReferrerRunnable);
                _installReferrerRunnable = null;
            }

            _handler = null;
        }
    }

    private static void setInstallReferrer(@Nullable String referrer,
                                           Boolean isNeedDecoding) {
        if (TextUtils.isEmpty(referrer)) {
            ACELog.d(TAG, "referrer is null.");
            return;
        }

        String resultDecode;
        if (isNeedDecoding) {
            try {
                resultDecode = URLDecoder.decode(referrer, ACECommonStaticConfig.CHARSET_UTF8);
            } catch (UnsupportedEncodingException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, "failed decoding 'referrer'.").toString());
                return;
            }
        }
        else {
            resultDecode = referrer;
        }

        if (TextUtils.isEmpty(resultDecode)) {
            ACELog.d(TAG, "result is null or empty at decoding 'referrer'.");
            return;
        }

        ACELog.d(TAG, "resultDecode: " + resultDecode);
        boolean _isDuplicateInstallReferrer = ACEInstallReferrerUtil.isDuplicateInstallReferrer(resultDecode);
        ACELog.d(TAG, "_isDuplicateInstallReferrer: " + _isDuplicateInstallReferrer);
        if (!_isDuplicateInstallReferrer) {
            IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
            if (_parameterUtil != null) {
                _parameterUtil.setReferrer(ACEParameterUtil.getURLToMap(resultDecode));
            }
        }
        else {
            ACELog.d(TAG, "referrer 를 업데이트하지 않습니다.." );
        }

        removeInstallReferrerHandler();
        ACEControlTower.installReferrerWaitDone();
    }

    private static boolean isDuplicateInstallReferrer(@Nullable String referrer) {
        if (!TextUtils.isEmpty(referrer)) {
            IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
            if (_parameterUtil != null) {
                @Nullable
                String beforeReferrer = _parameterUtil.getInstallReferrer();
                if (!StringUtils.isNull(beforeReferrer)) {
                    if (!beforeReferrer.equalsIgnoreCase(referrer)) {
                        try {
                            ACELog.d(TAG, "referrer: >>" + referrer + "<< 로 업데이트 합니다." );
                            _parameterUtil.setInstallReferrer(referrer);
                            return false;
                        }
                        catch (Exception e) {
                            ACEDebugLog.wtf(TAG, new ACEException(e, "setInstallReferrer() 과정에 Exception 예외 발생").toString());
                            return true;
                        }
                    }
                }
                else {
                    try {
                        ACELog.d(TAG, "referrer: >>" + referrer + "<< 로 첫 저장 합니다.");
                        _parameterUtil.setInstallReferrer(referrer);
                        return false;
                    }
                    catch (Exception e) {
                        ACEDebugLog.wtf(TAG, new ACEException(e, "setInstallReferrer() 과정에 Exception 예외 발생").toString());
                        return true;
                    }
                }
            }
        }

        return true;
    }

    public static void setInstallReferrer(@Nullable String referrer) {
        ACEInstallReferrerUtil.setInstallReferrer(
                referrer,
                false);
    }
}
