package com.acecounter.android.acetm.common.util;

import android.net.Uri;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;
import com.acecounter.android.acetm.common.config.ACEStaticConfig;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.parameter.IACEParameterUtil;
import com.acecounter.android.acetm.common.policy.ACEPolicyParameters;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Iterator;
import java.util.Map;

public final class URLUtils {
    private final static String TAG = URLUtils.class.getSimpleName();

    @NonNull
    public static String convertFailedLogJsonToGetURL(@NonNull @ACEStaticConfig.HTTP_METHOD String method,
                                                      @Nullable JSONObject jsonObject) {
        Uri.Builder builder = Uri.parse(ACEPolicyParameters.getInstance().getCpDomain()).buildUpon();
        if (method.equals(ACEStaticConfig.HTTP_METHOD.GET) && jsonObject != null) {
            try {
                if (jsonObject.has(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS)) {
                    JSONObject _params = jsonObject.getJSONObject(ACEStaticConfig.ACELOG_JSON_KEY.PARAMS);
                    Iterator keys = _params.keys();

                    IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
                    if (_parameterUtil != null) {
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            if (!_parameterUtil.isExceptKeyInstance(key)) {
                                builder.appendQueryParameter(key, _params.getString(key));
                            }
                        }
                    }
                }
            }
            catch (JSONException e) {
                ACEDebugLog.wtf(TAG, new ACEException(e, "JSONObject to GET URL 과정에 예외 발생").toString());
            }
        }

        return builder.toString();
    }

    @NonNull
    public static String convertMapToGetURL(@NonNull @ACEStaticConfig.HTTP_METHOD String method,
                                            @Nullable Map<String, String> map) {
        Uri.Builder builder = Uri.parse(ACEPolicyParameters.getInstance().getCpDomain()).buildUpon();
        if (method.equals(ACEStaticConfig.HTTP_METHOD.GET) && map != null) {
            IACEParameterUtil _parameterUtil = ACECommonStaticConfig.getParameterUtil();
            if (_parameterUtil != null) {
                for (String key : map.keySet()) {
                    if (!_parameterUtil.isExceptKeyInstance(key)) {
                        builder.appendQueryParameter(key, map.get(key));
                    }
                }
            }
        }

        return builder.toString();
    }
}
