package com.acecounter.android.acetm.common.util;

import androidx.annotation.NonNull;

import com.acecounter.android.acetm.common.config.ACEStaticConfig;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class TimeUtils {
    @NonNull
    public static String dateToACEDateFormatString(@NonNull Date date) {
        return TimeUtils.dateToDateFormatString(ACEStaticConfig.ACECONSTANT.TASK_CREATE_TIME_FORMAT, date);
    }

    @NonNull
    public static String dateToDateFormatString(@NonNull String pattern, @NonNull Date date) {
        return new SimpleDateFormat(pattern, Locale.KOREA).format(date);
    }
}
