package com.acecounter.android.acetm.common.util;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.regex.Pattern;

public final class StringUtils {
    private static final Pattern letteringPattern = Pattern.compile("^[\\w].*");

    public static boolean isLetterAtStringStartIndex(@NonNull String value) {
        return letteringPattern.matcher(value).matches();
    }

    public static boolean isNull(@Nullable String value) {
        return value == null;
    }

    @NonNull
    public static String getValueOrDefault(@Nullable String value, @NonNull String defaultValue) {
        return !TextUtils.isEmpty(value) ? value : defaultValue;
    }

    @NonNull
    public static String getValueOrDefaultWhenNull(@Nullable String value, @NonNull String defaultValue) {
        return !StringUtils.isNull(value) ? value : defaultValue;
    }

    @NonNull
    public static String onlyLetteringAtStartIndex(@NonNull String value) {
        if (!TextUtils.isEmpty(value)) {
            while (!StringUtils.isLetterAtStringStartIndex(value)) {
                value = value.substring(1);
                if (TextUtils.isEmpty(value)) {
                    break;
                }
            }
        }

        return value;
    }
}
