package com.acecounter.android.acetm.common.util;

import android.content.SharedPreferences;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.ACProduct;
import com.acecounter.android.acetm.common.logger.ACEDebugLog;
import com.acecounter.android.acetm.common.logger.ACEException;
import com.acecounter.android.acetm.common.logger.ACELog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class JsonUtil {
    private static final String TAG = JsonUtil.class.getSimpleName();

    public static JSONArray remove(final int idx, final JSONArray from) {
        final List<JSONObject> objs = asList(from);
        objs.remove(idx);

        final JSONArray ja = new JSONArray();
        for (final JSONObject obj : objs) {
            ja.put(obj);
        }

        return ja;
    }

    @NonNull
    public static JSONArray removeIndexCount(final int startIndex, final int count, final JSONArray from)
            throws IndexOutOfBoundsException, UnsupportedOperationException {
        final List<JSONObject> objs = asList(from);
        ACELog.v(TAG, String.format(Locale.getDefault(), "startIndex: %d, count: %d", startIndex, count));
        for (int i = 0; i < count; ++i) {
            ACELog.v(TAG, String.format(Locale.getDefault(), "(count - 1) + (startIndex - i): %d",
                    ((count - 1) + (startIndex - i))));
            objs.remove((count - 1) + (startIndex - i));
//            JSONObject removedObject = objs.remove((count - 1) + (startIndex - i));
//            try {
//                Log.d(TAG, "removedObject, " + i + ": " + removedObject.toString(2));
//            }
//            catch (JSONException e) {
//                e.printStackTrace();
//            }
        }

        final JSONArray ja = new JSONArray();
        for (final JSONObject obj : objs) {
            ja.put(obj);
        }

        return ja;
    }

    private static List<JSONObject> asList(final JSONArray ja) {
        final int len = ja.length();
        final ArrayList<JSONObject> result = new ArrayList<JSONObject>(len);
        for (int i = 0; i < len; i++) {
            final JSONObject obj = ja.optJSONObject(i);
            if (obj != null) {
                result.add(obj);
            }
        }
        return result;
    }

    @Nullable
    @SuppressWarnings({"unchecked"})
    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        return (Map<String, Object>)JsonUtil.jsonThingToAppropriateJavaObject(json);
    }

    @Nullable
    @SuppressWarnings({"unchecked"})
    public static List<Object> jsonArrayToMap(JSONArray jsonArray) throws JSONException {
        return (List<Object>)JsonUtil.jsonThingToAppropriateJavaObject(jsonArray);
    }

    @Nullable
    private static Object jsonThingToAppropriateJavaObject(Object jsonThing) throws JSONException {
        if (jsonThing instanceof JSONArray) {
            final ArrayList<Object> list = new ArrayList<>();

            final JSONArray jsonArray = (JSONArray) jsonThing;
            final int l = jsonArray.length();
            for (int i = 0; i < l; ++i) {
                list.add(jsonThingToAppropriateJavaObject(jsonArray.get(i)));
            }
            return list;
        }

        if (jsonThing instanceof JSONObject) {
            final HashMap<String, Object> map = new HashMap<>();

            final Iterator<String> keysItr = ((JSONObject) jsonThing).keys();
            while (keysItr.hasNext()) {
                final String key = keysItr.next();
                map.put(key, jsonThingToAppropriateJavaObject(((JSONObject) jsonThing).get(key)));
            }
            return map;
        }

        if (JSONObject.NULL.equals(jsonThing)) {
            return null;
        }

        return jsonThing;
    }

    @NonNull
    public static JSONObject getJSONObjectInStorage(@NonNull SharedPreferences sharedPreferences,
                                                    @NonNull String key,
                                                    @NonNull String defaultValue) throws JSONException {
        JSONObject _json = null;
        String _jsonString = sharedPreferences.getString(key, defaultValue);
        try {
            if (!TextUtils.isEmpty(_jsonString)) {
                _json = new JSONObject(_jsonString);
            }
        } catch (RuntimeException e) {
            ACEDebugLog.wtf(
                    TAG,
                    new ACEException(
                            e,
                            String.format(
                                    Locale.getDefault(),
                                    "저장된 %s 값을 불러오는 과정에 예외 발생", key)).toString());
        }
        finally {
            if (_json == null) {
                _json = new JSONObject();
            }
        }

        return _json;
    }

    @NonNull
    public static ArrayList<ACProduct> jsonArrayToACProduct(@Nullable JSONArray jsonArray) {
        ArrayList<ACProduct> products = new ArrayList<>();

        if (jsonArray == null) {
            return products;
        }

        try {
            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject _json = jsonArray.getJSONObject(i);
                String name = _json.getString("name");
                String category = _json.getString("category");
                String price = _json.getString("price");
                int quantity = _json.getInt("quantity");
                String productId = _json.getString("productId");
                String optionCodeName = _json.getString("optionCodeName");

                @NonNull ACProduct _product = new ACProduct(
                        name,
                        category,
                        price,
                        quantity,
                        productId,
                        optionCodeName);
                products.add(_product);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }


        return products;
    }
}
