package com.acecounter.android.acetm.common.util;

import androidx.annotation.NonNull;
import android.util.Base64;

import com.acecounter.android.acetm.common.config.ACECommonStaticConfig;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class EncryptUtil {
    private String iv;
    private Key keySpec;

    EncryptUtil(@NonNull String key)
            throws EncryptKeyException, UnsupportedEncodingException {
        byte[] keyBytes = key.getBytes(ACECommonStaticConfig.CHARSET_UTF8);

        if (keyBytes.length != 16) {
            throw new EncryptKeyException(key);
        }

        this.iv = key.substring(0, 16);
        this.keySpec = new SecretKeySpec(keyBytes, "AES");
    }

    String aesEncode(String str)
            throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException,
            NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException,
            InvalidKeyException {
        // NoSuchAlgorithmException, NoSuchPaddingException
        Cipher encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        // InvalidAlgorithmParameterException, InvalidKeyException
        encryptCipher.init(Cipher.ENCRYPT_MODE, keySpec, new IvParameterSpec(iv.getBytes()));
        // BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException
        byte[] encrypted = encryptCipher.doFinal(str.getBytes(ACECommonStaticConfig.CHARSET_UTF8));

        return Base64.encodeToString(encrypted, Base64.DEFAULT);
    }

    String aesDecode(String str)
            throws UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException,
            NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException,
            InvalidKeyException {
        // NoSuchAlgorithmException, NoSuchPaddingException
        Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        // InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException
        decryptCipher.init(Cipher.DECRYPT_MODE, keySpec, new IvParameterSpec(iv.getBytes(ACECommonStaticConfig.CHARSET_UTF8)));
        // BadPaddingException, IllegalBlockSizeException
        byte[] byteStr = decryptCipher.doFinal(Base64.decode(str, Base64.DEFAULT));
        if (byteStr == null) {
            throw new BadPaddingException("암호화 결과가 null 입니다.");
        } else {
            // UnsupportedEncodingException
            return new String(byteStr, ACECommonStaticConfig.CHARSET_UTF8);
        }
    }

    Cipher getEncryptCipher()
            throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException,
            NoSuchAlgorithmException {
        Cipher encryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        encryptCipher.init(Cipher.ENCRYPT_MODE, keySpec, new IvParameterSpec(iv.getBytes()));
        return encryptCipher;
    }

    Cipher getDecryptCipher()
            throws NoSuchPaddingException, NoSuchAlgorithmException, UnsupportedEncodingException,
            InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        decryptCipher.init(Cipher.DECRYPT_MODE, keySpec, new IvParameterSpec(iv.getBytes(ACECommonStaticConfig.CHARSET_UTF8)));

        return decryptCipher;
    }
}


