package com.acecounter.android.acetm.common.util;

import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.acecounter.android.acetm.common.config.ACEPublicStaticConfig;

public final class ACEMaritalStatusUtils {
    @NonNull
    public static ACEPublicStaticConfig.ACEMaritalStatus stringToACEMaritalStatusName(@Nullable String value) {
        if (TextUtils.isEmpty(value)) {
            return ACEPublicStaticConfig.ACEMaritalStatus.Unknown;
        }

        if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEMaritalStatus.Married.getName())) {
            return ACEPublicStaticConfig.ACEMaritalStatus.Married;
        }
        else if (value.equalsIgnoreCase(ACEPublicStaticConfig.ACEMaritalStatus.Single.getName())) {
            return ACEPublicStaticConfig.ACEMaritalStatus.Single;
        }
        else {
            return ACEPublicStaticConfig.ACEMaritalStatus.Unknown;
        }
    }
}
